/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.editors.GeneralTITANAutoEditStrategy;

public final class ClosingBracketIndentationAutoEditStrategy
extends GeneralTITANAutoEditStrategy {
    private static final String CLOSING_CURLY_BRACKET = "}";

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!CLOSING_CURLY_BRACKET.equals(command.text)) {
            return;
        }
        this.refreshAutoEditStrategy();
        this.initializeRootInterval(document);
        if (this.rootInterval == null) {
            return;
        }
        try {
            StringBuilder builder = new StringBuilder(document.get());
            if (this.isWithinMultiLineComment(command.offset) || this.isWithinString(builder, command.offset)) {
                return;
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.smartInsertAfterBracket(document, command);
    }

    protected void smartInsertAfterBracket(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            int indLine;
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            if (whiteend == command.offset && (indLine = this.findMatchingOpenBracket(document, command.offset)) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(document, indLine, command));
                replaceText.append(command.text);
                command.length = command.offset - start;
                command.offset = start;
                command.text = replaceText.toString();
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }
}

