/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.titan.designer.properties.pages.CCompilerOptionsPage;
import org.eclipse.titan.designer.properties.pages.COptimalizationOptionsPage;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.LinkerFlagsOptionsPage;
import org.eclipse.titan.designer.properties.pages.LinkerLibrariesOptionsPage;
import org.eclipse.titan.designer.properties.pages.LinkerOptionsPage;
import org.eclipse.titan.designer.properties.pages.OptionElement;
import org.eclipse.titan.designer.properties.pages.OptionElementContentProvider;
import org.eclipse.titan.designer.properties.pages.OptionElementLabelProvider;
import org.eclipse.titan.designer.properties.pages.PlatformSpecificLibrariesOptionsPage;
import org.eclipse.titan.designer.properties.pages.PreprocessorIncludedOptionsPage;
import org.eclipse.titan.designer.properties.pages.PreprocessorOptionsPage;
import org.eclipse.titan.designer.properties.pages.PreprocessorSymbolsOptionsPage;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;
import org.eclipse.titan.designer.properties.pages.TITANFlagsOptionsPage;
import org.eclipse.titan.designer.properties.pages.TTCN3PreprocessorOptionsPage;

public final class InternalMakefileCreationTab {
    private TabItem newBuildPropertiesTabItem;
    private Composite newBuildPropertiesComposite;
    private TreeViewer optionList;
    private final TTCN3PreprocessorOptionsPage ttcn3PreprocessorPage = new TTCN3PreprocessorOptionsPage(true);
    private final PreprocessorSymbolsOptionsPage ttcn3PreprocessorSymbolsPage = new PreprocessorSymbolsOptionsPage(true);
    private final PreprocessorIncludedOptionsPage ttcn3PreprocessorIncludesPage;
    private final TITANFlagsOptionsPage titanFlagsPage = new TITANFlagsOptionsPage(true);
    private final PreprocessorOptionsPage preprocessorPage = new PreprocessorOptionsPage();
    private final PreprocessorSymbolsOptionsPage preprocessorSymbolsPage = new PreprocessorSymbolsOptionsPage(false);
    private final PreprocessorIncludedOptionsPage preprocessorIncludesPage;
    private final CCompilerOptionsPage cCompilerPage = new CCompilerOptionsPage();
    private final COptimalizationOptionsPage optimizationPage = new COptimalizationOptionsPage();
    private final PlatformSpecificLibrariesOptionsPage solarisLibrariesPage = new PlatformSpecificLibrariesOptionsPage("Solaris");
    private final PlatformSpecificLibrariesOptionsPage solaris8LibrariesPage = new PlatformSpecificLibrariesOptionsPage("Solaris8");
    private final PlatformSpecificLibrariesOptionsPage freeBSDLibrariesPage = new PlatformSpecificLibrariesOptionsPage("FreeBSD");
    private final PlatformSpecificLibrariesOptionsPage linuxLibrariesPage = new PlatformSpecificLibrariesOptionsPage("Linux");
    private final PlatformSpecificLibrariesOptionsPage win32LibrariesPage = new PlatformSpecificLibrariesOptionsPage("Win32");
    private final LinkerOptionsPage linkerPage = new LinkerOptionsPage();
    private final LinkerLibrariesOptionsPage linkerLibrariesPage;
    private final LinkerFlagsOptionsPage linkerFlagsOptionsPage = new LinkerFlagsOptionsPage();
    private final IOptionsPage[] pages;
    private final IProject project;
    private IOptionsPage actualPage = null;
    private Composite settingsPageContainer;
    private ScrolledComposite containerSC;

    public InternalMakefileCreationTab(IProject project) {
        this.project = project;
        this.ttcn3PreprocessorIncludesPage = new PreprocessorIncludedOptionsPage(project, true);
        this.preprocessorIncludesPage = new PreprocessorIncludedOptionsPage(project, false);
        this.linkerLibrariesPage = new LinkerLibrariesOptionsPage(project);
        this.pages = new IOptionsPage[]{this.ttcn3PreprocessorPage, this.ttcn3PreprocessorSymbolsPage, this.ttcn3PreprocessorIncludesPage, this.titanFlagsPage, this.preprocessorPage, this.preprocessorSymbolsPage, this.preprocessorIncludesPage, this.cCompilerPage, this.optimizationPage, this.solarisLibrariesPage, this.solaris8LibrariesPage, this.freeBSDLibrariesPage, this.linuxLibrariesPage, this.win32LibrariesPage, this.linkerPage, this.linkerLibrariesPage, this.linkerFlagsOptionsPage};
    }

    public void dispose() {
        this.newBuildPropertiesTabItem.dispose();
        this.newBuildPropertiesComposite.dispose();
        this.settingsPageContainer.dispose();
        this.containerSC.dispose();
        for (IOptionsPage page : this.pages) {
            page.dispose();
        }
    }

    protected TabItem createContents(TabFolder tabFolder) {
        this.newBuildPropertiesTabItem = new TabItem(tabFolder, 2048);
        this.newBuildPropertiesTabItem.setText("Internal makefile creation attributes");
        this.newBuildPropertiesTabItem.setToolTipText("Settings controlling the new generation of the makefile.");
        this.newBuildPropertiesComposite = new Composite((Composite)tabFolder, 2);
        this.newBuildPropertiesComposite.setEnabled(true);
        this.newBuildPropertiesComposite.setLayout((Layout)new GridLayout());
        SashForm sashForm = new SashForm(this.newBuildPropertiesComposite, 0);
        sashForm.setOrientation(256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.optionList = new TreeViewer((Composite)sashForm, 2820);
        this.optionList.setContentProvider((IContentProvider)new OptionElementContentProvider());
        this.optionList.setLabelProvider((IBaseLabelProvider)new OptionElementLabelProvider());
        this.optionList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InternalMakefileCreationTab.this.handleSelectionChanged();
            }
        });
        OptionElement root = new OptionElement("root");
        OptionElement ttcn3preprocessor = new OptionElement("TTCN-3 Preprocessor", this.ttcn3PreprocessorPage);
        root.addChild(ttcn3preprocessor);
        ttcn3preprocessor.addChild(new OptionElement("Symbols (define, undefine)", this.ttcn3PreprocessorSymbolsPage));
        ttcn3preprocessor.addChild(new OptionElement("Included directories", this.ttcn3PreprocessorIncludesPage));
        OptionElement titan = new OptionElement("TITAN");
        root.addChild(titan);
        titan.addChild(new OptionElement("Flags", this.titanFlagsPage));
        OptionElement preprocessor = new OptionElement("Preprocessor", this.preprocessorPage);
        root.addChild(preprocessor);
        preprocessor.addChild(new OptionElement("Symbols (define, undefine)", this.preprocessorSymbolsPage));
        preprocessor.addChild(new OptionElement("Included directories", this.preprocessorIncludesPage));
        OptionElement compiler = new OptionElement("C++ compiler", this.cCompilerPage);
        root.addChild(compiler);
        compiler.addChild(new OptionElement("Optimization", this.optimizationPage));
        OptionElement platform = new OptionElement("Platform specific libraries");
        root.addChild(platform);
        platform.addChild(new OptionElement("Solaris", this.solarisLibrariesPage));
        platform.addChild(new OptionElement("Solaris8", this.solaris8LibrariesPage));
        platform.addChild(new OptionElement("FreeBSD", this.freeBSDLibrariesPage));
        platform.addChild(new OptionElement("Linux", this.linuxLibrariesPage));
        platform.addChild(new OptionElement("Win32", this.win32LibrariesPage));
        OptionElement linker = new OptionElement("Linker", this.linkerPage);
        root.addChild(linker);
        linker.addChild(new OptionElement("Libraries", this.linkerLibrariesPage));
        linker.addChild(new OptionElement("Options", this.linkerFlagsOptionsPage));
        this.optionList.setInput((Object)root);
        this.containerSC = new ScrolledComposite((Composite)sashForm, 768);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new GridLayout());
        GridData data = new GridData();
        data.exclude = true;
        this.settingsPageContainer.setLayoutData((Object)data);
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.containerSC.setMinSize(this.settingsPageContainer.computeSize(-1, -1));
        for (IOptionsPage page : this.pages) {
            Composite comp = page.createContents(this.settingsPageContainer);
            comp.setVisible(false);
            ((GridData)comp.getLayoutData()).exclude = true;
        }
        this.settingsPageContainer.layout();
        this.newBuildPropertiesTabItem.setControl((Control)this.newBuildPropertiesComposite);
        return this.newBuildPropertiesTabItem;
    }

    private void handleSelectionChanged() {
        if (this.optionList == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.optionList.getSelection();
        OptionElement element = (OptionElement)selection.getFirstElement();
        if (element != null) {
            IOptionsPage next = element.page;
            if (next != null) {
                Composite comp;
                if (this.actualPage != null) {
                    comp = this.actualPage.createContents(this.settingsPageContainer);
                    comp.setVisible(false);
                    ((GridData)comp.getLayoutData()).exclude = true;
                }
                comp = next.createContents(this.settingsPageContainer);
                comp.setVisible(true);
                ((GridData)comp.getLayoutData()).exclude = false;
                this.actualPage = next;
                this.containerSC.setMinSize(comp.computeSize(-1, -1));
                this.settingsPageContainer.layout();
            } else {
                if (this.actualPage != null) {
                    Composite comp = this.actualPage.createContents(this.settingsPageContainer);
                    comp.setVisible(false);
                    ((GridData)comp.getLayoutData()).exclude = true;
                }
                this.actualPage = null;
                this.containerSC.setMinSize(0, 0);
                this.settingsPageContainer.layout();
            }
        }
    }

    protected void setMakefileGenerationEnabled(boolean value) {
        if (this.optionList != null) {
            this.optionList.getControl().setEnabled(value);
        }
        if (this.actualPage != null) {
            this.actualPage.setEnabled(value);
        }
    }

    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        for (IOptionsPage page : this.pages) {
            page.copyPropertyStore(project, tempStorage);
        }
    }

    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        boolean result = false;
        for (IOptionsPage page : this.pages) {
            result |= page.evaluatePropertyStore(project, tempStorage);
        }
        return result;
    }

    protected void performDefaults() {
        for (IOptionsPage page : this.pages) {
            page.performDefaults();
        }
        this.setMakefileGenerationEnabled(true);
    }

    public boolean checkProperties(ProjectBuildPropertyPage page) {
        boolean result = true;
        for (int i = 0; i < this.pages.length; ++i) {
            result &= this.pages[i].checkProperties(page);
        }
        return result;
    }

    public void loadProperties(IProject project) {
        for (IOptionsPage page : this.pages) {
            page.loadProperties(project);
        }
    }

    public boolean saveProperties(IProject project) {
        boolean result = true;
        for (IOptionsPage page : this.pages) {
            result &= page.saveProperties(project);
        }
        return result;
    }
}

