/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.titan.designer.properties.pages.FolderListItemDialog;
import org.eclipse.titan.designer.properties.pages.MyListControl;

public class MyFolderListControl
extends MyListControl {
    private final String basePath;

    public MyFolderListControl(Composite parent, String basePath, String title, String itemDescription) {
        super(parent, title, itemDescription);
        this.basePath = basePath;
    }

    @Override
    protected void addNewItem() {
        FolderListItemDialog dialog = new FolderListItemDialog(this.list.getShell(), this.basePath, "Add new " + this.itemDescription, this.itemDescription, "");
        if (dialog.open() != 0) {
            return;
        }
        String newItem = dialog.getItem();
        if (newItem != null && newItem.length() > 0) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(newItem, index + 1);
                this.list.setSelection(index + 1);
            } else {
                int size = this.list.getItemCount();
                this.list.add(newItem, size);
                this.list.setSelection(size);
            }
        }
        this.selectionChanged();
    }

    @Override
    protected void editSelectedItem() {
        int index = this.list.getSelectionIndex();
        if (index != -1) {
            String item = this.list.getItem(index);
            FolderListItemDialog dialog = new FolderListItemDialog(this.list.getShell(), this.basePath, "Edit " + this.itemDescription, this.itemDescription, item);
            if (dialog.open() != 0) {
                return;
            }
            String newItem = dialog.getItem();
            if (newItem != null && newItem.length() > 0 && !newItem.equals(item)) {
                this.list.setItem(index, newItem);
                this.selectionChanged();
            }
        }
    }
}

