/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.export;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.IOUtils;

public class ExportedProblemMerger {
    private final List<File> files;
    private final File outfile;
    private String msg;
    private HSSFWorkbook outbook;
    private HSSFSheet summarysheet;
    private String project;
    private final SortedSet<Date> dates;
    private final Map<Date, Integer> datecol;
    private final Map<Date, File> datefile;
    private final Map<String, Integer> smellrow;
    private int smellindex;

    public ExportedProblemMerger(List<File> files, File outfile) {
        this.files = files;
        this.outfile = outfile;
        this.dates = new TreeSet<Date>();
        this.datecol = new HashMap<Date, Integer>();
        this.datefile = new HashMap<Date, File>();
        this.smellrow = new HashMap<String, Integer>();
        this.smellindex = 2;
    }

    public String getErrorMessage() {
        return this.msg;
    }

    private HSSFWorkbook createWorkbook() {
        HSSFWorkbook workbook = null;
        try {
            InputStream in = ExportedProblemMerger.class.getResourceAsStream("ProblemMarkers.xlt");
            if (in == null) {
                if (!this.outfile.exists()) {
                    this.outfile.createNewFile();
                }
                workbook = new HSSFWorkbook();
                workbook.createSheet("Summary");
                workbook.setSheetOrder("Summary", 0);
            } else {
                workbook = new HSSFWorkbook(new POIFSFileSystem(in), true);
                in.close();
            }
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while creating merged excel", (Throwable)e);
        }
        return workbook;
    }

    private String getProjectName(HSSFSheet sheet) {
        HSSFCell cell = sheet.getRow(0).getCell(0);
        String value = cell.getStringCellValue();
        int index = value.indexOf(" including ( ");
        if (index == -1) {
            return value;
        }
        return value.substring(0, index);
    }

    private void collectDates(File file, HSSFSheet sheet) {
        int cols = sheet.getRow(1).getLastCellNum();
        for (int col = 1; col < cols; ++col) {
            Date date;
            HSSFCell cell = sheet.getRow(1).getCell(col);
            if (cell.getCellType() == 3 || cell.getCellType() != 0 || !HSSFDateUtil.isCellDateFormatted((Cell)cell) || this.dates.contains(date = cell.getDateCellValue())) continue;
            this.dates.add(date);
            this.datefile.put(date, file);
            this.datecol.put(date, col);
        }
    }

    private void collectSmellNames(HSSFSheet sheet) {
        int rows = sheet.getLastRowNum();
        for (int row = 2; row <= rows; ++row) {
            HSSFCell cell;
            String name;
            HSSFRow actualRow = sheet.getRow(row);
            if (actualRow == null || this.smellrow.containsKey(name = (cell = actualRow.getCell(0)).getStringCellValue()) || name.isEmpty()) continue;
            this.smellrow.put(name, this.smellindex);
            ++this.smellindex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectData() {
        boolean first = true;
        for (File file : this.files) {
            HSSFWorkbook workbook = null;
            try {
                workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
                HSSFSheet sheet = workbook.getSheetAt(0);
                if (first) {
                    this.project = this.getProjectName(sheet);
                    first = false;
                } else if (!this.project.equals(this.getProjectName(sheet))) continue;
                this.collectSmellNames(sheet);
                this.collectDates(file, sheet);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                ErrorReporter.logExceptionStackTrace((String)("Possibly wrong structure of " + file.getName()), (Throwable)e);
                System.out.println("Possibly wrong structure of " + file.getName());
            }
            catch (IOException e) {
                ErrorReporter.logExceptionStackTrace((String)("Error while opening " + file.getName()), (Throwable)e);
                System.out.println("Error opening " + file.getName());
            }
            finally {
                if (workbook == null) continue;
                workbook = null;
            }
        }
    }

    private void writeBasics() {
        HSSFRow row0 = this.summarysheet.createRow(0);
        row0.createCell(0).setCellValue(this.project);
        HSSFRow row1 = this.summarysheet.createRow(1);
        row1.createCell(0).setCellValue("Code smell \\ date");
    }

    private void writeData() throws FileNotFoundException, IOException {
        int col = 1;
        for (Date date : this.dates) {
            if (col > 250) {
                System.out.println("could not process date " + date + "\t column limit exceeded.");
                continue;
            }
            File file = this.datefile.get(date);
            System.out.println("Processing file: " + file.getName() + " | date: " + new SimpleDateFormat("yyyy.MM.dd").format(date));
            HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(0);
            HSSFCellStyle cellStyle = this.outbook.createCellStyle();
            cellStyle.setDataFormat(this.outbook.getCreationHelper().createDataFormat().getFormat("yyyy.mm.dd"));
            HSSFCell cell = this.summarysheet.getRow(1).createCell(col);
            cell.setCellValue(date);
            cell.setCellStyle((CellStyle)cellStyle);
            this.writeSmellData(sheet, date, col);
            ++col;
            workbook = null;
        }
    }

    private void writeSmellData(HSSFSheet sheet, Date date, int col) {
        int rows = sheet.getLastRowNum();
        int colinfile = this.datecol.get(date);
        for (int row = 2; row <= rows; ++row) {
            HSSFRow actualRow = sheet.getRow(row);
            if (actualRow == null) continue;
            HSSFCell cell = actualRow.getCell(0);
            String name = cell.getStringCellValue();
            cell = actualRow.getCell(colinfile);
            if (cell.getCellType() == 3) continue;
            double value = cell.getNumericCellValue();
            HSSFRow r = this.summarysheet.getRow(this.smellrow.get(name).intValue());
            Cell number = r.createCell(col);
            number.setCellValue(value);
        }
    }

    private void writeSmellNames() {
        for (String name : this.smellrow.keySet()) {
            HSSFRow row = this.summarysheet.createRow(this.smellrow.get(name).intValue());
            Cell label = row.createCell(0);
            label.setCellValue(name);
        }
    }

    private void resizeColumns() {
        int numberOfColumns = this.datecol.size() + 1;
        for (int i = 0; i < numberOfColumns; ++i) {
            this.summarysheet.autoSizeColumn(i);
        }
    }

    private void close() throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.outfile);
        this.outbook.write((OutputStream)fileOutputStream);
        IOUtils.closeQuietly((Closeable)fileOutputStream);
    }

    public boolean run() {
        this.outbook = this.createWorkbook();
        if (this.outbook == null) {
            return false;
        }
        this.summarysheet = this.outbook.getSheetAt(0);
        this.collectData();
        try {
            this.writeBasics();
            this.writeSmellNames();
            this.writeData();
            this.resizeColumns();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while writing the merged data", (Throwable)e);
            System.out.println("Error writing output file");
            return false;
        }
        try {
            this.close();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while closing the output file", (Throwable)e);
            System.out.println("Error closing output file");
            return false;
        }
        return true;
    }
}

