/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ShiftLeftExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ShiftRightExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class IncorrectShift {
    private IncorrectShift() {
        throw new AssertionError((Object)"Noninstantiable");
    }

    private static long getFirstShiftOperandLength(CompilationTimeStamp ct, Value value) {
        if (value == null) {
            return 0L;
        }
        IType.Type_type tempType1 = value.getExpressionReturntype(ct, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        IValue refd = value.getValueRefdLast(ct, null);
        long stringSize = 0L;
        switch (tempType1) {
            case TYPE_BITSTRING: {
                if (!IValue.Value_type.BITSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                stringSize = ((Bitstring_Value)refd).getValueLength();
                break;
            }
            case TYPE_HEXSTRING: {
                if (!IValue.Value_type.HEXSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                stringSize = ((Hexstring_Value)refd).getValueLength();
                break;
            }
            case TYPE_OCTETSTRING: {
                if (!IValue.Value_type.OCTETSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                stringSize = ((Octetstring_Value)refd).getValueLength();
                break;
            }
        }
        return stringSize;
    }

    public static class ShiftRight
    extends ShiftChecker {
        public ShiftRight() {
            super(CodeSmellType.INCORRECT_SHIFT_ROTATE_SIZE, "right");
        }

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof ShiftRightExpression)) {
                return;
            }
            ShiftRightExpression s = (ShiftRightExpression)node;
            Value value1 = s.getValue1();
            Value value2 = s.getValue2();
            this.checkShiftOperands(problems, s.getLocation(), value1, value2);
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(ShiftRightExpression.class);
            return ret;
        }
    }

    public static class ShiftLeft
    extends ShiftChecker {
        public ShiftLeft() {
            super(CodeSmellType.INCORRECT_SHIFT_ROTATE_SIZE, "left");
        }

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof ShiftLeftExpression)) {
                return;
            }
            ShiftLeftExpression s = (ShiftLeftExpression)node;
            Value value1 = s.getValue1();
            Value value2 = s.getValue2();
            this.checkShiftOperands(problems, s.getLocation(), value1, value2);
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(ShiftLeftExpression.class);
            return ret;
        }
    }

    private static abstract class ShiftChecker
    extends BaseModuleCodeSmellSpotter {
        private static final String NEGATIVESHIFTPROBLEM = "Shifting to the {1} should be used instead of shifting to the {0} with a negative value";
        private static final String ZEROSHIFTPROBLEM = "Shifting to the {0} with 0 will not change the original value";
        private static final String TOOBIGSHIFTPROBLEM = "Shifting a {1} long string to the {0} with {2} will always result in a string of same size, but filled with '0' -s.";
        private final String actualShift;

        private ShiftChecker(CodeSmellType type, String actualShift) {
            super(type);
            this.actualShift = actualShift;
        }

        protected void checkShiftOperands(BaseCodeSmellSpotter.Problems problems, Location location, Value value1, Value value2) {
            if (value1 == null || value2 == null) {
                return;
            }
            CompilationTimeStamp ct = CompilationTimeStamp.getBaseTimestamp();
            IType.Type_type tempType2 = value2.getExpressionReturntype(ct, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (IType.Type_type.TYPE_INTEGER != tempType2) {
                return;
            }
            IValue tempValue = value2.getValueRefdLast(ct, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype())) {
                return;
            }
            long shiftSize = ((Integer_Value)tempValue).getValue();
            if (!value1.isUnfoldable(ct)) {
                long stringSize = IncorrectShift.getFirstShiftOperandLength(ct, value1);
                if (shiftSize < 0L) {
                    problems.report(location, MessageFormat.format(NEGATIVESHIFTPROBLEM, this.actualShift, "left".equals(this.actualShift) ? "right" : this.actualShift));
                } else if (shiftSize == 0L) {
                    problems.report(location, MessageFormat.format(ZEROSHIFTPROBLEM, this.actualShift));
                } else if (shiftSize > stringSize) {
                    String msg = MessageFormat.format(TOOBIGSHIFTPROBLEM, this.actualShift, stringSize, shiftSize);
                    problems.report(location, msg);
                }
            }
        }
    }
}

