/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class PrivateViaPublic {
    private PrivateViaPublic() {
        throw new AssertionError((Object)"Noninstantiable");
    }

    private static boolean isVisibleInActualModule(Module actualModule, Assignment assignment) {
        Module assignmentModule = assignment.getMyScope().getModuleScope();
        return assignmentModule.equals(actualModule) || assignmentModule.isVisible(CompilationTimeStamp.getBaseTimestamp(), actualModule.getIdentifier(), assignment);
    }

    public static class Value
    extends BaseModuleCodeSmellSpotter {
        private static final String ERROR_MESSAGE = "The parametrization of {0} field is private but it is accessible because of wrapping into public type.";

        public Value() {
            super(CodeSmellType.PRIVATE_VALUE_VIA_PUBLIC);
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Module.class);
            return ret;
        }

        @Override
        protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            Module actualModule = (Module)node;
            ValueCollector valueCollector = new ValueCollector();
            actualModule.accept((ASTVisitor)valueCollector);
            this.check(actualModule, valueCollector, problems);
        }

        public void check(Module actualModule, ValueCollector valueCollector, BaseCodeSmellSpotter.Problems problems) {
            this.checkSequenceOfValues(actualModule, valueCollector, problems);
        }

        private void checkSequenceOfValues(Module actualModule, ValueCollector valueCollector, BaseCodeSmellSpotter.Problems problems) {
            for (SequenceOf_Value actualValue : valueCollector.sequenceOfValues) {
                INamedNode valueReferencedType;
                IType myGovernorType = actualValue.getMyGovernor();
                if (myGovernorType == null) continue;
                String fieldName = "";
                if (myGovernorType instanceof Referenced_Type) {
                    valueReferencedType = myGovernorType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getNameParent();
                    fieldName = ((Referenced_Type)myGovernorType).getReference().getFullName();
                } else {
                    valueReferencedType = myGovernorType.getNameParent();
                    fieldName = "this";
                }
                if (!(valueReferencedType instanceof Def_Type) || PrivateViaPublic.isVisibleInActualModule(actualModule, (Assignment)valueReferencedType)) continue;
                String msg = MessageFormat.format(ERROR_MESSAGE, fieldName);
                problems.report(actualValue.getLocation(), msg);
            }
        }

        private class ValueCollector
        extends ASTVisitor {
            private final List<SequenceOf_Value> sequenceOfValues = new ArrayList<SequenceOf_Value>();

            public int visit(IVisitableNode node) {
                if (node instanceof SequenceOf_Value) {
                    this.sequenceOfValues.add((SequenceOf_Value)node);
                }
                return 3;
            }
        }
    }

    public static class Field
    extends BaseModuleCodeSmellSpotter {
        private static final String ERROR_MESSAGE = "The {0} field is private but it is accessible because of wrapping into public type.";

        public Field() {
            super(CodeSmellType.PRIVATE_FIELD_VIA_PUBLIC);
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(Module.class);
            return ret;
        }

        @Override
        protected void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            Module actualModule = (Module)node;
            FieldCollector fieldCollector = new FieldCollector();
            actualModule.accept((ASTVisitor)fieldCollector);
            this.check(actualModule, fieldCollector, problems);
        }

        protected void check(Module actualModule, FieldCollector fieldCollector, BaseCodeSmellSpotter.Problems problems) {
            this.checkReferences(actualModule, fieldCollector, problems);
            this.checkNamedValues(actualModule, fieldCollector, problems);
        }

        private void checkReferences(Module actualModule, FieldCollector fieldCollector, BaseCodeSmellSpotter.Problems problems) {
            for (Reference actualReference : fieldCollector.references) {
                ArrayList subReferences = new ArrayList(actualReference.getSubreferences());
                if (subReferences.size() > 1) {
                    subReferences.remove(0);
                }
                for (int i = 0; i < subReferences.size(); ++i) {
                    Declaration declaration;
                    ISubReference subReference = (ISubReference)subReferences.get(i);
                    if (subReference.getReferenceType() != ISubReference.Subreference_type.fieldSubReference || (declaration = actualReference.getReferencedDeclaration(subReference)) == null) continue;
                    Assignment assignment = declaration.getAssignment();
                    Identifier identifier = declaration.getIdentifier();
                    if (assignment.getIdentifier().equals((Object)identifier) || !(assignment instanceof Def_Type)) continue;
                    IdentifierToDefType identifierToDefType = new IdentifierToDefType(actualModule, identifier);
                    assignment.accept((ASTVisitor)identifierToDefType);
                    if (!identifierToDefType.getIsPrivate()) continue;
                    String msg = MessageFormat.format(ERROR_MESSAGE, subReference.getId().getDisplayName());
                    problems.report(subReference.getLocation(), msg);
                }
            }
        }

        private void checkNamedValues(Module actualModule, FieldCollector fieldCollector, BaseCodeSmellSpotter.Problems problems) {
            for (NamedValue namedValue : fieldCollector.namedValues) {
                IValue value = namedValue.getValue();
                if (value == null) {
                    return;
                }
                IType namedValueType = value.getMyGovernor();
                if (!(namedValueType instanceof Referenced_Type)) continue;
                Reference namedValueReference = ((Referenced_Type)namedValueType).getReference();
                Assignment namedValueAssignment = null;
                if (namedValueReference.getSubreferences().size() > 1) {
                    INamedNode namedValueTypeRefd = namedValueType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getNameParent();
                    if (namedValueTypeRefd instanceof Def_Type) {
                        namedValueAssignment = (Assignment)namedValueTypeRefd;
                    }
                } else {
                    namedValueAssignment = namedValueReference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true);
                }
                if (!(namedValueAssignment instanceof Def_Type) || PrivateViaPublic.isVisibleInActualModule(actualModule, namedValueAssignment)) continue;
                Identifier namedValueIdentifier = namedValue.getName();
                String msg = MessageFormat.format(ERROR_MESSAGE, namedValueIdentifier.getDisplayName());
                problems.report(namedValueIdentifier.getLocation(), msg);
            }
        }

        private class IdentifierToDefType
        extends ASTVisitor {
            private final Module actualModule;
            private final Identifier identifierToFind;
            private boolean isPrivate;

            private boolean getIsPrivate() {
                return this.isPrivate;
            }

            public IdentifierToDefType(Module actualModule, Identifier identifier) {
                this.actualModule = actualModule;
                this.identifierToFind = identifier;
                this.isPrivate = false;
            }

            public int visit(IVisitableNode node) {
                INamedNode compFieldReferencedType;
                CompField compField;
                Type compFieldType;
                if (node instanceof CompField && (compFieldType = (compField = (CompField)node).getType()) instanceof Referenced_Type && compField.getIdentifier().equals((Object)this.identifierToFind) && (compFieldReferencedType = compFieldType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getNameParent()) instanceof Def_Type && !PrivateViaPublic.isVisibleInActualModule(this.actualModule, (Assignment)compFieldReferencedType)) {
                    this.isPrivate = true;
                    return 2;
                }
                return 3;
            }
        }

        private class FieldCollector
        extends ASTVisitor {
            private final List<Reference> references = new ArrayList<Reference>();
            private final List<NamedValue> namedValues = new ArrayList<NamedValue>();

            public int visit(IVisitableNode node) {
                if (node instanceof Reference) {
                    Reference reference = (Reference)node;
                    if (reference.getSubreferences().size() > 1) {
                        this.references.add(reference);
                    }
                } else if (node instanceof NamedValue) {
                    this.namedValues.add((NamedValue)node);
                }
                return 3;
            }
        }
    }
}

