/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.titanium.metrics.AltstepMetric;
import org.eclipse.titanium.metrics.FunctionMetric;
import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.ModuleMetric;
import org.eclipse.titanium.metrics.ProjectMetric;
import org.eclipse.titanium.metrics.TestcaseMetric;

public enum MetricGroup {
    PROJECT("Project", Arrays.asList(ProjectMetric.values())),
    MODULE("Module", Arrays.asList(ModuleMetric.values())),
    FUNCTION("Function", Arrays.asList(FunctionMetric.values())),
    TESTCASE("Testcase", Arrays.asList(TestcaseMetric.values())),
    ALTSTEP("Altstep", Arrays.asList(AltstepMetric.values()));

    private List<IMetricEnum> metrics = new ArrayList<IMetricEnum>();
    private String groupName;

    private <T extends IMetricEnum> MetricGroup(String groupName, List<T> metrics) {
        this.metrics.addAll(metrics);
        this.groupName = groupName;
    }

    public List<IMetricEnum> getMetrics() {
        return this.metrics;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public static List<IMetricEnum> knownMetrics() {
        ArrayList<IMetricEnum> enums = new ArrayList<IMetricEnum>();
        enums.addAll(MetricGroup.PROJECT.metrics);
        enums.addAll(MetricGroup.MODULE.metrics);
        enums.addAll(MetricGroup.FUNCTION.metrics);
        enums.addAll(MetricGroup.TESTCASE.metrics);
        enums.addAll(MetricGroup.ALTSTEP.metrics);
        return enums;
    }
}

