/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.insertfield;

import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Template;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.insertfield.InsertFieldRefactoring;

class ChangeCreator {
    private final IFile selectedFile;
    private final Definition selection;
    private final InsertFieldRefactoring.Settings settings;
    private Change change;
    private Type type;

    ChangeCreator(IFile selectedFile, Definition selection, InsertFieldRefactoring.Settings settings) {
        this.selectedFile = selectedFile;
        this.selection = selection;
        this.settings = settings;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.selectedFile == null) {
            return;
        }
        this.change = this.createFileChange(this.selectedFile);
    }

    private Change createFileChange(IFile toVisit) {
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        if (this.selection instanceof Def_Type) {
            Def_Type df = (Def_Type)this.selection;
            this.type = df.getType(CompilationTimeStamp.getBaseTimestamp());
        }
        DefinitionVisitor vis = new DefinitionVisitor(this.type);
        module.accept((ASTVisitor)vis);
        NavigableSet nodes = vis.getLocations();
        if (nodes.isEmpty()) {
            return null;
        }
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        try {
            WorkspaceJob job1 = this.calculateEditLocations(nodes, toVisit, rootEdit);
            job1.join();
        }
        catch (InterruptedException ie) {
            ErrorReporter.logExceptionStackTrace((Exception)ie);
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)"InsertFieldRefactoring/CreateChange.createFileChange(): CoreException while calculating edit locations. ");
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (!rootEdit.hasChildren()) {
            return null;
        }
        tfc.setEdit((TextEdit)rootEdit);
        return tfc;
    }

    private WorkspaceJob calculateEditLocations(final NavigableSet<ILocateableNode> nodes, IFile file, final MultiTextEdit rootEdit) throws CoreException {
        WorkspaceJob job = new WorkspaceJob("InsertFieldRefactoring: calculate edit locations"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (ILocateableNode node : nodes) {
                    Location l;
                    Location templateLocation;
                    Location nodeLocation;
                    Location l2;
                    int vmLen = ChangeCreator.this.settings.getType().length() + ChangeCreator.this.settings.getId().getTtcnName().length();
                    if (node instanceof Def_Type) {
                        Def_Type df = (Def_Type)node;
                        Type type = df.getType(CompilationTimeStamp.getBaseTimestamp());
                        if (!(type instanceof TTCN3_Sequence_Type) && !(type instanceof TTCN3_Set_Type)) continue;
                        vmLen = ChangeCreator.this.insertField((TTCN3_Set_Seq_Choice_BaseType)type, node, rootEdit, vmLen);
                        continue;
                    }
                    if (node instanceof Sequence_Value) {
                        Sequence_Value sv = (Sequence_Value)node;
                        vmLen += 6;
                        Location nodeLocation2 = node.getLocation();
                        if (ChangeCreator.this.settings.getPosition() < sv.getNofComponents()) {
                            Location valueLocation = sv.getSeqValueByIndex(ChangeCreator.this.settings.getPosition()).getLocation();
                            Location l3 = new Location(nodeLocation2.getFile(), nodeLocation2.getLine(), valueLocation.getOffset(), valueLocation.getEndOffset() + vmLen);
                            rootEdit.addChild((TextEdit)new InsertEdit(l3.getOffset(), ChangeCreator.this.settings.getId().getTtcnName() + " := " + ChangeCreator.this.settings.getValue() + ", "));
                            continue;
                        }
                        int max = sv.getNofComponents();
                        Location valueLocation = sv.getSeqValueByIndex(max - 1).getLocation();
                        l2 = new Location(nodeLocation2.getFile(), nodeLocation2.getLine(), valueLocation.getEndOffset(), valueLocation.getEndOffset() + vmLen);
                        rootEdit.addChild((TextEdit)new InsertEdit(l2.getOffset(), ", " + ChangeCreator.this.settings.getId().getTtcnName() + " := " + ChangeCreator.this.settings.getValue()));
                        continue;
                    }
                    if (!(node instanceof TTCN3Template)) continue;
                    TTCN3Template template = (TTCN3Template)node;
                    vmLen += 6;
                    if (template instanceof Named_Template_List) {
                        Named_Template_List ntl = (Named_Template_List)template;
                        nodeLocation = node.getLocation();
                        if (ChangeCreator.this.settings.getPosition() < ntl.getNofTemplates()) {
                            Location templateLocation2 = ntl.getTemplateByIndex(ChangeCreator.this.settings.getPosition()).getLocation();
                            l2 = new Location(nodeLocation.getFile(), nodeLocation.getLine(), templateLocation2.getOffset(), templateLocation2.getEndOffset() + vmLen);
                            rootEdit.addChild((TextEdit)new InsertEdit(l2.getOffset(), ChangeCreator.this.settings.getId().getTtcnName() + " := " + ChangeCreator.this.settings.getValue() + ", "));
                            continue;
                        }
                        int max = ntl.getNofTemplates();
                        templateLocation = ntl.getTemplateByIndex(max - 1).getLocation();
                        l = new Location(nodeLocation.getFile(), nodeLocation.getLine(), templateLocation.getEndOffset(), templateLocation.getEndOffset() + vmLen);
                        rootEdit.addChild((TextEdit)new InsertEdit(l.getOffset(), ", " + ChangeCreator.this.settings.getId().getTtcnName() + " := " + ChangeCreator.this.settings.getValue()));
                        continue;
                    }
                    if (!(template instanceof Template_List)) continue;
                    Template_List tl = (Template_List)template;
                    nodeLocation = node.getLocation();
                    if (ChangeCreator.this.settings.getPosition() < tl.getNofTemplates()) {
                        Location templateLocation3 = tl.getTemplateByIndex(ChangeCreator.this.settings.getPosition()).getLocation();
                        l2 = new Location(nodeLocation.getFile(), nodeLocation.getLine(), templateLocation3.getOffset(), templateLocation3.getEndOffset() + vmLen);
                        rootEdit.addChild((TextEdit)new InsertEdit(l2.getOffset(), ChangeCreator.this.settings.getValue() + ","));
                        continue;
                    }
                    int max = tl.getNofTemplates();
                    templateLocation = tl.getTemplateByIndex(max - 1).getLocation();
                    l = new Location(nodeLocation.getFile(), nodeLocation.getLine(), templateLocation.getEndOffset(), templateLocation.getEndOffset() + vmLen);
                    rootEdit.addChild((TextEdit)new InsertEdit(l.getOffset(), "," + ChangeCreator.this.settings.getValue()));
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    public int insertField(TTCN3_Set_Seq_Choice_BaseType ss, ILocateableNode node, MultiTextEdit rootEdit, int vmLen) {
        Location nodeLocation = node.getLocation();
        int noc = ss.getNofComponents();
        if (this.settings.getPosition() < noc) {
            CompField cf = ss.getComponentByIndex(this.settings.getPosition());
            Location l = new Location(nodeLocation.getFile(), nodeLocation.getLine(), cf.getLocation().getOffset(), cf.getLocation().getEndOffset() + (vmLen += 6));
            rootEdit.addChild((TextEdit)new InsertEdit(l.getOffset(), this.settings.getType() + " " + this.settings.getId().getTtcnName() + ", \n  "));
        } else {
            CompField cf = ss.getComponentByIndex(noc - 1);
            Location l = new Location(nodeLocation.getFile(), nodeLocation.getLine(), cf.getLocation().getEndOffset(), cf.getLocation().getEndOffset() + (vmLen += 5));
            rootEdit.addChild((TextEdit)new InsertEdit(l.getOffset() - 1, ",\n  " + this.settings.getType() + " " + this.settings.getId().getTtcnName()));
        }
        return vmLen;
    }

    private static class LocationComparator
    implements Comparator<ILocateableNode> {
        private LocationComparator() {
        }

        @Override
        public int compare(ILocateableNode arg0, ILocateableNode arg1) {
            int o1;
            IResource f1;
            IResource f0 = arg0.getLocation().getFile();
            if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
                return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
            }
            int o0 = arg0.getLocation().getOffset();
            return o0 < (o1 = arg1.getLocation().getOffset()) ? -1 : (o0 == o1 ? 0 : 1);
        }
    }

    private static class DefinitionVisitor
    extends ASTVisitor {
        private final NavigableSet<ILocateableNode> locations = new TreeSet<ILocateableNode>(new LocationComparator());
        private final Type type;

        DefinitionVisitor(Type type) {
            this.type = type;
        }

        private NavigableSet<ILocateableNode> getLocations() {
            return this.locations;
        }

        public int visit(IVisitableNode node) {
            TTCN3Template tt;
            if (node instanceof Def_Type && ((Def_Type)node).getType(CompilationTimeStamp.getBaseTimestamp()).equals(this.type)) {
                Definition d = (Definition)node;
                this.locations.add((ILocateableNode)d);
            } else if (node instanceof Sequence_Value) {
                Sequence_Value sv = (Sequence_Value)node;
                if (sv.getMyGovernor() != null && sv.getMyGovernor().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).equals(this.type)) {
                    this.locations.add((ILocateableNode)sv);
                } else if (sv.getMyGovernor() == null && sv.getDefiningAssignment() instanceof Def_Template) {
                    TITANDebugConsole.println((String[])new String[]{"Governor NULL: " + sv.getFullName() + "   " + sv.getDefiningAssignment() + "   " + sv.toString()});
                }
            } else if (node instanceof TTCN3Template && (tt = (TTCN3Template)node).getMyGovernor() != null && tt.getMyGovernor().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).equals(this.type)) {
                this.locations.add((ILocateableNode)tt);
            }
            return 3;
        }
    }
}

