/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.scope;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Extfunction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Var;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.For_Loop_Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.statements.Definition_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.values.Undefined_LowerIdentifier_Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.Utils;
import org.eclipse.titanium.refactoring.scope.MinimizeScopeRefactoring;
import org.eclipse.titanium.refactoring.scope.nodes.BlockNode;
import org.eclipse.titanium.refactoring.scope.nodes.Edit;
import org.eclipse.titanium.refactoring.scope.nodes.Environment;
import org.eclipse.titanium.refactoring.scope.nodes.MultiDeclaration;
import org.eclipse.titanium.refactoring.scope.nodes.Node;
import org.eclipse.titanium.refactoring.scope.nodes.StatementNode;
import org.eclipse.titanium.refactoring.scope.nodes.Variable;

public class ChangeCreator {
    private final IFile fileSelection;
    private final Definition defSelection;
    private final MinimizeScopeRefactoring.Settings settings;
    private Change change;

    ChangeCreator(IFile file, MinimizeScopeRefactoring.Settings settings) {
        this.fileSelection = file;
        this.defSelection = null;
        this.settings = settings;
    }

    ChangeCreator(IFile file, Definition selectedDef, MinimizeScopeRefactoring.Settings settings) {
        this.fileSelection = file;
        this.defSelection = selectedDef;
        this.settings = settings;
    }

    public Change getChange() {
        return this.change;
    }

    public void perform() {
        if (this.fileSelection == null) {
            return;
        }
        this.change = this.createFileChange(this.fileSelection);
    }

    private Change createFileChange(IFile toVisit) {
        Set<Definition> funcs;
        if (toVisit == null) {
            return null;
        }
        ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)toVisit.getProject());
        Module module = sourceParser.containedModule(toVisit);
        if (module == null) {
            return null;
        }
        FunctionCollector vis = new FunctionCollector();
        if (this.defSelection == null) {
            module.accept((ASTVisitor)vis);
            funcs = vis.getResult();
        } else if (this.defSelection instanceof Def_Function || this.defSelection instanceof Def_Testcase) {
            funcs = new HashSet<Definition>();
            funcs.add(this.defSelection);
        } else {
            ErrorReporter.logError((String)("Variable scope reduction called for " + this.defSelection.getIdentifier().getDisplayName() + ", but it is only supported for functions and testcases. "));
            return null;
        }
        ArrayList<Edit> allEdits = new ArrayList<Edit>();
        for (Definition def : funcs) {
            List<Edit> edits = this.analyzeFunction(def);
            if (edits == null) continue;
            allEdits.addAll(edits);
        }
        if (allEdits.isEmpty()) {
            return null;
        }
        String fileContents = ChangeCreator.loadFileContent(toVisit);
        TextFileChange tfc = new TextFileChange(toVisit.getName(), toVisit);
        MultiTextEdit rootEdit = new MultiTextEdit();
        tfc.setEdit((TextEdit)rootEdit);
        LinkedList<Object> allTes = new LinkedList<Object>();
        HashMap<Edit, InsertEdit> editsDone = new HashMap<Edit, InsertEdit>();
        for (Edit edit : allEdits) {
            TextEdit[] tes;
            for (TextEdit te : tes = this.createTextEdit(toVisit, fileContents, edit, editsDone)) {
                if (!(te instanceof DeleteEdit)) {
                    allTes.add(te);
                    continue;
                }
                DeleteEdit dte = (DeleteEdit)te;
                ListIterator it = allTes.listIterator();
                while (it.hasNext()) {
                    DeleteEdit currDte;
                    TextEdit currTe = (TextEdit)it.next();
                    if (!(currTe instanceof DeleteEdit) || !this.doesDeleteEditsOverlap(dte, currDte = (DeleteEdit)currTe)) continue;
                    it.remove();
                    dte = this.mergeDeleteEdits(dte, currDte);
                }
                allTes.add(dte);
            }
        }
        Collections.reverse(allTes);
        for (TextEdit textEdit : allTes) {
            rootEdit.addChild(textEdit);
        }
        return tfc;
    }

    private TextEdit[] createTextEdit(IFile toVisit, String fileContent, Edit e, Map<Edit, InsertEdit> editsDone) {
        if (e.declSt.isMultiDeclaration()) {
            Location cutLoc = this.calculateMultiDeclarationCutLoc(fileContent, e.declSt);
            String moveContent = this.calculateMultiDeclarationMoveContent(fileContent, e.declSt);
            e.declSt.removeFromMultiDeclaration();
            int cutLen = cutLoc.getEndOffset() - cutLoc.getOffset();
            DeleteEdit cut = new DeleteEdit(cutLoc.getOffset(), cutLen);
            InsertEdit insert = null;
            if (!e.isRemoveEdit()) {
                int insertOffset = ((ILocateableNode)e.insertionPoint.getAstNode()).getLocation().getOffset();
                for (Map.Entry<Edit, InsertEdit> ed : editsDone.entrySet()) {
                    if (!ed.getKey().declSt.equals(e.insertionPoint)) continue;
                    insertOffset = ed.getValue().getOffset();
                    break;
                }
                insertOffset = this.findLineBeginningOffset(fileContent, insertOffset);
                insert = new InsertEdit(insertOffset, moveContent);
                editsDone.put(e, insert);
            }
            if (insert != null) {
                return new TextEdit[]{insert, cut};
            }
            return new TextEdit[]{cut};
        }
        Location cutLoc = this.findStatementLocation(fileContent, ((ILocateableNode)e.declSt.getAstNode()).getLocation(), true);
        InsertEdit insert = null;
        if (!e.isRemoveEdit()) {
            Location copyLoc = this.findStatementLocation(fileContent, ((ILocateableNode)e.declSt.getAstNode()).getLocation(), false);
            Location insPLoc = ((ILocateableNode)e.insertionPoint.getAstNode()).getLocation();
            int insertOffset = insPLoc.getOffset();
            for (Map.Entry<Edit, InsertEdit> ed : editsDone.entrySet()) {
                if (!ed.getKey().declSt.equals(e.insertionPoint)) continue;
                insertOffset = ed.getValue().getOffset();
                break;
            }
            int prefixStartOffset = this.findLineBeginningOffset(fileContent, insertOffset);
            String insertText = fileContent.substring(copyLoc.getOffset(), copyLoc.getEndOffset()) + "\n";
            String insertPrefix = fileContent.substring(prefixStartOffset, insertOffset);
            if (!insertPrefix.trim().equals("")) {
                insertPrefix = "";
            }
            insert = new InsertEdit(prefixStartOffset, insertPrefix + insertText);
            editsDone.put(e, insert);
        }
        int cutLen = cutLoc.getEndOffset() - cutLoc.getOffset();
        DeleteEdit cut = new DeleteEdit(cutLoc.getOffset(), cutLen);
        if (insert != null) {
            return new TextEdit[]{insert, cut};
        }
        return new TextEdit[]{cut};
    }

    private DeleteEdit mergeDeleteEdits(DeleteEdit de0, DeleteEdit de1) {
        if (!this.doesDeleteEditsOverlap(de0, de1)) {
            ErrorReporter.logError((String)"ChangeCreator.mergeDeleteEdits(): DeleteEdits are not overlapping! ");
            return null;
        }
        int offset = Math.min(de0.getOffset(), de1.getOffset());
        int endOffset = Math.max(de0.getExclusiveEnd(), de1.getExclusiveEnd());
        return new DeleteEdit(offset, endOffset - offset);
    }

    private boolean doesDeleteEditsOverlap(DeleteEdit de0, DeleteEdit de1) {
        return de0.getOffset() < de1.getExclusiveEnd() && de0.getExclusiveEnd() > de1.getOffset();
    }

    private Location findStatementLocation(String fileContent, Location loc, boolean includePrefix) {
        int endOffset;
        int offset;
        block13: {
            block12: {
                offset = loc.getOffset();
                endOffset = loc.getEndOffset();
                if (includePrefix) {
                    block8: for (int i = offset - 1; i >= 0; --i) {
                        switch (fileContent.charAt(i)) {
                            case '\t': 
                            case ' ': {
                                continue block8;
                            }
                            default: {
                                offset = i + 1;
                                break block12;
                            }
                        }
                    }
                    offset = 0;
                }
            }
            boolean comment = false;
            block9: for (int i = endOffset; i < fileContent.length(); ++i) {
                switch (fileContent.charAt(i)) {
                    case '\n': 
                    case '\r': {
                        endOffset = i;
                        break block13;
                    }
                    case '/': {
                        if (fileContent.length() > i + 1 && fileContent.charAt(i + 1) == '/') {
                            comment = true;
                            ++i;
                            continue block9;
                        }
                        if (comment) continue block9;
                        endOffset = i;
                        break block13;
                    }
                    case '\t': 
                    case ' ': 
                    case ';': {
                        continue block9;
                    }
                    default: {
                        if (comment) continue block9;
                        endOffset = i;
                        break block13;
                    }
                }
            }
            endOffset = fileContent.length();
        }
        return new Location(loc.getFile(), loc.getLine(), offset, endOffset);
    }

    private int findLineBeginningOffset(String fileContent, int fromOffset) {
        block3: for (int i = fromOffset - 1; i >= 0; --i) {
            switch (fileContent.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i + 1;
                }
            }
        }
        return 0;
    }

    private Location calculateMultiDeclarationCutLoc(String fileContent, StatementNode declStNode) {
        Definition_Statement declStmt = (Definition_Statement)declStNode.getAstNode();
        Location declStmtLoc = declStmt.getLocation();
        String stmtContent = fileContent.substring(declStmtLoc.getOffset(), declStmtLoc.getEndOffset());
        if (!stmtContent.contains(",")) {
            ErrorReporter.logError((String)("ChangeCreator.calculateMultiDeclarationCutLoc(): Given statement is not a multi-declaration statement; loc: " + declStmtLoc.getOffset() + "-" + declStmtLoc.getEndOffset() + " in file " + declStmtLoc.getFile()));
            return null;
        }
        MultiDeclaration md = declStNode.getMultiDeclaration();
        StatementNode firstDeclPart = md.getFirstStatement();
        Definition defVarToMove = declStNode.getDeclaredVar().getDefinition();
        boolean firstDefInMdMoved = firstDeclPart.isMoved();
        if (md.getSize() <= 1) {
            Location cutLoc = this.findStatementLocation(fileContent, declStmt.getLocation(), true);
            return cutLoc;
        }
        int cutOffset = defVarToMove.getLocation().getOffset();
        int cutEndOffset = defVarToMove.getLocation().getEndOffset();
        if (md.isFirstStatement(declStNode)) {
            if (!md.isAllStatementsMoved()) {
                cutOffset = defVarToMove.getIdentifier().getLocation().getOffset();
            }
            cutEndOffset = this.calculateEndOffsetIncludingTrailingComma(fileContent, cutEndOffset, declStmtLoc.getEndOffset());
        } else if (md.isLastStatement(declStNode)) {
            cutOffset = this.calculateOffsetIncludingLeadingComma(fileContent, cutOffset, declStmtLoc.getOffset());
        } else {
            cutEndOffset = this.calculateEndOffsetIncludingTrailingComma(fileContent, cutEndOffset, declStmtLoc.getEndOffset());
        }
        return new Location(declStmtLoc.getFile(), declStmtLoc.getLine(), cutOffset, cutEndOffset);
    }

    private int calculateOffsetIncludingLeadingComma(String fileContent, int offset, int stopAtOffset) {
        boolean insideBlockComment = false;
        block5: while (offset > stopAtOffset) {
            switch (fileContent.charAt(offset - 1)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    --offset;
                    continue block5;
                }
                case '/': {
                    if (offset > 1 && fileContent.charAt(offset - 2) == '*') {
                        insideBlockComment = true;
                        offset -= 2;
                        continue block5;
                    }
                    if (!insideBlockComment) break block5;
                    --offset;
                    continue block5;
                }
                case '*': {
                    if (insideBlockComment && offset > 1 && fileContent.charAt(offset - 2) == '/') {
                        insideBlockComment = false;
                        offset -= 2;
                        continue block5;
                    }
                    if (!insideBlockComment) break block5;
                    --offset;
                    continue block5;
                }
                default: {
                    if (!insideBlockComment) break block5;
                    --offset;
                    continue block5;
                }
            }
        }
        return offset;
    }

    private int calculateEndOffsetIncludingTrailingComma(String fileContent, int endOffset, int stopAtEndOffset) {
        boolean insideBlockComment = false;
        block5: while (endOffset < stopAtEndOffset) {
            switch (fileContent.charAt(endOffset)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    ++endOffset;
                    continue block5;
                }
                case '/': {
                    if (endOffset < fileContent.length() - 2 && fileContent.charAt(endOffset + 1) == '*') {
                        insideBlockComment = true;
                        endOffset += 2;
                        continue block5;
                    }
                    if (!insideBlockComment) break block5;
                    ++endOffset;
                    continue block5;
                }
                case '*': {
                    if (insideBlockComment && endOffset < fileContent.length() - 2 && fileContent.charAt(endOffset + 1) == '/') {
                        insideBlockComment = false;
                        endOffset += 2;
                        continue block5;
                    }
                    if (!insideBlockComment) break block5;
                    ++endOffset;
                    continue block5;
                }
                default: {
                    if (!insideBlockComment) break block5;
                    ++endOffset;
                    continue block5;
                }
            }
        }
        return endOffset;
    }

    private String calculateMultiDeclarationMoveContent(String fileContent, StatementNode declStNode) {
        int prefixEndOffset;
        int prefixOffset;
        Definition defVarToMove;
        Definition_Statement declStmt = (Definition_Statement)declStNode.getAstNode();
        Location declStmtLoc = declStmt.getLocation();
        String stmtContent = fileContent.substring(declStmtLoc.getOffset(), declStmtLoc.getEndOffset());
        if (!stmtContent.contains(",")) {
            ErrorReporter.logError((String)("ChangeCreator.calculateMultiDeclarationMoveContent(): Given statement is not a multi-declaration statement; loc: " + declStmtLoc.getOffset() + "-" + declStmtLoc.getEndOffset() + " in file " + declStmtLoc.getFile()));
            return null;
        }
        MultiDeclaration md = declStNode.getMultiDeclaration();
        StatementNode firstDeclPart = md.getFirstStatement();
        Definition firstDefInStmt = firstDeclPart.getDeclaredVar().getDefinition();
        if (firstDefInStmt.equals(defVarToMove = declStNode.getDeclaredVar().getDefinition())) {
            prefixOffset = this.findLineBeginningOffset(fileContent, declStmtLoc.getOffset());
            prefixEndOffset = declStmtLoc.getOffset();
        } else {
            prefixOffset = this.findLineBeginningOffset(fileContent, declStmtLoc.getOffset());
            prefixEndOffset = firstDefInStmt.getIdentifier().getLocation().getOffset();
        }
        String prefixContent = fileContent.substring(prefixOffset, prefixEndOffset);
        int varOffset = defVarToMove.getLocation().getOffset();
        int varEndOffset = defVarToMove.getLocation().getEndOffset();
        String varContent = fileContent.substring(varOffset, varEndOffset);
        String suffixContent = "\n";
        if (varContent.charAt(varContent.length() - 1) != ';') {
            suffixContent = ";" + suffixContent;
        }
        prefixContent = prefixContent.replaceAll("[\n\r]", " ");
        varContent = varContent.replaceAll("[\n\r]", " ");
        return prefixContent + varContent + suffixContent;
    }

    private List<Edit> analyzeFunction(Definition def) {
        if (!(def instanceof Def_Function) && !(def instanceof Def_Testcase)) {
            ErrorReporter.logError((String)("ChangeCreator.analyzeFunction(): def must be a Def_Function or a Def_Testcase! def type: " + def.getClass()));
            return null;
        }
        FunctionAnalyzer vis = new FunctionAnalyzer();
        def.accept((ASTVisitor)vis);
        Environment env = vis.getResult();
        List<Edit> eds = env.refactor();
        return eds;
    }

    private static String loadFileContent(IFile toLoad) {
        StringBuilder fileContents;
        try {
            InputStream is = toLoad.getContents();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, toLoad.getCharset()));
            fileContents = new StringBuilder();
            char[] buff = new char[1024];
            while (br.ready()) {
                int len = br.read(buff);
                fileContents.append(buff, 0, len);
            }
            br.close();
        }
        catch (IOException e) {
            ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (IOException) for file: " + toLoad.getName()));
            return null;
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)("ChangeCreator.loadFileContent(): Unable to get file contents (CoreException) for file: " + toLoad.getName()));
            return null;
        }
        return fileContents.toString();
    }

    private static class FunctionCollector
    extends ASTVisitor {
        private final Set<Definition> result = new HashSet<Definition>();

        private FunctionCollector() {
        }

        public Set<Definition> getResult() {
            return this.result;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Def_Function || node instanceof Def_Testcase) {
                this.result.add((Definition)node);
                return 1;
            }
            return 3;
        }
    }

    private class FunctionAnalyzer
    extends ASTVisitor {
        private final Environment env;
        private final LinkedList<Node> currStack;
        private IVisitableNode suspendStackBuildingForNode;
        private IVisitableNode suspendDeclarationsForNode;
        private IVisitableNode suspendReferencesForNode;

        private FunctionAnalyzer() {
            this.env = new Environment(ChangeCreator.this.settings);
            this.currStack = new LinkedList();
        }

        public Environment getResult() {
            return this.env;
        }

        private void setSuspendStackBuildingForNode(IVisitableNode node) {
            if (this.suspendStackBuildingForNode == null) {
                this.suspendStackBuildingForNode = node;
            }
        }

        private void setSuspendDeclarationsForNode(IVisitableNode node) {
            if (this.suspendDeclarationsForNode == null) {
                this.suspendDeclarationsForNode = node;
            }
        }

        private void setSuspendReferencesForNode(IVisitableNode node) {
            if (this.suspendReferencesForNode == null) {
                this.suspendReferencesForNode = node;
            }
        }

        private void checkForUnsuspend(IVisitableNode node) {
            if (node == this.suspendStackBuildingForNode) {
                this.suspendStackBuildingForNode = null;
            }
            if (node == this.suspendDeclarationsForNode) {
                this.suspendDeclarationsForNode = null;
            }
            if (node == this.suspendReferencesForNode) {
                this.suspendReferencesForNode = null;
            }
        }

        public int visit(IVisitableNode node) {
            Node parent;
            if (node instanceof For_Loop_Definitions && this.suspendDeclarationsForNode == null) {
                this.setSuspendDeclarationsForNode(node);
                return 3;
            }
            if (node instanceof Statement && this.suspendStackBuildingForNode == null) {
                StatementNode sn = new StatementNode(node);
                if (this.currStack.peek() instanceof BlockNode) {
                    parent = (BlockNode)this.currStack.peek();
                    sn.setParent((BlockNode)parent);
                    ((BlockNode)parent).addStatement(sn);
                    this.currStack.push(sn);
                } else {
                    this.setSuspendStackBuildingForNode(node);
                    this.setSuspendDeclarationsForNode(node);
                }
            }
            if (node instanceof StatementBlock && this.suspendStackBuildingForNode == null) {
                BlockNode bn = new BlockNode(node);
                if (this.currStack.isEmpty()) {
                    this.env.setRootNode(bn);
                    this.currStack.push(bn);
                } else if (this.currStack.peek() instanceof StatementNode) {
                    parent = (StatementNode)this.currStack.peek();
                    bn.setParent((StatementNode)parent);
                    ((StatementNode)parent).addBlock(bn);
                    this.currStack.push(bn);
                } else {
                    this.setSuspendStackBuildingForNode(node);
                    this.setSuspendDeclarationsForNode(node);
                }
            }
            if (node instanceof FormalParameter && this.suspendDeclarationsForNode == null) {
                Variable var = new Variable((Definition)((FormalParameter)node), null, true);
                this.env.addVariable(var);
                return 1;
            }
            if (node instanceof Def_Var && this.suspendDeclarationsForNode == null) {
                StatementNode declSt = (StatementNode)this.currStack.peek();
                Variable var = new Variable((Definition)((Def_Var)node), declSt, false);
                if (declSt == null) {
                    ErrorReporter.logError((String)("ChangeCreator.FunctionAnalyzer: declSt is null; var: " + var + "; loc: " + Utils.createLocationString(node)));
                }
                declSt.setDeclaredVar(var);
                this.env.addVariable(var);
                StatementNode prevSt = declSt.getParent().getPreviousStatement(declSt);
                if (prevSt != null && prevSt.isDeclaration() && prevSt.isLocationEqualTo(declSt)) {
                    prevSt.linkWithOtherAsMultiDeclaration(declSt);
                }
                return 3;
            }
            if (node instanceof Undefined_LowerIdentifier_Value) {
                ((Undefined_LowerIdentifier_Value)node).getAsReference();
                return 3;
            }
            if (node instanceof Reference && this.suspendReferencesForNode == null) {
                StatementNode refSt = (StatementNode)this.currStack.peek();
                if (refSt == null) {
                    return 1;
                }
                Reference ref = (Reference)node;
                Assignment as = ref.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false);
                if (as instanceof Def_Function || as instanceof Def_Extfunction) {
                    refSt.setHasFunctionCall();
                    return 3;
                }
                Variable var = this.env.getVariable(as);
                if (var == null) {
                    if (as instanceof Def_Var) {
                        refSt.setHasUncheckedRef();
                    }
                    return 3;
                }
                var.addReference(refSt, ref.getUsedOnLeftHandSide());
                refSt.addReferedVars(var);
                return 3;
            }
            return 3;
        }

        public int leave(IVisitableNode node) {
            if (node instanceof For_Loop_Definitions) {
                this.checkForUnsuspend(node);
                return 3;
            }
            if (node instanceof Statement) {
                this.checkForUnsuspend(node);
            }
            if (node instanceof StatementBlock) {
                this.checkForUnsuspend(node);
            }
            return 3;
        }
    }
}

