/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.ungroup;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.titanium.refactoring.ungroup.ChangeCreator;

public class UngroupModuleparRefactoring
extends Refactoring {
    private final IStructuredSelection selection;
    private final Set<IProject> projects = new HashSet<IProject>();
    private Object[] affectedObjects;

    public UngroupModuleparRefactoring(IStructuredSelection selection) {
        this.selection = selection;
        for (Object o : selection) {
            if (!(o instanceof IResource)) continue;
            IProject temp = ((IResource)o).getProject();
            this.projects.add(temp);
        }
    }

    public Object[] getAffectedObjects() {
        return this.affectedObjects;
    }

    public String getName() {
        return "Ungroup module parameters";
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.selection == null) {
            return null;
        }
        CompositeChange cchange = new CompositeChange("UngroupModuleparRefactoring");
        for (Object o : this.selection) {
            if (!(o instanceof IResource)) continue;
            IResource res = (IResource)o;
            ResourceVisitor vis = new ResourceVisitor();
            res.accept((IResourceVisitor)vis);
            cchange.add((Change)vis.getChange());
        }
        this.affectedObjects = cchange.getAffectedObjects();
        return cchange;
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        private final CompositeChange change = new CompositeChange("UngroupModuleparRefactoring");

        private CompositeChange getChange() {
            return this.change;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                ChangeCreator chCreator = new ChangeCreator((IFile)resource);
                chCreator.perform();
                Change ch = chCreator.getChange();
                if (ch != null) {
                    this.change.add(ch);
                }
                return false;
            }
            return true;
        }
    }
}

