/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.utils;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;

public class CodeTemplateContextTypeUtils {
    private static final String CONTEXT_TYPE_ID_PREFIX = "org.eclipse.tm4e.ui.templates.context.";

    private CodeTemplateContextTypeUtils() {
    }

    public static String toContextTypeId(ITMScope languageScope) {
        return CONTEXT_TYPE_ID_PREFIX + languageScope.getQualifiedName();
    }

    public static String toContextTypeId(TMToken textMateToken) {
        return CONTEXT_TYPE_ID_PREFIX + textMateToken.grammarScope;
    }

    public static @Nullable ITMScope findScopeFor(String contextTypeId) {
        IGrammarDefinition[] grammarDefinitions = TMEclipseRegistryPlugin.getGrammarRegistryManager().getDefinitions();
        return Arrays.stream(grammarDefinitions).map(IGrammarDefinition::getScope).filter(scope -> contextTypeId.equals(CodeTemplateContextTypeUtils.toContextTypeId(scope))).findFirst().orElse(null);
    }

    public static @Nullable String getContentTypeName(ITMScope languageScope) {
        @Nullable Collection contentTypes = TMEclipseRegistryPlugin.getGrammarRegistryManager().getContentTypesForScope(languageScope);
        if (contentTypes != null && contentTypes.size() > 0) {
            return ((IContentType)contentTypes.iterator().next()).getName();
        }
        return null;
    }

    public static String toContextTypeName(ITMScope languageScope) {
        String contentTypeName = CodeTemplateContextTypeUtils.getContentTypeName(languageScope);
        Object name = "";
        if (contentTypeName != null) {
            name = contentTypeName;
        }
        name = (String)name + " (" + languageScope.getQualifiedName() + ")";
        return name;
    }

    public static @Nullable IGrammar toGrammar(String contextTypeName) {
        IGrammarDefinition[] grammarDefinitions = TMEclipseRegistryPlugin.getGrammarRegistryManager().getDefinitions();
        return Arrays.stream(grammarDefinitions).map(IGrammarDefinition::getScope).filter(scope -> contextTypeName.equals(CodeTemplateContextTypeUtils.toContextTypeName(scope))).map(scope -> TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarForScope(scope)).findFirst().orElse(null);
    }
}

