/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.trace4cps.analysis.signal.SignalModifier;
import org.eclipse.trace4cps.analysis.signal.SignalUtil;
import org.eclipse.trace4cps.analysis.signal.impl.PsopHelper;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITrace;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.tl.FormulaBuilder;
import org.eclipse.trace4cps.tl.FormulaBuilderException;
import org.eclipse.trace4cps.tl.etl.AndOrFormula;
import org.eclipse.trace4cps.tl.etl.ApFormula;
import org.eclipse.trace4cps.tl.etl.AttributeFilter;
import org.eclipse.trace4cps.tl.etl.Check;
import org.eclipse.trace4cps.tl.etl.ConvSpec;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.etl.FinallyFormula;
import org.eclipse.trace4cps.tl.etl.FinallyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.Formula;
import org.eclipse.trace4cps.tl.etl.GloballyFormula;
import org.eclipse.trace4cps.tl.etl.GloballyUntimedFormula;
import org.eclipse.trace4cps.tl.etl.IdString;
import org.eclipse.trace4cps.tl.etl.IfThenFormula;
import org.eclipse.trace4cps.tl.etl.Interval;
import org.eclipse.trace4cps.tl.etl.KeyVal;
import org.eclipse.trace4cps.tl.etl.LatencySignal;
import org.eclipse.trace4cps.tl.etl.MtlAp;
import org.eclipse.trace4cps.tl.etl.MtlApEnd;
import org.eclipse.trace4cps.tl.etl.MtlApStart;
import org.eclipse.trace4cps.tl.etl.NotFormula;
import org.eclipse.trace4cps.tl.etl.ReferenceFormula;
import org.eclipse.trace4cps.tl.etl.ResourceAmountSignal;
import org.eclipse.trace4cps.tl.etl.ResourceClientSignal;
import org.eclipse.trace4cps.tl.etl.Signal;
import org.eclipse.trace4cps.tl.etl.SignalDef;
import org.eclipse.trace4cps.tl.etl.ThroughputSignal;
import org.eclipse.trace4cps.tl.etl.TimeUnitEnum;
import org.eclipse.trace4cps.tl.etl.TopLevelModelElement;
import org.eclipse.trace4cps.tl.etl.TraceSignal;
import org.eclipse.trace4cps.tl.etl.UntilFormula;
import org.eclipse.trace4cps.tl.etl.UntilUntimedFormula;
import org.eclipse.trace4cps.tl.etl.WipSignal;

public class FormulaHelper {
    private FormulaHelper() {
    }

    public static <T> T findContainer(EObject o, Class<T> clazz) {
        EObject c = o.eContainer();
        while (c != null) {
            if (clazz.isInstance(c)) {
                return clazz.cast(c);
            }
            c = c.eContainer();
        }
        return null;
    }

    public static TimeUnit valueOf(TimeUnitEnum tu) {
        switch (tu) {
            case NS: {
                return TimeUnit.NANOSECONDS;
            }
            case US: {
                return TimeUnit.MICROSECONDS;
            }
            case MS: {
                return TimeUnit.MILLISECONDS;
            }
            case S: {
                return TimeUnit.SECONDS;
            }
            case MIN: {
                return TimeUnit.MINUTES;
            }
            case HR: {
                return TimeUnit.HOURS;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String toString(Interval i) {
        if (i.getInn() != null) {
            return "[" + i.getInn().getLb() + "," + i.getInn().getUb() + "] " + String.valueOf((Object)i.getTimeUnit());
        }
        if (i.getIns() != null) {
            return "[" + i.getIns().getLb() + "," + String.valueOf(i.getIns().getInfty() != null ? "Infty" : Double.valueOf(i.getIns().getUb())) + ") " + String.valueOf((Object)i.getTimeUnit());
        }
        if (i.getIsn() != null) {
            return "(" + i.getIsn().getLb() + "," + i.getIsn().getUb() + "] " + String.valueOf((Object)i.getTimeUnit());
        }
        if (i.getIss() != null) {
            return "(" + i.getIss().getLb() + "," + String.valueOf(i.getIss().getInfty() != null ? "Infty" : Double.valueOf(i.getIss().getUb())) + ") " + String.valueOf((Object)i.getTimeUnit());
        }
        throw new IllegalStateException("Unexpected structure in model");
    }

    public static String toString(IdString s) {
        StringBuilder b = new StringBuilder();
        if (s.getLeft() != null) {
            b.append(s.getLeft());
        }
        if (s.getId() != null) {
            b.append(s.getId());
        }
        if (s.getRight() != null) {
            b.append(s.getRight());
        }
        return b.toString();
    }

    public static boolean hasMixedCheck(EtlModel m) {
        for (TopLevelModelElement e : m.getElements()) {
            if (!(e instanceof Check) || FormulaHelper.getFormulaType(((Check)e).getFormula()) != FormulaType.MIXED) continue;
            return true;
        }
        return false;
    }

    public static FormulaType getFormulaType(Formula phi) {
        ArrayList<ApFormula> aps = new ArrayList<ApFormula>();
        FormulaHelper.visit(phi, aps);
        boolean hasMTL = false;
        boolean hasSTL = false;
        for (ApFormula f : aps) {
            if (f.getMtlAP() != null) {
                hasMTL = true;
                continue;
            }
            hasSTL = true;
        }
        if (hasMTL && !hasSTL) {
            return FormulaType.MTL;
        }
        if (!hasMTL && hasSTL) {
            return FormulaType.STL;
        }
        if (hasMTL && hasSTL) {
            return FormulaType.MIXED;
        }
        return null;
    }

    private static void visit(Formula f, List<ApFormula> aps) {
        if (f instanceof ApFormula) {
            aps.add((ApFormula)f);
        } else if (f instanceof ReferenceFormula) {
            FormulaHelper.visit(((ReferenceFormula)f).getDef().getFormula(), aps);
        } else if (f instanceof AndOrFormula) {
            FormulaHelper.visit(((AndOrFormula)f).getLeft(), aps);
            FormulaHelper.visit(((AndOrFormula)f).getRight(), aps);
        } else if (f instanceof IfThenFormula) {
            FormulaHelper.visit(((IfThenFormula)f).getLeft(), aps);
            FormulaHelper.visit(((IfThenFormula)f).getRight(), aps);
        } else if (f instanceof NotFormula) {
            FormulaHelper.visit(((NotFormula)f).getFormula(), aps);
        } else if (f instanceof FinallyFormula) {
            FormulaHelper.visit(((FinallyFormula)f).getFormula(), aps);
        } else if (f instanceof FinallyUntimedFormula) {
            FormulaHelper.visit(((FinallyUntimedFormula)f).getFormula(), aps);
        } else if (f instanceof GloballyFormula) {
            FormulaHelper.visit(((GloballyFormula)f).getFormula(), aps);
        } else if (f instanceof GloballyUntimedFormula) {
            FormulaHelper.visit(((GloballyUntimedFormula)f).getFormula(), aps);
        } else if (f instanceof UntilFormula) {
            FormulaHelper.visit(((UntilFormula)f).getLeft(), aps);
            FormulaHelper.visit(((UntilFormula)f).getRight(), aps);
        } else if (f instanceof UntilUntimedFormula) {
            FormulaHelper.visit(((UntilUntimedFormula)f).getLeft(), aps);
            FormulaHelper.visit(((UntilUntimedFormula)f).getRight(), aps);
        }
    }

    public static Map<String, IPsop> createSignalMap(ITrace trace, List<SignalDef> signalDefs, boolean includeDerived) throws FormulaBuilderException {
        HashMap<String, IPsop> signalMap = new HashMap<String, IPsop>();
        if (signalDefs.isEmpty()) {
            return signalMap;
        }
        for (SignalDef signalDef : signalDefs) {
            IPsop psop;
            Signal s = signalDef.getSignal();
            if (s instanceof TraceSignal) {
                Map<String, String> filter = FormulaBuilder.toMap(((TraceSignal)s).getFilter(), null);
                boolean found = false;
                for (IPsop psop2 : trace.getSignals()) {
                    if (!TraceHelper.matches(filter, (Map)psop2.getAttributes())) continue;
                    if (!found) {
                        signalMap.put(signalDef.getName(), (IPsop)PsopHelper.copy((IPsop)psop2));
                        found = true;
                        continue;
                    }
                    throw new FormulaBuilderException("Filter for " + signalDef.getName() + " matches multiple signals");
                }
                if (found) continue;
                throw new FormulaBuilderException("Filter for " + signalDef.getName() + " does not match any signal");
            }
            if (!includeDerived || (psop = FormulaHelper.getDerivedSignal(trace, s)) == null || psop.getFragments().isEmpty()) continue;
            signalMap.put(signalDef.getName(), psop);
        }
        return signalMap;
    }

    public static IPsop getDerivedSignal(ITrace trace, Signal signal) throws FormulaBuilderException {
        if (signal instanceof ThroughputSignal) {
            return FormulaHelper.getDerivedTPsignal(trace, (ThroughputSignal)signal);
        }
        if (signal instanceof LatencySignal) {
            return FormulaHelper.getDerivedLatSignal(trace, (LatencySignal)signal);
        }
        if (signal instanceof WipSignal) {
            return FormulaHelper.getDerivedWipSignal(trace, (WipSignal)signal);
        }
        if (signal instanceof ResourceAmountSignal) {
            return FormulaHelper.getDerivedResourceAmountSignal(trace, (ResourceAmountSignal)signal);
        }
        if (signal instanceof ResourceClientSignal) {
            return FormulaHelper.getDerivedResourceClientSignal(trace, (ResourceClientSignal)signal);
        }
        return null;
    }

    private static IPsop getDerivedResourceClientSignal(ITrace trace, ResourceClientSignal signal) throws FormulaBuilderException {
        SignalModifier mod = FormulaHelper.getModifier(signal.getConvSpec());
        IResource resource = FormulaHelper.findResource(trace, signal.getFilter());
        return SignalUtil.getResourceClients((ITrace)trace, (IResource)resource, (SignalModifier)mod);
    }

    private static IPsop getDerivedResourceAmountSignal(ITrace trace, ResourceAmountSignal signal) throws FormulaBuilderException {
        SignalModifier mod = FormulaHelper.getModifier(signal.getConvSpec());
        IResource resource = FormulaHelper.findResource(trace, signal.getFilter());
        return SignalUtil.getResourceAmount((ITrace)trace, (IResource)resource, (SignalModifier)mod);
    }

    private static IPsop getDerivedWipSignal(ITrace trace, WipSignal signal) {
        SignalModifier mod = FormulaHelper.getModifier(signal.getConvSpec());
        return SignalUtil.getWip((ITrace)trace, (String)signal.getIdAtt(), (SignalModifier)mod);
    }

    private static IPsop getDerivedLatSignal(ITrace trace, LatencySignal signal) {
        TimeUnit scaleUnit = signal.getScale() == null ? trace.getTimeUnit() : FormulaHelper.valueOf(signal.getScale());
        double windowWidth = signal.getConvSpec() == null ? 0.0 : signal.getConvSpec().getWindowWidth();
        TimeUnit windowTimeUnit = signal.getConvSpec() == null ? trace.getTimeUnit() : FormulaHelper.valueOf(signal.getConvSpec().getWindowUnit());
        return SignalUtil.getLatency((ITrace)trace, (String)signal.getIdAtt(), (TimeUnit)scaleUnit, (double)windowWidth, (TimeUnit)windowTimeUnit);
    }

    private static IPsop getDerivedTPsignal(ITrace trace, ThroughputSignal signal) {
        TimeUnit windowTimeUnit;
        TimeUnit scaleUnit = signal.getScale() == null ? trace.getTimeUnit() : FormulaHelper.valueOf(signal.getScale());
        double windowWidth = signal.getConvSpec() == null ? 0.0 : signal.getConvSpec().getWindowWidth();
        TimeUnit timeUnit = windowTimeUnit = signal.getConvSpec() == null ? trace.getTimeUnit() : FormulaHelper.valueOf(signal.getConvSpec().getWindowUnit());
        if (signal.getIdAtt() != null) {
            return SignalUtil.getTP((ITrace)trace, (String)signal.getIdAtt(), (TimeUnit)scaleUnit, (double)windowWidth, (TimeUnit)windowTimeUnit);
        }
        return SignalUtil.getTP((TimeUnit)trace.getTimeUnit(), (IInterval)TraceHelper.getDomain((ITrace)trace), FormulaHelper.filterEvents(trace, signal.getAp()), (TimeUnit)scaleUnit, (double)windowWidth, (TimeUnit)windowTimeUnit);
    }

    private static IResource findResource(ITrace trace, AttributeFilter keyvals) throws FormulaBuilderException {
        Map<String, String> filter = FormulaBuilder.toMap(keyvals, null);
        IResource res = null;
        for (IResource r : trace.getResources()) {
            if (!TraceHelper.matches(filter, (Map)r.getAttributes())) continue;
            if (res != null) {
                throw new FormulaBuilderException("Filter " + String.valueOf(filter) + " selects multiple resources");
            }
            res = r;
        }
        if (res == null) {
            throw new FormulaBuilderException("Filter " + String.valueOf(filter) + " selects no resource");
        }
        return res;
    }

    private static SignalModifier getModifier(ConvSpec cs) {
        double windowWidth = 0.0;
        TimeUnit wtu = TimeUnit.SECONDS;
        if (cs != null) {
            windowWidth = cs.getWindowWidth();
            wtu = FormulaHelper.valueOf(cs.getWindowUnit());
        }
        return new SignalModifier(1.0, windowWidth, wtu);
    }

    private static List<IEvent> filterEvents(ITrace trace, MtlAp kvs) {
        ArrayList<IEvent> events;
        HashMap<String, String> filter = new HashMap<String, String>();
        for (KeyVal kv : kvs.getFilter().getKeyVals()) {
            filter.put(kv.getAtt().getLeft(), kv.getVal().getLeft());
        }
        if (kvs instanceof MtlApStart) {
            events = new ArrayList<IEvent>();
            for (IEvent e : trace.getEvents()) {
                if (!(e instanceof IClaimEvent) || ((IClaimEvent)e).getType() != ClaimEventType.START || !TraceHelper.matches(filter, (Map)e.getAttributes())) continue;
                events.add(e);
            }
            return events;
        }
        if (kvs instanceof MtlApEnd) {
            events = new ArrayList();
            for (IEvent e : trace.getEvents()) {
                if (!(e instanceof IClaimEvent) || ((IClaimEvent)e).getType() != ClaimEventType.END || !TraceHelper.matches(filter, (Map)e.getAttributes())) continue;
                events.add(e);
            }
            return events;
        }
        return TraceHelper.filter((Collection)trace.getEvents(), filter);
    }

    public static org.eclipse.trace4cps.core.impl.Interval from(TimeUnit traceTimeUnit, Interval i) {
        TimeUnitEnum timeUnit = i.getTimeUnit();
        double factor = FormulaHelper.getFactor(traceTimeUnit, timeUnit);
        if (i.getInn() != null) {
            return new org.eclipse.trace4cps.core.impl.Interval((Number)(i.getInn().getLb() * factor), false, (Number)(i.getInn().getUb() * factor), false);
        }
        if (i.getIns() != null) {
            if (i.getIns().getInfty() != null) {
                return new org.eclipse.trace4cps.core.impl.Interval((Number)(i.getIns().getLb() * factor), false, (Number)Double.POSITIVE_INFINITY, true);
            }
            return new org.eclipse.trace4cps.core.impl.Interval((Number)(i.getIns().getLb() * factor), false, (Number)(i.getIns().getUb() * factor), true);
        }
        if (i.getIsn() != null) {
            return new org.eclipse.trace4cps.core.impl.Interval((Number)(i.getIsn().getLb() * factor), true, (Number)(i.getIsn().getUb() * factor), false);
        }
        if (i.getIss() != null) {
            if (i.getIss().getInfty() != null) {
                return new org.eclipse.trace4cps.core.impl.Interval((Number)(i.getIss().getLb() * factor), true, (Number)Double.POSITIVE_INFINITY, true);
            }
            return new org.eclipse.trace4cps.core.impl.Interval((Number)(i.getIss().getLb() * factor), true, (Number)(i.getIss().getUb() * factor), true);
        }
        throw new IllegalStateException("unsupported interval");
    }

    public static double getFactor(TimeUnit traceTimeUnit, TimeUnitEnum specTimeUnit) {
        switch (specTimeUnit) {
            case NS: {
                return SignalUtil.convert((TimeUnit)traceTimeUnit, (double)1.0, (TimeUnit)TimeUnit.NANOSECONDS);
            }
            case US: {
                return SignalUtil.convert((TimeUnit)traceTimeUnit, (double)1.0, (TimeUnit)TimeUnit.MICROSECONDS);
            }
            case MS: {
                return SignalUtil.convert((TimeUnit)traceTimeUnit, (double)1.0, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            case S: {
                return SignalUtil.convert((TimeUnit)traceTimeUnit, (double)1.0, (TimeUnit)TimeUnit.SECONDS);
            }
            case MIN: {
                return SignalUtil.convert((TimeUnit)traceTimeUnit, (double)1.0, (TimeUnit)TimeUnit.MINUTES);
            }
            case HR: {
                return SignalUtil.convert((TimeUnit)traceTimeUnit, (double)1.0, (TimeUnit)TimeUnit.HOURS);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static enum FormulaType {
        MTL,
        STL,
        MIXED;

    }
}

