/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.behavior.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.eclipse.trace4cps.analysis.dist.Representation;
import org.eclipse.trace4cps.core.ClaimEventType;
import org.eclipse.trace4cps.core.IClaimEvent;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.impl.ClaimEvent;
import org.eclipse.trace4cps.core.impl.TraceHelper;

public final class FilteringClaimRepresentation
implements Representation {
    private final String idAtt;
    private final Set<String> uniquenessAtts;
    private final Map<Integer, Integer> idRemapping;
    private static final Comparator<Map.Entry<String, String>> COMP = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    public FilteringClaimRepresentation(String idAtt, Set<String> uniquenessAtts, Map<Integer, Integer> idRemapping) {
        this.idAtt = idAtt;
        this.uniquenessAtts = uniquenessAtts;
        this.idRemapping = idRemapping;
    }

    @Override
    public String represent(IEvent event) {
        StringBuilder b = new StringBuilder();
        ArrayList<Map.Entry<String, String>> le = new ArrayList<Map.Entry<String, String>>();
        le.addAll(event.getAttributes().entrySet());
        Collections.sort(le, COMP);
        for (Map.Entry entry : le) {
            String a = (String)entry.getKey();
            String v = (String)entry.getValue();
            if (!a.equals(this.idAtt) && (this.uniquenessAtts == null || this.uniquenessAtts.contains(a))) {
                b.append(a).append("=").append(v).append(";");
                continue;
            }
            if (!a.equals(this.idAtt)) continue;
            Integer vi = Integer.parseInt(v);
            b.append(a).append("=").append(this.idRemapping.get(vi)).append(";");
        }
        if (event instanceof IClaimEvent) {
            ClaimEvent claimEvent = (ClaimEvent)event;
            b.append("res={");
            b.append(TraceHelper.getValues(claimEvent.getClaim().getResource(), true));
            b.append("};");
            if (claimEvent.getType() == ClaimEventType.START) {
                b.append("s");
            } else if (claimEvent.getType() == ClaimEventType.END) {
                b.append("e");
            }
        }
        return b.toString();
    }
}

