/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.deps;

import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.SourceCodeEscapers;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class ClosureBundler {
    private boolean useEval = false;
    private String sourceUrl = null;

    public final ClosureBundler useEval(boolean useEval) {
        this.useEval = useEval;
        return this;
    }

    public final ClosureBundler withSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    public static void appendInput(Appendable out, DependencyInfo info, String contents) throws IOException {
        new ClosureBundler().appendTo(out, info, contents);
    }

    public void appendTo(Appendable out, DependencyInfo info, String content) throws IOException {
        this.appendTo(out, info, CharSource.wrap((CharSequence)content));
    }

    public void appendTo(Appendable out, DependencyInfo info, File content, Charset contentCharset) throws IOException {
        this.appendTo(out, info, Files.asCharSource((File)content, (Charset)contentCharset));
    }

    public void appendTo(Appendable out, DependencyInfo info, CharSource content) throws IOException {
        if (info.isModule()) {
            this.appendGoogModule(out, content);
        } else {
            this.appendTraditional(out, content);
        }
    }

    private void appendTraditional(Appendable out, CharSource contents) throws IOException {
        if (this.useEval) {
            out.append("(0,eval(\"");
            this.append(out, Mode.ESCAPED, contents);
            this.appendSourceUrl(out, Mode.ESCAPED);
            out.append("\"));");
        } else {
            this.append(out, Mode.NORMAL, contents);
            this.appendSourceUrl(out, Mode.NORMAL);
        }
    }

    private void appendGoogModule(Appendable out, CharSource contents) throws IOException {
        if (this.useEval) {
            out.append("goog.loadModule(\"");
            this.append(out, Mode.ESCAPED, contents);
            this.appendSourceUrl(out, Mode.ESCAPED);
            out.append("\");");
        } else {
            out.append("goog.loadModule(function(exports) {'use strict';");
            this.append(out, Mode.NORMAL, contents);
            out.append("\n;return exports;});\n");
            this.appendSourceUrl(out, Mode.NORMAL);
        }
    }

    private void append(Appendable out, Mode mode, String s) throws IOException {
        String transformed = this.transformInput(s);
        mode.append(transformed, out);
    }

    private void append(Appendable out, Mode mode, CharSource cs) throws IOException {
        this.append(out, mode, cs.read());
    }

    private void appendSourceUrl(Appendable out, Mode mode) throws IOException {
        if (this.sourceUrl == null) {
            return;
        }
        String toAppend = "\n//# sourceURL=" + this.sourceUrl + "\n";
        mode.append(toAppend, out);
    }

    protected String transformInput(String input) {
        return input;
    }

    private static enum Mode {
        ESCAPED{

            @Override
            void append(String s, Appendable out) throws IOException {
                out.append(SourceCodeEscapers.javascriptEscaper().escape(s));
            }
        }
        ,
        NORMAL{

            @Override
            void append(String s, Appendable out) throws IOException {
                out.append(s);
            }
        };


        abstract void append(String var1, Appendable var2) throws IOException;
    }
}

