/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.console.actions;

import org.eclipse.ease.ui.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.IConsole;

public abstract class ShowWhenContentChangesAction
extends Action
implements IPropertyChangeListener {
    private final String mConsoleName;

    public ShowWhenContentChangesAction(String name, IConsole console) {
        super(name, 2);
        this.mConsoleName = console.getName();
        this.setToolTipText(name);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals(this.getPreferenceKey())) {
            this.update();
        }
    }

    private String getPreferenceKey() {
        return "org.eclipse.ease.console.prefs." + this.mConsoleName + "." + this.getKey();
    }

    protected abstract String getKey();

    private void update() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getBoolean(this.getPreferenceKey())) {
            this.setChecked(true);
        } else {
            this.setChecked(false);
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void run() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean show = this.isChecked();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
        store.setValue(this.getPreferenceKey(), show);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

