/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public abstract class ToggleViewPaneAction
extends Action
implements IViewActionDelegate,
IActionDelegate2,
IPropertyChangeListener {
    MemoryView fView;
    IAction fAction;

    public void init(IViewPart view) {
        if (view instanceof MemoryView) {
            this.fView = (MemoryView)view;
        }
    }

    public void run(IAction action) {
        if (this.fView == null) {
            return;
        }
        this.fView.showViewPane(!this.fView.isViewPaneVisible(this.getPaneId()), this.getPaneId());
        if (this.fView.isViewPaneVisible(this.getPaneId())) {
            action.setChecked(true);
        } else {
            action.setChecked(false);
        }
    }

    public void run() {
        if (this.fView == null) {
            return;
        }
        this.fView.showViewPane(!this.fView.isViewPaneVisible(this.getPaneId()), this.getPaneId());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fView.isViewPaneVisible(this.getPaneId())) {
            action.setChecked(true);
        } else {
            action.setChecked(false);
        }
    }

    public void dispose() {
        DebugUITools.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void init(IAction action) {
        this.fAction = action;
        DebugUITools.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fView != null && this.fAction != null) {
            if (this.fView.isViewPaneVisible(this.getPaneId())) {
                this.fAction.setChecked(true);
            } else {
                this.fAction.setChecked(false);
            }
        }
    }

    public abstract String getPaneId();
}

