/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.actions;

import java.io.IOException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.exceptions.MalformedInputExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.actions.ResourceActionDelegate;

public class FormatActionDelegate
extends ResourceActionDelegate {
    private MultiStatus fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);

    protected void format(IProgressMonitor monitor, IFile file) {
        if (monitor == null || monitor.isCanceled()) {
            return;
        }
        try {
            IContentType contentType;
            IStructuredFormatProcessor formatProcessor;
            monitor.beginTask("", 100);
            IContentDescription contentDescription = file.getContentDescription();
            monitor.worked(5);
            if (!(contentDescription == null || (formatProcessor = this.getFormatProcessor((contentType = contentDescription.getContentType()).getId())) == null || monitor != null && monitor.isCanceled())) {
                String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_3, (Object[])new String[]{file.getFullPath().toString().substring(1)});
                monitor.subTask(message);
                formatProcessor.setProgressMonitor(monitor);
                formatProcessor.formatFile(file);
            }
            monitor.worked(95);
            monitor.done();
        }
        catch (MalformedInputExceptionWithDetail e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_5, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (IOException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
    }

    private Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void format(final IProgressMonitor monitor, IResource resource) {
        if (resource instanceof IFile) {
            final IFile file = (IFile)resource;
            try {
                try {
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    ITextFileBuffer buffer = null;
                    try {
                        if (manager != null) {
                            manager.connect(file.getFullPath(), LocationKind.IFILE, monitor);
                            buffer = manager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
                        }
                        if (buffer != null && buffer.isShared()) {
                            Display display = this.getDisplay();
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FormatActionDelegate.this.format(monitor, file);
                                }
                            });
                            return;
                        }
                        this.format(monitor, file);
                        return;
                    }
                    finally {
                        if (manager != null) {
                            manager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                }
                catch (CoreException e) {
                    String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{file.getFullPath().toString()});
                    this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
                    if (monitor == null) return;
                    monitor.done();
                }
                return;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        if (!(resource instanceof IContainer)) return;
        IContainer container = (IContainer)resource;
        try {
            IResource[] members = container.members();
            monitor.beginTask("", members.length);
            int i = 0;
            while (i < members.length) {
                if (monitor != null && !monitor.isCanceled()) {
                    this.format((IProgressMonitor)new SubProgressMonitor(monitor, 1), members[i]);
                }
                ++i;
            }
            monitor.done();
            return;
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{resource.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
    }

    protected IStructuredFormatProcessor getFormatProcessor(String contentTypeId) {
        return FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentTypeId);
    }

    @Override
    protected Job getJob() {
        return new FormatJob(SSEUIMessages.FormatActionDelegate_jobName);
    }

    protected void process(IProgressMonitor monitor, IResource resource) {
        monitor.beginTask("", 100);
        this.format((IProgressMonitor)new SubProgressMonitor(monitor, 98), resource);
        try {
            resource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (CoreException e) {
            String message = NLS.bind((String)SSEUIMessages.FormatActionDelegate_4, (Object[])new String[]{resource.getFullPath().toString()});
            this.fErrorStatus.add((IStatus)new Status(4, "org.eclipse.wst.sse.ui", 4, message, (Throwable)e));
        }
        monitor.done();
    }

    @Override
    protected boolean processorAvailable(IResource resource) {
        boolean result;
        block8: {
            result = false;
            if (resource.isAccessible()) {
                try {
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        IStructuredFormatProcessor formatProcessor = null;
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription != null) {
                            IContentType contentType = contentDescription.getContentType();
                            formatProcessor = this.getFormatProcessor(contentType.getId());
                        }
                        if (formatProcessor != null) {
                            result = true;
                        }
                        break block8;
                    }
                    if (!(resource instanceof IContainer)) break block8;
                    IContainer container = (IContainer)resource;
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        boolean available = this.processorAvailable(members[i]);
                        if (available) {
                            result = true;
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
        }
        return result;
    }

    class FormatJob
    extends Job {
        public FormatJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            Object[] elements = FormatActionDelegate.this.fSelection.toArray();
            monitor.beginTask("", elements.length);
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof IResource) {
                    FormatActionDelegate.this.process((IProgressMonitor)new SubProgressMonitor(monitor, 1), (IResource)elements[i]);
                } else {
                    monitor.worked(1);
                }
                ++i;
            }
            monitor.done();
            if (FormatActionDelegate.this.fErrorStatus.getChildren().length > 0) {
                status = FormatActionDelegate.this.fErrorStatus;
                FormatActionDelegate.this.fErrorStatus = new MultiStatus("org.eclipse.wst.sse.ui", 4, SSEUIMessages.FormatActionDelegate_errorStatusMessage, null);
            }
            return status;
        }
    }
}

