/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineLaunchExtension;
import org.eclipse.ease.Script;

public class ResourceProjectPathImporter
implements IScriptEngineLaunchExtension,
IExecutionListener {
    private final Collection<IProject> fRegisteredProjects = new HashSet<IProject>();

    public void createEngine(IScriptEngine engine) {
        engine.addExecutionListener((IExecutionListener)this);
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (status == 3) {
            Object file = script.getFile();
            if (file instanceof IResource) {
                this.registerProject(((IResource)file).getProject(), engine);
            } else {
                file = engine.getExecutedFile();
                if (file instanceof IResource) {
                    this.registerProject(((IResource)file).getProject(), engine);
                }
            }
        }
    }

    private void registerProject(IProject project, IScriptEngine engine) {
        if (!this.fRegisteredProjects.contains(project)) {
            this.fRegisteredProjects.add(project);
            this.doRegisterProject(project, engine);
        }
    }

    protected void doRegisterProject(IProject project, IScriptEngine engine) {
        try {
            String path = project.getLocation().toOSString();
            String code = String.format("import sys%nsys.path.append('%s')%n", path).replace("\\", "\\\\");
            engine.inject((Object)code, false);
        }
        catch (NoClassDefFoundError | ExecutionException throwable) {
            // empty catch block
        }
    }
}

