/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.OperatorPrecedence;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ParameterData;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;

class SourceAnalyzer {
    private ITypeRoot fTypeRoot;
    private FunctionDeclaration fDeclaration;
    private Map fParameters;
    private Map fNames;
    private List fImplicitReceivers;
    private boolean fArrayAccess;
    private boolean fHasSuperMethodInvocation;
    private List fTypesToImport;
    private List fStaticsToImport;
    private List fTypeParameterReferences;
    private Map fTypeParameterMapping;
    private List fMethodTypeParameterReferences;
    private Map fMethodTypeParameterMapping;
    private boolean fInterruptedExecutionFlow;

    public SourceAnalyzer(ITypeRoot typeRoot, FunctionDeclaration declaration) {
        this.fTypeRoot = typeRoot;
        this.fDeclaration = declaration;
    }

    public boolean isExecutionFlowInterrupted() {
        return this.fInterruptedExecutionFlow;
    }

    public RefactoringStatus checkActivation() throws JavaScriptModelException {
        List parameters;
        RefactoringStatus result = new RefactoringStatus();
        if (!this.fTypeRoot.isStructureKnown()) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_syntax_errors, JavaStatusContext.create(this.fTypeRoot));
            return result;
        }
        IProblem[] problems = ASTNodes.getProblems((ASTNode)this.fDeclaration, 0, 2);
        if (problems.length > 0) {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
            return result;
        }
        IFunctionBinding declarationBinding = this.fDeclaration.resolveBinding();
        if (declarationBinding != null) {
            int modifiers = declarationBinding.getModifiers();
            if (Modifier.isAbstract((int)modifiers)) {
                result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_abstract_methods, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                return result;
            }
            if (Modifier.isNative((int)modifiers)) {
                result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_native_methods, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                return result;
            }
        } else {
            result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_methoddeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
            return result;
        }
        ActivationAnalyzer analyzer = new ActivationAnalyzer();
        this.fDeclaration.accept((ASTVisitor)analyzer);
        result.merge(analyzer.status);
        if (!result.hasFatalError()) {
            parameters = this.fDeclaration.parameters();
            this.fParameters = new HashMap(parameters.size() * 2);
            for (SingleVariableDeclaration element : parameters) {
                IVariableBinding binding = element.resolveBinding();
                if (binding == null) {
                    result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(this.fTypeRoot, (ASTNode)this.fDeclaration));
                    return result;
                }
                this.fParameters.put(binding, element.getProperty(ParameterData.PROPERTY));
            }
            this.fNames = new HashMap();
            this.fImplicitReceivers = new ArrayList(2);
            this.fTypeParameterReferences = new ArrayList(0);
            this.fTypeParameterMapping = new HashMap();
            ITypeBinding declaringType = declarationBinding.getDeclaringClass();
            if (declaringType == null) {
                result.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_typedeclaration_has_errors, JavaStatusContext.create(this.fTypeRoot));
                return result;
            }
            this.fMethodTypeParameterReferences = new ArrayList(0);
            this.fMethodTypeParameterMapping = new HashMap();
        }
        if (this.fDeclaration.isVarargs()) {
            parameters = this.fDeclaration.parameters();
            VarargAnalyzer vAnalyzer = new VarargAnalyzer(((SingleVariableDeclaration)parameters.get(parameters.size() - 1)).getName().resolveBinding());
            this.fDeclaration.getBody().accept((ASTVisitor)vAnalyzer);
        }
        return result;
    }

    public void initialize() {
        Block body = this.fDeclaration.getBody();
        this.fTypesToImport = new ArrayList();
        this.fStaticsToImport = new ArrayList();
        ImportReferencesCollector collector = new ImportReferencesCollector(this.fTypeRoot.getJavaScriptProject(), null, this.fTypesToImport, this.fStaticsToImport);
        body.accept((ASTVisitor)collector);
        body.accept((ASTVisitor)new UpdateCollector());
        int numberOfLocals = LocalVariableIndex.perform((BodyDeclaration)this.fDeclaration);
        FlowContext context = new FlowContext(0, numberOfLocals + 1);
        context.setConsiderAccessMode(true);
        context.setComputeMode(FlowContext.MERGE);
        InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(context);
        FlowInfo info = flowAnalyzer.perform(this.getStatements());
        for (SingleVariableDeclaration element : this.fDeclaration.parameters()) {
            IVariableBinding binding = element.resolveBinding();
            ParameterData data = (ParameterData)element.getProperty(ParameterData.PROPERTY);
            data.setAccessMode(info.getAccessMode(context, binding));
        }
    }

    public Collection getUsedNames() {
        return this.fNames.values();
    }

    public List getImplicitReceivers() {
        return this.fImplicitReceivers;
    }

    public List getTypesToImport() {
        return this.fTypesToImport;
    }

    public List getStaticsToImport() {
        return this.fStaticsToImport;
    }

    public List getTypeParameterReferences() {
        return this.fTypeParameterReferences;
    }

    public List getMethodTypeParameterReferences() {
        return this.fMethodTypeParameterReferences;
    }

    public boolean hasArrayAccess() {
        return this.fArrayAccess;
    }

    public boolean hasSuperMethodInvocation() {
        return this.fHasSuperMethodInvocation;
    }

    private ASTNode[] getStatements() {
        List statements = this.fDeclaration.getBody().statements();
        return statements.toArray(new ASTNode[statements.size()]);
    }

    private class ActivationAnalyzer
    extends ASTVisitor {
        public RefactoringStatus status = new RefactoringStatus();
        private ASTNode fLastNode = this.getLastNode();
        private IFunctionBinding fBinding = this.getBinding();

        private ActivationAnalyzer() {
        }

        public boolean visit(ReturnStatement node) {
            if (node != this.fLastNode) {
                SourceAnalyzer.this.fInterruptedExecutionFlow = true;
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            return false;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            return false;
        }

        public boolean visit(FunctionInvocation node) {
            IFunctionBinding methodBinding = node.resolveMethodBinding();
            if (methodBinding != null) {
                methodBinding.getMethodDeclaration();
            }
            if (this.fBinding != null && methodBinding != null && this.fBinding.isEqualTo((IBinding)methodBinding) && !this.status.hasFatalError()) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_recursive_call);
                return false;
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            IBinding binding = node.resolveBinding();
            if (binding == null && !this.status.hasFatalError() && !ASTNodes.isLabel(node)) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_declaration_has_errors, JavaStatusContext.create(SourceAnalyzer.this.fTypeRoot, (ASTNode)SourceAnalyzer.this.fDeclaration));
                return false;
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            if (node.getQualifier() != null) {
                this.status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_SourceAnalyzer_qualified_this_expressions, JavaStatusContext.create(SourceAnalyzer.this.fTypeRoot, (ASTNode)node));
                return false;
            }
            return true;
        }

        private ASTNode getLastNode() {
            List statements = SourceAnalyzer.this.fDeclaration.getBody().statements();
            if (statements.size() == 0) {
                return null;
            }
            return (ASTNode)statements.get(statements.size() - 1);
        }

        private IFunctionBinding getBinding() {
            IFunctionBinding result = SourceAnalyzer.this.fDeclaration.resolveBinding();
            if (result != null) {
                return result.getMethodDeclaration();
            }
            return result;
        }
    }

    public static class NameData {
        private String fName;
        private List fReferences;

        public NameData(String n) {
            this.fName = n;
            this.fReferences = new ArrayList(2);
        }

        public String getName() {
            return this.fName;
        }

        public void addReference(SimpleName ref) {
            this.fReferences.add(ref);
        }

        public List references() {
            return this.fReferences;
        }
    }

    private class UpdateCollector
    extends ASTVisitor {
        private int fTypeCounter;

        private UpdateCollector() {
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public void endVisit(TypeDeclaration node) {
            --this.fTypeCounter;
        }

        private boolean visitType(AbstractTypeDeclaration node) {
            if (this.fTypeCounter++ == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(AnonymousClassDeclaration node) {
            ++this.fTypeCounter;
            return true;
        }

        public void endVisit(AnonymousClassDeclaration node) {
            --this.fTypeCounter;
        }

        public boolean visit(FieldAccess node) {
            node.getExpression().accept((ASTVisitor)this);
            this.addReferencesToName(node.getName());
            return false;
        }

        public boolean visit(FunctionDeclaration node) {
            if (node.isConstructor()) {
                AbstractTypeDeclaration decl = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)node, AbstractTypeDeclaration.class);
                NameData name = (NameData)SourceAnalyzer.this.fNames.get(decl.getName().resolveBinding());
                if (name != null) {
                    name.addReference(node.getName());
                }
            }
            return true;
        }

        public boolean visit(FunctionInvocation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null && !this.isStaticallyImported((Name)node.getName())) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(SuperMethodInvocation node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fHasSuperMethodInvocation = true;
            }
            return true;
        }

        public boolean visist(SuperConstructorInvocation node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fHasSuperMethodInvocation = true;
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation node) {
            Expression receiver;
            if (this.fTypeCounter == 0 && (receiver = node.getExpression()) == null && node.resolveTypeBinding().isLocal()) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration node) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(VariableDeclarationFragment node) {
            if (this.fTypeCounter == 0) {
                this.addNameReference(node.getName());
            }
            return true;
        }

        public boolean visit(SimpleName node) {
            this.addReferencesToName(node);
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding) {
                int precedence;
                ASTNode parent;
                ParameterData data;
                IVariableBinding vb = (IVariableBinding)binding;
                if (vb.isField() && !this.isStaticallyImported((Name)node)) {
                    StructuralPropertyDescriptor location;
                    Name topName = ASTNodes.getTopMostName((Name)node);
                    if ((node == topName || node == ASTNodes.getLeftMostSimpleName(topName)) && (location = node.getLocationInParent()) != SingleVariableDeclaration.NAME_PROPERTY && location != VariableDeclarationFragment.NAME_PROPERTY) {
                        SourceAnalyzer.this.fImplicitReceivers.add(node);
                    }
                } else if (!vb.isField() && (data = (ParameterData)SourceAnalyzer.this.fParameters.get(binding)) != null && (parent = node.getParent()) instanceof Expression && (precedence = OperatorPrecedence.getValue((Expression)parent)) != -1) {
                    data.setOperatorPrecedence((ASTNode)node, precedence);
                }
            }
            return true;
        }

        public boolean visit(ThisExpression node) {
            if (this.fTypeCounter == 0) {
                SourceAnalyzer.this.fImplicitReceivers.add(node);
            }
            return true;
        }

        private void addReferencesToName(SimpleName node) {
            NameData name;
            IBinding binding = node.resolveBinding();
            ParameterData data = (ParameterData)SourceAnalyzer.this.fParameters.get(binding);
            if (data != null) {
                data.addReference((ASTNode)node);
            }
            if ((name = (NameData)SourceAnalyzer.this.fNames.get(binding)) != null) {
                name.addReference(node);
            }
        }

        private void addNameReference(SimpleName name) {
            SourceAnalyzer.this.fNames.put(name.resolveBinding(), new NameData(name.getIdentifier()));
        }

        private void addTypeVariableReference(ITypeBinding variable, SimpleName name) {
            NameData data = (NameData)SourceAnalyzer.this.fTypeParameterMapping.get(variable);
            if (data == null) {
                data = (NameData)SourceAnalyzer.this.fMethodTypeParameterMapping.get(variable);
            }
            data.addReference(name);
        }

        private boolean isStaticallyImported(Name name) {
            return SourceAnalyzer.this.fStaticsToImport.contains(name);
        }
    }

    private class VarargAnalyzer
    extends ASTVisitor {
        private IBinding fParameter;

        public VarargAnalyzer(IBinding parameter) {
            this.fParameter = parameter;
        }

        public boolean visit(ArrayAccess node) {
            Expression array = node.getArray();
            if (array instanceof SimpleName && this.fParameter.isEqualTo(((SimpleName)array).resolveBinding())) {
                SourceAnalyzer.this.fArrayAccess = true;
            }
            return true;
        }
    }
}

