/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis.requirements;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class TmfAnalysisEventFieldRequirement
extends TmfAbstractAnalysisRequirement {
    private String fEventName;

    public TmfAnalysisEventFieldRequirement(String eventName, Collection<String> fields) {
        this(eventName, fields, TmfAbstractAnalysisRequirement.PriorityLevel.OPTIONAL);
    }

    public TmfAnalysisEventFieldRequirement(String eventName, Collection<String> fields, TmfAbstractAnalysisRequirement.PriorityLevel level) {
        super(fields, level);
        this.fEventName = eventName;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public boolean test(ITmfTrace trace) {
        if (!(trace instanceof ITmfTraceWithPreDefinedEvents)) {
            return true;
        }
        Set<String> values = this.getValues();
        if (values.isEmpty()) {
            return true;
        }
        Multimap<@NonNull String, @NonNull String> traceEvents = TmfEventTypeCollectionHelper.getEventFieldNames(((ITmfTraceWithPreDefinedEvents)((Object)trace)).getContainedEventTypes());
        if (this.fEventName.isEmpty()) {
            switch (this.getPriorityLevel()) {
                case ALL_OR_NOTHING: {
                    return traceEvents.keys().stream().allMatch(eventName -> {
                        HashSet<@NonNull E> fields = new HashSet(traceEvents.get(eventName));
                        fields.retainAll(values);
                        return fields.isEmpty() || fields.size() == values.size();
                    });
                }
                case AT_LEAST_ONE: {
                    return traceEvents.keys().stream().allMatch(eventName -> {
                        HashSet<@NonNull E> fields = new HashSet(traceEvents.get(eventName));
                        fields.retainAll(values);
                        return !fields.isEmpty();
                    });
                }
                case MANDATORY: {
                    return traceEvents.keys().stream().allMatch(eventName -> {
                        @NonNull Collection fields = traceEvents.get(eventName);
                        return fields.containsAll(values);
                    });
                }
                case OPTIONAL: {
                    return true;
                }
            }
            throw new IllegalStateException("Unknown value level: " + String.valueOf((Object)this.getPriorityLevel()));
        }
        @NonNull Collection fields = traceEvents.get((Object)this.fEventName);
        switch (this.getPriorityLevel()) {
            case ALL_OR_NOTHING: {
                fields.retainAll(values);
                return fields.isEmpty() || fields.size() == values.size();
            }
            case AT_LEAST_ONE: {
                fields.retainAll(values);
                return !fields.isEmpty();
            }
            case MANDATORY: {
                return fields.containsAll(values);
            }
            case OPTIONAL: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown value level: " + String.valueOf((Object)this.getPriorityLevel()));
    }
}

