/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.PathEntryManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SetPathEntryContainerOperation
extends CModelOperation {
    IPathEntryContainer newContainer;
    ICProject[] affectedProjects;
    PathEntryManager fPathEntryManager;
    IPath containerPath;

    public SetPathEntryContainerOperation(ICProject[] affectedProjects, IPathEntryContainer newContainer) {
        super(affectedProjects);
        this.affectedProjects = affectedProjects;
        this.newContainer = newContainer;
        this.containerPath = newContainer == null ? new Path("") : newContainer.getPath();
        this.fPathEntryManager = PathEntryManager.getDefault();
    }

    public SetPathEntryContainerOperation(ICProject[] affectedProjects, IPath containerPath) {
        super(affectedProjects);
        this.affectedProjects = affectedProjects;
        this.containerPath = containerPath;
        this.fPathEntryManager = PathEntryManager.getDefault();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected void executeOperation() throws CModelException {
        ICProject affectedProject;
        if (this.isCanceled()) {
            return;
        }
        int projectLength = this.affectedProjects.length;
        ICProject[] modifiedProjects = new ICProject[projectLength];
        System.arraycopy(this.affectedProjects, 0, modifiedProjects, 0, projectLength);
        IPathEntry[][] oldResolvedEntries = new IPathEntry[projectLength][];
        int remaining = 0;
        int i = 0;
        while (i < projectLength) {
            if (this.isCanceled()) {
                return;
            }
            affectedProject = this.affectedProjects[i];
            boolean found = false;
            IPathEntry[] rawPath = this.fPathEntryManager.getRawPathEntries(affectedProject);
            int j = 0;
            int cpLength = rawPath.length;
            while (j < cpLength) {
                IContainerEntry cont;
                IPathEntry entry = rawPath[j];
                if (entry.getEntryKind() == 32 && (cont = (IContainerEntry)entry).getPath().equals((Object)this.containerPath)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found || this.newContainer == null) {
                modifiedProjects[i] = null;
                this.fPathEntryManager.containerPut(affectedProject, this.containerPath, this.newContainer);
            } else {
                IPathEntryContainer oldContainer = this.fPathEntryManager.containerGet(affectedProject, this.containerPath, true);
                if (oldContainer != null && this.newContainer != null && oldContainer.equals(this.newContainer)) {
                    modifiedProjects[i] = null;
                } else {
                    ++remaining;
                    oldResolvedEntries[i] = this.fPathEntryManager.removeCachedResolvedPathEntries(affectedProject);
                    this.fPathEntryManager.containerPut(affectedProject, this.containerPath, this.newContainer);
                }
            }
            ++i;
        }
        if (remaining == 0) {
            return;
        }
        i = 0;
        while (i < projectLength) {
            IPathEntry[] newEntries;
            ICElementDelta[] deltas;
            if (this.isCanceled()) {
                return;
            }
            affectedProject = modifiedProjects[i];
            if (affectedProject != null && oldResolvedEntries[i] != null && (deltas = this.fPathEntryManager.generatePathEntryDeltas(affectedProject, oldResolvedEntries[i], newEntries = this.fPathEntryManager.getResolvedPathEntries(affectedProject))).length > 0) {
                affectedProject.close();
                int j = 0;
                while (j < deltas.length) {
                    this.addDelta(deltas[j]);
                    ++j;
                }
            }
            ++i;
        }
    }
}

