/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.eclipse.wizards;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.virgo.ide.eclipse.wizards.ProjectContentPage;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelSynchHelper;
import org.eclipse.wst.common.frameworks.internal.ui.ValidationStatus;
import org.eclipse.wst.web.internal.ResourceHandler;
import org.eclipse.wst.web.ui.internal.wizards.DataModelFacetCreationWizardPage;

public abstract class RuntimeConfigurationPage
extends ProjectContentPage
implements IDataModelListener,
IFacetProjectCreationDataModelProperties {
    private final ValidationStatus status = new ValidationStatus();
    private final IDataModel model;
    private Map validationMap;
    private String[] validationPropertyNames;
    private final DataModelSynchHelper synchHelper;
    private Combo serverTargetCombo;

    protected RuntimeConfigurationPage(String pageName, IProjectProvider provider, AbstractFieldData data, IDataModel model) {
        super(pageName, provider, data);
        this.model = model;
        model.addListener((IDataModelListener)this);
        this.synchHelper = this.initializeSynchHelper(model);
    }

    protected abstract void createAdditionalPropertiesGroup(Composite var1);

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createPluginPropertiesGroup(container);
        this.createAdditionalPropertiesGroup(container);
        this.createServerTargetComposite(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        this.setDefaults();
        this.initializeValidationProperties();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.new_project_required_data");
    }

    private void createServerTargetComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(ResourceHandler.TargetRuntime);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        this.serverTargetCombo = new Combo((Composite)group, 2056);
        this.serverTargetCombo.setLayoutData((Object)new GridData(768));
        Button newServerTargetButton = new Button((Composite)group, 0);
        newServerTargetButton.setText(ResourceHandler.NewDotDotDot);
        newServerTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeConfigurationPage.this.internalLaunchNewRuntimeWizard(RuntimeConfigurationPage.this.getShell(), RuntimeConfigurationPage.this.model);
            }
        });
        Control[] deps = new Control[]{newServerTargetButton};
        this.synchHelper.synchCombo(this.serverTargetCombo, "IFacetProjectCreationDataModelProperties.FACET_RUNTIME", deps);
        if (this.serverTargetCombo.getSelectionIndex() == -1 && this.serverTargetCombo.getVisibleItemCount() != 0) {
            this.serverTargetCombo.select(0);
        }
    }

    protected abstract String getModuleTypeID();

    private boolean getStatus(Integer key) {
        return this.status.hasError(key);
    }

    private String[] getValidationPropertyNames() {
        return new String[]{"IProjectCreationPropertiesNew.PROJECT_LOCATION", "IFacetProjectCreationDataModelProperties.FACET_RUNTIME"};
    }

    private DataModelSynchHelper initializeSynchHelper(IDataModel dm) {
        return new DataModelSynchHelper(dm);
    }

    private void initializeValidationProperties() {
        this.validationPropertyNames = this.getValidationPropertyNames();
        if (this.validationPropertyNames == null || this.validationPropertyNames.length == 0) {
            this.validationMap = Collections.EMPTY_MAP;
        } else {
            this.validationMap = new HashMap(this.validationPropertyNames.length);
            int i = 0;
            while (i < this.validationPropertyNames.length) {
                this.validationMap.put(this.validationPropertyNames[i], new Integer(i));
                ++i;
            }
        }
    }

    private boolean internalLaunchNewRuntimeWizard(Shell shell, IDataModel model) {
        return DataModelFacetCreationWizardPage.launchNewRuntimeWizard((Shell)shell, (IDataModel)model, (String)this.getModuleTypeID());
    }

    public void performPageFinish() {
        super.updateData();
        this.storeDefaultSettings();
    }

    public void propertyChanged(DataModelEvent event) {
        String propertyName = event.getPropertyName();
        if (this.validationPropertyNames != null && (event.getFlag() == 1 || !this.isPageComplete() && event.getFlag() == 4)) {
            String[] stringArray = this.validationPropertyNames;
            int n = this.validationPropertyNames.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.equals(propertyName)) {
                    this.validatePage();
                    break;
                }
                ++n2;
            }
        }
    }

    private void restoreDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DataModelFacetCreationWizardPage.restoreRuntimeSettings((IDialogSettings)settings, (IDataModel)this.model);
    }

    private void setDefaults() {
        this.restoreDefaultSettings();
    }

    private void setErrorMessage() {
        String error = this.status.getLastErrMsg();
        if (error == null) {
            String warning;
            if (this.getErrorMessage() != null) {
                this.setErrorMessage(null);
            }
            if ((warning = this.status.getLastWarningMsg()) == null) {
                if (this.getMessage() != null && this.getMessageType() == 2) {
                    this.setMessage(null, 2);
                } else {
                    String info = this.status.getLastInfoMsg();
                    if (info == null) {
                        if (this.getMessage() != null && this.getMessageType() == 1) {
                            this.setMessage(null, 1);
                        }
                    } else if (!info.equals(this.getMessage())) {
                        this.setMessage(info, 1);
                    }
                }
            } else if (!warning.equals(this.getMessage())) {
                this.setMessage(warning, 2);
            }
        } else if (!error.equals(this.getErrorMessage())) {
            this.setErrorMessage(error);
        }
    }

    private void setErrorStatus(Integer key, String errorMessage) {
        this.status.setErrorStatus(key, errorMessage);
    }

    private void setInfoStatus(Integer key, String infoMessage) {
        this.status.setInfoStatus(key, infoMessage);
    }

    private void setOKStatus(Integer key) {
        this.status.setOKStatus(key);
    }

    private void setWarningStatus(Integer key, String warningMessage) {
        this.status.setWarningStatus(key, warningMessage);
    }

    private void storeDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        DataModelFacetCreationWizardPage.saveRuntimeSettings((IDialogSettings)settings, (IDataModel)this.model);
    }

    private void updateControls() {
    }

    private String validateControlsBase() {
        if (!this.validationMap.isEmpty()) {
            String[] stringArray = this.validationPropertyNames;
            int n = this.validationPropertyNames.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                String propName = element;
                Integer valKey = (Integer)this.validationMap.get(propName);
                if (valKey != null) {
                    this.validateProperty(propName, valKey);
                }
                if (!this.getStatus(valKey)) {
                    return propName;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void validatePage() {
        super.validatePage();
        if (this.isPageComplete()) {
            this.validateControlsBase();
            this.updateControls();
            this.setErrorMessage();
            this.setPageComplete(this.status.getLastErrMsg() == null);
        }
    }

    private void validateProperty(String propertyName, Integer validationKey) {
        this.setOKStatus(validationKey);
        IStatus status1 = this.model.validateProperty(propertyName);
        if (!status1.isOK()) {
            String message = status1.isMultiStatus() ? status1.getChildren()[0].getMessage() : status1.getMessage();
            switch (status1.getSeverity()) {
                case 4: {
                    this.setErrorStatus(validationKey, message);
                    break;
                }
                case 2: {
                    this.setWarningStatus(validationKey, message);
                    break;
                }
                case 1: {
                    this.setInfoStatus(validationKey, message);
                }
            }
        }
    }
}

