/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.ide.runtime.internal.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.ui.PlatformUI;
import org.eclipse.virgo.ide.runtime.core.IServerRuntimeWorkingCopy;
import org.eclipse.virgo.ide.runtime.internal.ui.ServerUiPlugin;
import org.eclipse.virgo.kernel.osgi.provisioning.tools.NoOpEventLogger;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.repository.configuration.ExternalStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.ManagedStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.PropertiesRepositoryConfigurationReader;
import org.eclipse.virgo.repository.configuration.RepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.WatchedStorageRepositoryConfiguration;
import org.eclipse.virgo.util.math.OrderedPair;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PDEHelper {
    private static final String DOT = ".";
    private static final String PLUGINS = "plugins";
    private static final String CONFIG_FILENAME = "org.eclipse.virgo.repository.properties";
    private static final String CONFIGURATION = "configuration";
    private static final String ANY_JAR = "*.jar";
    private static final String STAR = "*";
    private static final String WATCH_DIRECTORY = ".watchDirectory";
    private static final String TYPE_WATCHED = "watched";
    private static final String REPO_TYPE = ".type";
    private static final String ADDED_BY_VIRGO_TOOLS = "addedByVirgoTools";
    private static final String COMMA = ",";
    private static final String CHAIN_PROPERTY = "chain";

    private PDEHelper() {
    }

    public static List<File> getFoldersForTargetDefinition(IRuntimeWorkingCopy runtime) {
        Assert.isNotNull((Object)runtime, (String)"runtime cannot be null");
        ArrayList<File> locations = new ArrayList<File>();
        if (runtime.getLocation() != null) {
            locations.add(runtime.getLocation().append(PLUGINS).toFile());
            locations.addAll(PDEHelper.getRepositoryChain(runtime).values());
        }
        return locations;
    }

    private static LinkedHashMap<String, File> getRepositoryChain(IRuntimeWorkingCopy runtime) {
        LinkedHashMap<String, File> locations;
        block17: {
            Assert.isNotNull((Object)runtime, (String)"runtime cannot be null");
            locations = new LinkedHashMap<String, File>();
            File rootDirectory = runtime.getLocation().toFile();
            Set<ArtifactBridge> artifactBridges = PDEHelper.createArtifactBridges();
            NoOpEventLogger logger = new NoOpEventLogger();
            File indexDirectory = ServerUiPlugin.getDefault().getStateLocation().append(runtime.getName()).toFile();
            indexDirectory.mkdirs();
            PropertiesRepositoryConfigurationReader reader = new PropertiesRepositoryConfigurationReader(indexDirectory, artifactBridges, (EventLogger)logger, null, rootDirectory);
            File configurationFile = PDEHelper.getRepositoryFile(runtime);
            FileInputStream inStream = null;
            try {
                try {
                    inStream = new FileInputStream(configurationFile);
                    Properties p = new Properties();
                    p.load(inStream);
                    OrderedPair pair = reader.readConfiguration(p);
                    for (RepositoryConfiguration cfg : ((Map)pair.getFirst()).values()) {
                        ExternalStorageRepositoryConfiguration e1;
                        String patt;
                        Path path;
                        String lastSegment;
                        if (cfg instanceof WatchedStorageRepositoryConfiguration) {
                            WatchedStorageRepositoryConfiguration c1 = (WatchedStorageRepositoryConfiguration)cfg;
                            locations.put(c1.getName(), c1.getDirectoryToWatch());
                            continue;
                        }
                        if (cfg instanceof ManagedStorageRepositoryConfiguration) {
                            ManagedStorageRepositoryConfiguration m1 = (ManagedStorageRepositoryConfiguration)cfg;
                            locations.put(m1.getName(), m1.getStorageLocation());
                            continue;
                        }
                        if (!(cfg instanceof ExternalStorageRepositoryConfiguration) || !STAR.equals(lastSegment = (path = new Path(patt = (e1 = (ExternalStorageRepositoryConfiguration)cfg).getSearchPattern())).lastSegment()) && !ANY_JAR.equals(lastSegment) || (path = path.removeLastSegments(1)).toOSString().contains(STAR)) continue;
                        locations.put(e1.getName(), path.toFile());
                    }
                }
                catch (Exception exception) {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return locations;
    }

    private static File getRepositoryFile(IRuntimeWorkingCopy runtime) {
        return runtime.getLocation().append(CONFIGURATION).append(CONFIG_FILENAME).toFile();
    }

    private static Set<ArtifactBridge> createArtifactBridges() {
        HashSet<ArtifactBridge> artefactBridges = new HashSet<ArtifactBridge>();
        artefactBridges.add(new ArtifactBridge(){

            public ArtifactDescriptor generateArtifactDescriptor(File arg0) throws ArtifactGenerationException {
                return new ArtifactDescriptorBuilder().setUri(arg0.toURI()).setName(arg0.getName()).build();
            }
        });
        return artefactBridges;
    }

    public static boolean existsTargetDefinition(String name) {
        ITargetHandle[] targetplatforms;
        Assert.isNotNull((Object)name, (String)"name cannot be null");
        ITargetPlatformService srv = (ITargetPlatformService)PlatformUI.getWorkbench().getService(ITargetPlatformService.class);
        ITargetHandle[] iTargetHandleArray = targetplatforms = srv.getTargets(null);
        int n = targetplatforms.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle iTargetHandle = iTargetHandleArray[n2];
            try {
                if (iTargetHandle.getTargetDefinition().getName().equals(name)) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return false;
    }

    public static void deleteTargetDefinition(String name) {
        ITargetHandle[] targetplatforms;
        Assert.isNotNull((Object)name, (String)"name cannot be null");
        ITargetPlatformService srv = (ITargetPlatformService)PlatformUI.getWorkbench().getService(ITargetPlatformService.class);
        ITargetHandle[] iTargetHandleArray = targetplatforms = srv.getTargets(null);
        int n = targetplatforms.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetHandle iTargetHandle = iTargetHandleArray[n2];
            try {
                if (iTargetHandle.getTargetDefinition().getName().equals(name)) {
                    srv.deleteTarget(iTargetHandle);
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
    }

    public static Status createTargetDefinition(IProgressMonitor monitor, IRuntimeWorkingCopy runtime, List<File> folders) {
        Assert.isNotNull((Object)runtime, (String)"runtime cannot be null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 2);
        MultiStatus st = new MultiStatus("org.eclipse.virgo.ide.runtime.ui", 1, "Error creating target platform", null);
        if (folders != null) {
            ITargetHandle[] handles;
            IServerRuntimeWorkingCopy serverRuntimeWorkingCopy = (IServerRuntimeWorkingCopy)runtime.loadAdapter(IServerRuntimeWorkingCopy.class, null);
            ITargetPlatformService srv = (ITargetPlatformService)PlatformUI.getWorkbench().getService(ITargetPlatformService.class);
            ITargetHandle[] iTargetHandleArray = handles = srv.getTargets(null);
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetHandle iTargetHandle = iTargetHandleArray[n2];
                try {
                    if (iTargetHandle.getTargetDefinition().getName().equals(runtime.getName())) {
                        srv.deleteTarget(iTargetHandle);
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
            ITargetDefinition targetplatform = srv.newTarget();
            targetplatform.setName(runtime.getName());
            IVMInstall vmInstall = serverRuntimeWorkingCopy.getVMInstall();
            if (vmInstall == null) {
                vmInstall = JavaRuntime.getDefaultVMInstall();
            }
            if (vmInstall == null) {
                return new Status(4, "org.eclipse.virgo.ide.runtime.ui", "Cannot determine JDK, please check Java JRE preferences.");
            }
            targetplatform.setJREContainer(JavaRuntime.newJREContainerPath((IVMInstall)vmInstall));
            ITargetLocation[] locations = new ITargetLocation[folders.size()];
            int i = 0;
            for (File folder : folders) {
                try {
                    locations[i++] = srv.newDirectoryLocation(folder.getCanonicalPath());
                }
                catch (IOException e) {
                    st.add((IStatus)new Status(4, "org.eclipse.virgo.ide.runtime.ui", e.getLocalizedMessage(), (Throwable)e));
                }
            }
            if (st.isOK()) {
                monitor.worked(1);
                targetplatform.setTargetLocations(locations);
                try {
                    srv.saveTargetDefinition(targetplatform);
                    LoadTargetDefinitionJob.load((ITargetDefinition)targetplatform);
                }
                catch (CoreException e1) {
                    st.add((IStatus)new Status(4, "org.eclipse.virgo.ide.runtime.ui", "Cannot save target platform definition", (Throwable)e1));
                }
            }
        }
        monitor.done();
        return st;
    }

    public static void updateRepositoryConfiguration(IRuntimeWorkingCopy runtime, List<File> newFolders) throws IOException {
        Assert.isNotNull((Object)runtime, (String)"runtime cannot be null");
        if (runtime.getLocation() != null) {
            LinkedHashMap<String, File> oldFolders = PDEHelper.getRepositoryChain(runtime);
            HashSet<File> oldFoldersSet = new HashSet<File>(oldFolders.values());
            HashSet<File> newFoldersSet = newFolders != null ? new HashSet<File>(newFolders) : new HashSet();
            newFoldersSet.remove(runtime.getLocation().append(PLUGINS).toFile());
            if (oldFoldersSet.equals(newFoldersSet)) {
                return;
            }
            LinkedHashMap<String, File> removed = new LinkedHashMap<String, File>(oldFolders);
            Iterator<Map.Entry<String, File>> eIt = removed.entrySet().iterator();
            while (eIt.hasNext()) {
                Map.Entry<String, File> e = eIt.next();
                if (!newFoldersSet.remove(e.getValue())) continue;
                eIt.remove();
            }
            Properties added = new Properties();
            int count = 0;
            IPath virgoHome = runtime.getLocation();
            for (File file : newFoldersSet) {
                Path path = new Path(file.getCanonicalPath());
                if (virgoHome.isPrefixOf((IPath)path)) {
                    path = path.removeFirstSegments(virgoHome.segmentCount());
                }
                added.put(ADDED_BY_VIRGO_TOOLS + count + REPO_TYPE, TYPE_WATCHED);
                added.put(ADDED_BY_VIRGO_TOOLS + count + WATCH_DIRECTORY, path.toString());
                ++count;
            }
            File configurationFile = PDEHelper.getRepositoryFile(runtime);
            Properties oldProperties = PDEHelper.readRepositoryProperties(configurationFile);
            Iterator<Map.Entry<Object, Object>> eIt2 = oldProperties.entrySet().iterator();
            block2: while (eIt2.hasNext()) {
                String entryKey = eIt2.next().getKey().toString();
                for (String removedRepo : removed.keySet()) {
                    if (!entryKey.startsWith(String.valueOf(removedRepo) + DOT)) continue;
                    eIt2.remove();
                    continue block2;
                }
            }
            oldProperties.putAll((Map<?, ?>)added);
            String chain = (String)oldProperties.get(CHAIN_PROPERTY);
            StringBuilder sb = new StringBuilder();
            if (chain != null) {
                String[] chainArray;
                String[] stringArray = chainArray = chain.split(COMMA);
                int n = chainArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    if (!removed.containsKey(string)) {
                        sb.append(string).append(COMMA);
                    }
                    ++n2;
                }
            }
            int i = 0;
            while (i < count) {
                sb.append(ADDED_BY_VIRGO_TOOLS + i).append(COMMA);
                ++i;
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            chain = sb.toString();
            oldProperties.put(CHAIN_PROPERTY, chain);
            PDEHelper.writeRepositoryProperties(configurationFile, oldProperties);
        }
    }

    private static void writeRepositoryProperties(File configurationFile, Properties properties) throws IOException {
        File newFile = new File(configurationFile.getCanonicalPath());
        File backupFile = new File(String.valueOf(configurationFile.getCanonicalPath()) + ".backup_" + System.currentTimeMillis());
        if (backupFile.exists()) {
            backupFile.delete();
        }
        configurationFile.renameTo(backupFile);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(newFile);
            properties.store(fos, "Edited by Virgo Tools");
            fos.flush();
        }
        catch (Throwable throwable) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static Properties readRepositoryProperties(File configurationFile) throws IOException {
        Properties properties;
        block7: {
            FileInputStream fis = null;
            Properties properties2 = new Properties();
            try {
                fis = new FileInputStream(configurationFile);
                properties2.load(fis);
                properties = properties2;
                if (fis == null) break block7;
            }
            catch (Throwable throwable) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    public static boolean refreshTargetDefinition(IProgressMonitor monitor, String name) throws CoreException {
        ITargetPlatformService srv;
        ITargetDefinition def;
        Assert.isNotNull((Object)name, (String)"name cannot be null");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (!(def = (srv = (ITargetPlatformService)PlatformUI.getWorkbench().getService(ITargetPlatformService.class)).getWorkspaceTargetDefinition()).getName().equals(name)) {
            ITargetHandle[] handles;
            def = null;
            ITargetHandle[] iTargetHandleArray = handles = srv.getTargets(null);
            int n = handles.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetHandle iTargetHandle = iTargetHandleArray[n2];
                ITargetDefinition def2 = iTargetHandle.getTargetDefinition();
                if (def2.getName().equals(name)) {
                    def = def2;
                    break;
                }
                ++n2;
            }
        }
        if (def != null) {
            srv.saveTargetDefinition(def);
            def.resolve(monitor);
            LoadTargetDefinitionJob.load((ITargetDefinition)def);
            return true;
        }
        return false;
    }
}

