/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.artifact.bundle;

import java.io.File;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.virgo.kernel.artifact.internal.BundleManifestUtils;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.HashGenerator;
import org.eclipse.virgo.repository.builder.ArtifactDescriptorBuilder;
import org.eclipse.virgo.repository.builder.AttributeBuilder;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleSymbolicName;
import org.eclipse.virgo.util.osgi.manifest.ExportedPackage;
import org.eclipse.virgo.util.osgi.manifest.FragmentHost;
import org.eclipse.virgo.util.osgi.manifest.ImportedPackage;
import org.osgi.framework.Version;

public final class BundleBridge
implements ArtifactBridge {
    private static final String JAR_SUFFIX = ".jar";
    private static final String WAR_SUFFIX = ".war";
    public static final String RAW_HEADER_PREFIX = "RAW_HEADER:";
    public static final String BRIDGE_TYPE = "bundle";
    private final HashGenerator hashGenerator;

    public BundleBridge(HashGenerator hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public ArtifactDescriptor generateArtifactDescriptor(File artifactFile) throws ArtifactGenerationException {
        BundleManifest bundleManifest;
        if (artifactFile == null) {
            throw new ArtifactGenerationException("The artifact file must not be null.", BRIDGE_TYPE);
        }
        try {
            bundleManifest = BundleManifestUtils.readBundleManifest(artifactFile, JAR_SUFFIX, WAR_SUFFIX);
        }
        catch (RuntimeException re) {
            throw new RuntimeException(String.format("Error occurred while parsing the manifest of file '%s'.", artifactFile.getPath()), re);
        }
        catch (Exception e) {
            throw new ArtifactGenerationException("Error occurred while parsing the manifest.", BRIDGE_TYPE, (Throwable)e);
        }
        ArtifactDescriptor descriptor = null;
        if (bundleManifest != null) {
            descriptor = this.createArtifactDescriptorFromManifest(artifactFile, bundleManifest);
        }
        if (descriptor == null) {
            descriptor = this.createArtifactDescriptorFromFile(artifactFile);
        }
        return descriptor;
    }

    private ArtifactDescriptor createArtifactDescriptorFromFile(File artifactFile) {
        String fileName = artifactFile.getName();
        if (fileName.endsWith(JAR_SUFFIX) || fileName.endsWith(WAR_SUFFIX)) {
            String name = fileName.substring(0, fileName.length() - JAR_SUFFIX.length());
            ArtifactDescriptorBuilder artifactDescriptorBuilder = new ArtifactDescriptorBuilder();
            artifactDescriptorBuilder.setUri(artifactFile.toURI());
            artifactDescriptorBuilder.setName(name);
            artifactDescriptorBuilder.setType(BRIDGE_TYPE);
            artifactDescriptorBuilder.setVersion(Version.emptyVersion);
            this.hashGenerator.generateHash(artifactDescriptorBuilder, artifactFile);
            return artifactDescriptorBuilder.build();
        }
        return null;
    }

    private ArtifactDescriptor createArtifactDescriptorFromManifest(File artifactFile, BundleManifest bundleManifest) throws ArtifactGenerationException {
        String name;
        ArtifactDescriptorBuilder artifactDescriptorBuilder;
        block4: {
            artifactDescriptorBuilder = new ArtifactDescriptorBuilder();
            name = this.applyBundleSymbolicName(artifactDescriptorBuilder, bundleManifest);
            if (name != null) break block4;
            return null;
        }
        try {
            artifactDescriptorBuilder.setUri(artifactFile.toURI());
            artifactDescriptorBuilder.setName(name);
            artifactDescriptorBuilder.setType(BRIDGE_TYPE);
            artifactDescriptorBuilder.setVersion(this.applyBundleVersion(artifactDescriptorBuilder, bundleManifest));
            this.applyImportPackage(artifactDescriptorBuilder, bundleManifest);
            this.applyFragmentHost(artifactDescriptorBuilder, bundleManifest);
            this.applyExportPackage(artifactDescriptorBuilder, bundleManifest);
            this.hashGenerator.generateHash(artifactDescriptorBuilder, artifactFile);
            Dictionary rawManifest = bundleManifest.toDictionary();
            Enumeration keys = rawManifest.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)rawManifest.get(key);
                artifactDescriptorBuilder.addAttribute(new AttributeBuilder().setName(RAW_HEADER_PREFIX + key).setValue(value).build());
            }
            return artifactDescriptorBuilder.build();
        }
        catch (Exception e) {
            throw new ArtifactGenerationException("Manifest ill-formed.", BRIDGE_TYPE, (Throwable)e);
        }
    }

    public static Dictionary<String, String> convertToDictionary(ArtifactDescriptor artifactDescriptor) {
        if (!BRIDGE_TYPE.equals(artifactDescriptor.getType())) {
            return null;
        }
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        for (Attribute attribute : artifactDescriptor.getAttributes()) {
            if (!attribute.getKey().startsWith(RAW_HEADER_PREFIX)) continue;
            dictionary.put(attribute.getKey().substring(RAW_HEADER_PREFIX.length()), attribute.getValue());
        }
        return dictionary;
    }

    private String applyBundleSymbolicName(ArtifactDescriptorBuilder artifactBuilder, BundleManifest bundleManifest) {
        BundleSymbolicName bundleSymbolicName = bundleManifest.getBundleSymbolicName();
        String symbolicName = bundleSymbolicName.getSymbolicName();
        if (symbolicName != null) {
            AttributeBuilder attributeBuilder = new AttributeBuilder();
            attributeBuilder.setName("Bundle-SymbolicName");
            attributeBuilder.setValue(symbolicName);
            attributeBuilder.putProperties("fragment-attachment", new String[]{bundleSymbolicName.getFragmentAttachment().name()});
            attributeBuilder.putProperties("singleton", new String[]{Boolean.toString(bundleSymbolicName.isSingleton())});
            artifactBuilder.addAttribute(attributeBuilder.build());
        }
        return symbolicName;
    }

    private Version applyBundleVersion(ArtifactDescriptorBuilder artifactBuilder, BundleManifest bundleManifest) {
        Version version = bundleManifest.getBundleVersion();
        artifactBuilder.addAttribute(new AttributeBuilder().setName("Bundle-Version").setValue(version.toString()).build());
        return version;
    }

    private void applyImportPackage(ArtifactDescriptorBuilder artifactBuilder, BundleManifest bundleManifest) {
        for (ImportedPackage importedPackage : bundleManifest.getImportPackage().getImportedPackages()) {
            AttributeBuilder attributeBuilder = new AttributeBuilder();
            attributeBuilder.setName("Import-Package");
            attributeBuilder.setValue(importedPackage.getPackageName());
            attributeBuilder.putProperties("resolution", new String[]{importedPackage.getResolution().name()});
            attributeBuilder.putProperties("version", new String[]{importedPackage.getVersion().toParseString()});
            artifactBuilder.addAttribute(attributeBuilder.build());
        }
    }

    private void applyFragmentHost(ArtifactDescriptorBuilder artifactBuilder, BundleManifest bundleManifest) {
        FragmentHost fragmentHost = bundleManifest.getFragmentHost();
        String hostSymbolicName = fragmentHost.getBundleSymbolicName();
        if (hostSymbolicName != null) {
            AttributeBuilder attributeBuilder = new AttributeBuilder();
            attributeBuilder.setName("Fragment-Host");
            attributeBuilder.setValue(hostSymbolicName);
            FragmentHost.Extension extension = fragmentHost.getExtension();
            if (extension != null) {
                attributeBuilder.putProperties("extension", new String[]{extension.name()});
            }
            attributeBuilder.putProperties("bundle-version", new String[]{fragmentHost.getBundleVersion().toParseString()});
            artifactBuilder.addAttribute(attributeBuilder.build());
        }
    }

    private void applyExportPackage(ArtifactDescriptorBuilder artifactBuilder, BundleManifest bundleManifest) {
        for (ExportedPackage exportedPackage : bundleManifest.getExportPackage().getExportedPackages()) {
            List uses;
            List mandatory;
            List exclude;
            AttributeBuilder attributeBuilder = new AttributeBuilder();
            attributeBuilder.setName("Export-Package");
            attributeBuilder.setValue(exportedPackage.getPackageName());
            attributeBuilder.putProperties("version", new String[]{exportedPackage.getVersion().toString()});
            List include = exportedPackage.getInclude();
            if (include.size() > 0) {
                attributeBuilder.putProperties("include", include);
            }
            if ((exclude = exportedPackage.getExclude()).size() > 0) {
                attributeBuilder.putProperties("exclude", exclude);
            }
            if ((mandatory = exportedPackage.getMandatory()).size() > 0) {
                attributeBuilder.putProperties("mandatory", mandatory);
            }
            if ((uses = exportedPackage.getUses()).size() > 0) {
                attributeBuilder.putProperties("uses", uses);
            }
            artifactBuilder.addAttribute(attributeBuilder.build());
        }
    }
}

