/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.RepositoryAwareArtifactDescriptor;
import org.eclipse.virgo.repository.internal.RepositoryUtils;
import org.eclipse.virgo.util.osgi.manifest.VersionRange;

public interface Query {
    public Query addFilter(String var1, String var2);

    public Query addFilter(String var1, String var2, Map<String, Set<String>> var3);

    public Query setVersionRangeFilter(VersionRange var1);

    public Query setVersionRangeFilter(VersionRange var1, VersionRangeMatchingStrategy var2);

    public Set<RepositoryAwareArtifactDescriptor> run();

    public static abstract class VersionRangeMatchingStrategy
    extends Enum<VersionRangeMatchingStrategy> {
        public static final /* enum */ VersionRangeMatchingStrategy ALL;
        public static final /* enum */ VersionRangeMatchingStrategy HIGHEST;
        public static final /* enum */ VersionRangeMatchingStrategy LOWEST;
        private static final /* synthetic */ VersionRangeMatchingStrategy[] ENUM$VALUES;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

        static {
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.Query$VersionRangeMatchingStrategy");
            ALL = new VersionRangeMatchingStrategy(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

                @Override
                public <T extends ArtifactDescriptor> Set<T> match(Set<T> unfiltered, VersionRange versionRange) {
                    return unfiltered;
                }

                public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                    return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                }

                static {
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.Query$VersionRangeMatchingStrategy$1");
                }
            };
            HIGHEST = new VersionRangeMatchingStrategy(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

                @Override
                public <T extends ArtifactDescriptor> Set<T> match(Set<T> unfiltered, VersionRange versionRange) {
                    HashSet<T> result = new HashSet<T>();
                    Set<Set<T>> grouped = RepositoryUtils.groupByTypeAndName(unfiltered);
                    for (Set<T> group : grouped) {
                        result.add(RepositoryUtils.selectHighestVersionInRange(group, versionRange));
                    }
                    return result;
                }

                public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                    return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                }

                static {
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.Query$VersionRangeMatchingStrategy$2");
                }
            };
            LOWEST = new VersionRangeMatchingStrategy(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

                @Override
                public <T extends ArtifactDescriptor> Set<T> match(Set<T> unfiltered, VersionRange versionRange) {
                    HashSet<T> result = new HashSet<T>();
                    Set<Set<T>> grouped = RepositoryUtils.groupByTypeAndName(unfiltered);
                    for (Set<T> group : grouped) {
                        result.add(RepositoryUtils.selectLowestVersionInRange(group, versionRange));
                    }
                    return result;
                }

                public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
                    return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                }

                static {
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.Query$VersionRangeMatchingStrategy$3");
                }
            };
            ENUM$VALUES = new VersionRangeMatchingStrategy[]{ALL, HIGHEST, LOWEST};
        }

        public abstract <T extends ArtifactDescriptor> Set<T> match(Set<T> var1, VersionRange var2);

        public static VersionRangeMatchingStrategy[] values() {
            VersionRangeMatchingStrategy[] versionRangeMatchingStrategyArray = ENUM$VALUES;
            int n = versionRangeMatchingStrategyArray.length;
            VersionRangeMatchingStrategy[] versionRangeMatchingStrategyArray2 = new VersionRangeMatchingStrategy[n];
            System.arraycopy(ENUM$VALUES, 0, versionRangeMatchingStrategyArray2, 0, n);
            return versionRangeMatchingStrategyArray2;
        }

        public static VersionRangeMatchingStrategy valueOf(String string) {
            return Enum.valueOf(VersionRangeMatchingStrategy.class, string);
        }

        public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
            return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        }
    }
}

