/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal.cacheing.cache.descriptorhash;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.Attribute;
import org.eclipse.virgo.repository.internal.cacheing.cache.descriptorhash.ArtifactDescriptorHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StandardArtifactDescriptorHash
implements ArtifactDescriptorHash {
    private static final String DEFAULT_DIGEST_ALGORITHM = "sha";
    private static final String HASH_ATTRIBUTE_NAME = "hash";
    private static final String HASH_ALGORITHM_ATTRIBUTE_NAME = "hash-algorithm";
    private static final Logger LOGGER;
    private final boolean hasHash;
    private final String hash;
    private final String digestAlgorithm;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;

    static {
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.repository.internal.cacheing.cache.descriptorhash.StandardArtifactDescriptorHash");
        LOGGER = LoggerFactory.getLogger(StandardArtifactDescriptorHash.class);
    }

    StandardArtifactDescriptorHash(ArtifactDescriptor artifactDescriptor) {
        this.hash = this.getAttribute(artifactDescriptor, HASH_ATTRIBUTE_NAME, null);
        this.hasHash = this.isReasonableHash(this.hash);
        this.digestAlgorithm = this.getAttribute(artifactDescriptor, HASH_ALGORITHM_ATTRIBUTE_NAME, DEFAULT_DIGEST_ALGORITHM);
    }

    private String getAttribute(ArtifactDescriptor artifactDescriptor, String attributeName, String defaultAttributeValue) {
        String attributeValue = defaultAttributeValue;
        Set<Attribute> attributeSet = this.getAttributeSet(artifactDescriptor, attributeName);
        if (!attributeSet.isEmpty()) {
            Attribute algorithmAttribute;
            String key;
            if (attributeSet.size() > 1) {
                LOGGER.warn("Attribute with name " + attributeName + " has multiple values - using first and ignoring others");
            }
            if (attributeName.equals(key = (algorithmAttribute = attributeSet.iterator().next()).getKey())) {
                attributeValue = algorithmAttribute.getValue();
            } else {
                LOGGER.warn("Attribute found using name " + attributeName + " has unexpected key '" + key + "'");
            }
        }
        return attributeValue;
    }

    private Set<Attribute> getAttributeSet(ArtifactDescriptor artifactDescriptor, String attributeName) {
        Set<Attribute> hashAttributeSet = artifactDescriptor.getAttribute(attributeName);
        if (hashAttributeSet == null) {
            hashAttributeSet = new HashSet<Attribute>();
        }
        return hashAttributeSet;
    }

    private boolean isReasonableHash(String hashValue) {
        boolean reasonable;
        boolean bl = reasonable = hashValue != null && !hashValue.isEmpty();
        if (!reasonable) {
            LOGGER.warn("Hash value {} is unreasonable", (Object)hashValue);
        }
        return reasonable;
    }

    @Override
    public boolean isPresent() {
        return this.hasHash;
    }

    @Override
    public boolean matches(String hashToMatch) {
        return this.isPresent() ? this.hash.equals(hashToMatch) : false;
    }

    @Override
    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public static /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$localAspectOf() {
        return ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    }
}

