/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResolutionUtil {
    private final WebBeansContext webBeansContext;

    public ResolutionUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public static boolean checkBeanTypeAssignableToGivenType(Set<Type> beanTypes, Type givenType, boolean newBean) {
        for (Type beanApiType : beanTypes) {
            Class<?> requiredType;
            if (ClassUtil.isAssignable(beanApiType, givenType)) {
                return true;
            }
            if (!newBean || !ClassUtil.isParametrizedType(givenType) || !ClassUtil.isClassAssignable(requiredType = ClassUtil.getClass(givenType), ClassUtil.getClass(beanApiType))) continue;
            return true;
        }
        return false;
    }

    public void checkResolvedBeans(Set<Bean<?>> resolvedSet, Class<?> type, Annotation[] qualifiers, InjectionPoint injectionPoint) {
        if (resolvedSet.isEmpty()) {
            InjectionExceptionUtils.throwUnsatisfiedResolutionException(type, injectionPoint, qualifiers);
        }
        if (resolvedSet.size() > 1) {
            InjectionExceptionUtils.throwAmbiguousResolutionException(resolvedSet, type, injectionPoint, qualifiers);
        }
        Bean<?> bean = resolvedSet.iterator().next();
        this.webBeansContext.getWebBeansUtil().checkUnproxiableApiType(bean, bean.getScope());
    }
}

