/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.openejb.initialiser;

import java.io.File;
import java.util.Properties;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.Assembler;
import org.eclipse.virgo.web.enterprise.openejb.initialiser.VirgoOpenEjbAssembler;
import org.eclipse.virgo.web.enterprise.openejb.initialiser.VirgoThreadContextListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private Assembler assembler = null;
    private ThreadContextListener virgoThreadContextListener = new VirgoThreadContextListener();

    public void start(BundleContext bundleContext) throws Exception {
        this.setDefaultProperty("openejb.deploymentId.format", "{appId}/{ejbName}");
        this.setDefaultProperty("openejb.jndiname.strategy.class", "org.apache.openejb.assembler.classic.JndiBuilder$TemplatedStrategy");
        this.setDefaultProperty("openejb.jndiname.format", "{ejbName}{interfaceType.annotationName}");
        this.setDefaultProperty("openejb.jndiname.failoncollision", "false");
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Assembler.class.getClassLoader());
            this.assembler = new VirgoOpenEjbAssembler();
            Properties env = new Properties();
            env.put("openejb.conf.file", String.valueOf(System.getProperty("org.eclipse.virgo.kernel.config")) + File.separator + "openejb.xml");
            this.assembler.init(env);
            this.assembler.build();
            ThreadContext.addThreadContextListener((ThreadContextListener)this.virgoThreadContextListener);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        ThreadContext.removeThreadContextListener((ThreadContextListener)this.virgoThreadContextListener);
        if (this.assembler != null) {
            this.assembler.destroy();
        }
    }

    private void setDefaultProperty(String key, String value) {
        SystemInstance systemInstance = SystemInstance.get();
        String format = systemInstance.getProperty(key);
        if (format == null) {
            systemInstance.setProperty(key, value);
        }
    }
}

