/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.tomcat.util.compat.JreCompat;

class Jre8Compat
extends JreCompat {
    private static final Method setUseCipherSuitesOrderMethod;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLEngine engine, boolean useCipherSuitesOrder) {
        SSLParameters sslParameters = engine.getSSLParameters();
        try {
            setUseCipherSuitesOrderMethod.invoke((Object)sslParameters, useCipherSuitesOrder);
            engine.setSSLParameters(sslParameters);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    static {
        Method m1 = null;
        try {
            Class<?> c1 = Class.forName("javax.net.ssl.SSLParameters");
            m1 = c1.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        setUseCipherSuitesOrderMethod = m1;
    }
}

