/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.enterprise.services.accessor;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.JarFactory;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderJarScanner
implements JarScanner {
    private static final String JAR_URL_SUFFIX = "!/";
    private static final String JAR_URL_PREFIX = "jar:";
    private static final String REFERENCE_URL_PREFIX = "reference";
    public static final String SKIP_BUNDLES_PROPERTY = "gemini.web.scan.BundleDependenciesJarScanned.bundlesToSkip";
    private final Set<Bundle> bundles = new HashSet<Bundle>();
    private Logger logger = LoggerFactory.getLogger(ClassLoaderJarScanner.class);
    private JarScanFilter jarScanFilter;

    public ClassLoaderJarScanner(Set<Bundle> bundles) {
        this.bundles.addAll(bundles);
        this.jarScanFilter = new JarScanFilter(){

            public boolean check(JarScanType jarScanType, String bundleSymbolicName) {
                return true;
            }
        };
    }

    public JarScanFilter getJarScanFilter() {
        return this.jarScanFilter;
    }

    public void setJarScanFilter(JarScanFilter jarScanFilter) {
        this.jarScanFilter = jarScanFilter;
    }

    public void scan(JarScanType jarScanType, ServletContext context, JarScannerCallback callback) {
        for (Bundle bundle : this.bundles) {
            this.scanBundle(bundle, callback);
        }
    }

    private void scanBundle(Bundle bundle, JarScannerCallback callback) {
        File bundleFile = this.resolve(bundle);
        if (bundleFile != null) {
            this.scanBundleFile(bundleFile, callback);
        } else {
            this.scanJarUrlConnection(bundle, callback);
        }
    }

    private void scanJarUrlConnection(Bundle bundle, JarScannerCallback callback) {
        URL bundleUrl;
        String bundleLocation = bundle.getLocation();
        try {
            bundleUrl = new URL(bundleLocation);
            bundleUrl = REFERENCE_URL_PREFIX.equals(bundleUrl.getProtocol()) ? new URL(JAR_URL_PREFIX + this.transformBundleLocation(bundleUrl.getFile()) + JAR_URL_SUFFIX) : new URL(JAR_URL_PREFIX + this.transformBundleLocation(bundleLocation) + JAR_URL_SUFFIX);
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.logger.warn("Failed to create jar: url for bundle location " + bundleLocation, (Throwable)e);
            return;
        }
        this.scanBundleUrl(bundleUrl, callback);
    }

    private String transformBundleLocation(String location) throws URISyntaxException {
        URI url = new URI(location);
        if (!url.isOpaque()) {
            return location;
        }
        String scheme = url.getScheme();
        return String.valueOf(scheme) + ":/" + location.substring(scheme.length() + 1);
    }

    private void scanBundleFile(File bundleFile, JarScannerCallback callback) {
        if (bundleFile.isDirectory()) {
            try {
                callback.scan(bundleFile, null, true);
            }
            catch (IOException e) {
                this.logger.warn("Failure when attempting to scan bundle file '" + bundleFile + "':" + e.getMessage(), (Throwable)e);
            }
        } else {
            URL bundleUrl;
            try {
                bundleUrl = new URL(JAR_URL_PREFIX + bundleFile.toURI().toURL() + JAR_URL_SUFFIX);
            }
            catch (MalformedURLException e) {
                this.logger.warn("Failed to create jar: url for bundle file " + bundleFile, (Throwable)e);
                return;
            }
            this.scanBundleUrl(bundleUrl, callback);
        }
    }

    private void scanBundleUrl(URL url, JarScannerCallback callback) {
        if ("jar".equals(url.getProtocol()) || url.getPath().endsWith(".jar")) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (Jar jar = JarFactory.newInstance((URL)url);){
                    callback.scan(jar, null, true);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.logger.warn("Failure when attempting to scan bundle via jar URL [" + url + "].", (Throwable)e);
            }
        }
    }

    private File resolve(Bundle bundle) {
        BundleFile bundleFile = this.getBundleFile(bundle);
        if (bundleFile != null) {
            File file = bundleFile.getBaseFile();
            this.logger.info("Resolved bundle '" + bundle.getSymbolicName() + "' to file '" + file.getAbsolutePath() + "'");
            return file;
        }
        return null;
    }

    private BundleFile getBundleFile(Bundle bundle) {
        BundleHost bh;
        BundleData bundleData;
        if (bundle instanceof BundleHost && (bundleData = (bh = (BundleHost)bundle).getBundleData()) instanceof BaseData) {
            return ((BaseData)bundleData).getBundleFile();
        }
        return null;
    }
}

