# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

import os
from typing import Optional

from PySide6.QtCore import QUrl
from PySide6.QtGui import QIcon
from PySide6.QtWidgets import (QDialog, QDialogButtonBox, QTextBrowser,
                               QVBoxLayout, QWidget)


class HelpWindow(QDialog):

    def __init__(self, parent: Optional[QWidget]):
        super(HelpWindow, self).__init__(parent)
        self.setWindowIcon(QIcon(':/qt-project.org/logos/pysidelogo.png'))
        self.setWindowTitle('Help')
        self._browser = QTextBrowser()
        self._browser.setOpenExternalLinks(True)
        self._browser.setOpenLinks(True)
        help_file = os.path.join(os.path.dirname(__file__), 'help.html')
        self._browser.setSource(QUrl.fromLocalFile(os.path.abspath(help_file)))
        self._dialogButtonBox = QDialogButtonBox(QDialogButtonBox.Close)
        self._dialogButtonBox.rejected.connect(self.reject)
        main_layout = QVBoxLayout(self)
        main_layout.addWidget(self._browser)
        main_layout.addWidget(self._dialogButtonBox)
        screen_size = self.screen().size()
        self.resize(screen_size.width() * 2 / 3, screen_size.height() * 4 / 5)
