/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.remote.ui.messages.RemoteMessages;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceFilesElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConflictHandler;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceCoreUtils;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;

public class RemoteImportTracesOperation
extends TmfWorkspaceModifyOperation {
    private static final int BUFFER_IN_KB = 16;
    private static final int BYTES_PER_KB = 1024;
    private IStatus fStatus;
    private final Shell fShell;
    private final TmfTraceFolder fDestination;
    private final Object[] fTraceElements;
    private final ImportConflictHandler fConflictHandler;

    public RemoteImportTracesOperation(Shell shell, TmfTraceFolder destination, Object[] elements, boolean overwriteAll) {
        this.fShell = shell;
        this.fDestination = destination;
        this.fTraceElements = Arrays.copyOf(elements, elements.length);
        this.fConflictHandler = overwriteAll ? new ImportConflictHandler(this.fShell, destination, ImportConfirmation.OVERWRITE_ALL) : new ImportConflictHandler(this.fShell, destination, ImportConfirmation.SKIP);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            this.doRun(monitor);
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
            throw e;
        }
        catch (Exception e) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", RemoteMessages.RemoteImportTracesOperation_ImportFailure, (Throwable)e));
            throw new InvocationTargetException(e);
        }
    }

    private void doRun(IProgressMonitor monitor) throws ExecutionException, CoreException, IOException, InterruptedException {
        IFolder destinationFolder = this.fDestination.getResource();
        if (!destinationFolder.exists()) {
            throw new ExecutionException(String.valueOf(RemoteMessages.RemoteImportTracesOperation_ImportDialogInvalidTracingProject) + " (" + "Traces" + ")");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.fTraceElements.length * 4));
        subMonitor.beginTask(RemoteMessages.RemoteImportTracesOperation_DownloadTask, this.fTraceElements.length * 4);
        Object[] objectArray = this.fTraceElements;
        int n = this.fTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object packageElement = objectArray[n2];
            if (packageElement instanceof TracePackageTraceElement) {
                TracePackageTraceElement traceElement = (TracePackageTraceElement)packageElement;
                TracePackageElement parentElement = traceElement.getParent();
                while (parentElement != null) {
                    if (parentElement instanceof RemoteImportTraceGroupElement) break;
                    parentElement = parentElement.getParent();
                }
                if (parentElement != null) {
                    RemoteImportTraceGroupElement traceGroup = (RemoteImportTraceGroupElement)parentElement;
                    String rootPath = traceGroup.getRootImportPath();
                    RemoteImportConnectionNodeElement nodeElement = (RemoteImportConnectionNodeElement)traceGroup.getParent();
                    String nodeName = nodeElement.getName();
                    IFolder nodeFolder = destinationFolder.getFolder(nodeName);
                    TracePackageElement[] children = traceElement.getChildren();
                    SubMonitor childMonitor = subMonitor.newChild(1);
                    TraceUtils.createFolder((IFolder)nodeFolder, (IProgressMonitor)childMonitor);
                    TracePackageElement[] tracePackageElementArray = children;
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TracePackageElement element = tracePackageElementArray[n4];
                        ModalContext.checkCanceled((IProgressMonitor)monitor);
                        if (element instanceof RemoteImportTraceFilesElement) {
                            RemoteImportTraceFilesElement traceFilesElement = (RemoteImportTraceFilesElement)element;
                            IFileStore remoteFile = traceFilesElement.getRemoteFile();
                            IPath sessionParentPath = TmfTraceCoreUtils.newSafePath((String)rootPath).removeLastSegments(1);
                            Path traceParentPath = TmfTraceCoreUtils.newSafePath((String)remoteFile.getParent().toURI().getPath());
                            Object relativeTracePath = Path.EMPTY;
                            if (sessionParentPath.isPrefixOf((IPath)traceParentPath)) {
                                relativeTracePath = traceParentPath.makeRelativeTo(sessionParentPath);
                            }
                            String[] segments = relativeTracePath.segments();
                            int i = 0;
                            while (i < segments.length) {
                                String segment = TmfTraceCoreUtils.validateName((String)TmfTraceCoreUtils.safePathToString((String)segments[i]));
                                relativeTracePath = i == 0 ? new Path(segment) : relativeTracePath.append(segment);
                                ++i;
                            }
                            IFolder traceFolder = nodeFolder.getFolder((IPath)new Path(relativeTracePath.toOSString()));
                            childMonitor = subMonitor.newChild(1);
                            TraceUtils.createFolder((IFolder)traceFolder, (IProgressMonitor)childMonitor);
                            childMonitor.done();
                            IResource traceRes = null;
                            IFileInfo info = remoteFile.fetchInfo();
                            traceRes = info.isDirectory() ? this.downloadDirectoryTrace(remoteFile, traceFolder, (IProgressMonitor)subMonitor.newChild(1)) : this.downloadFileTrace(remoteFile, traceFolder, (IProgressMonitor)subMonitor.newChild(1));
                            String traceName = traceElement.getText();
                            if (traceRes != null && traceRes.exists()) {
                                TraceTypeHelper traceTypeHelper = null;
                                String traceTypeStr = traceElement.getTraceType();
                                if (traceTypeStr != null) {
                                    traceTypeHelper = TmfTraceType.getTraceType((String)traceTypeStr);
                                }
                                if (traceTypeHelper == null) {
                                    try {
                                        childMonitor = subMonitor.newChild(1);
                                        childMonitor.setTaskName(NLS.bind((String)RemoteMessages.RemoteImportTracesOperation_DetectingTraceType, (Object)traceName));
                                        childMonitor.done();
                                        traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType((String)traceRes.getLocation().toOSString(), null, null);
                                    }
                                    catch (TmfTraceImportException tmfTraceImportException) {
                                        // empty catch block
                                    }
                                }
                                if (traceTypeHelper != null) {
                                    TmfTraceTypeUIUtils.setTraceType((IResource)traceRes, (TraceTypeHelper)traceTypeHelper);
                                }
                                URI uri = remoteFile.toURI();
                                String sourceLocation = URIUtil.toUnencodedString((URI)uri);
                                traceRes.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private IResource downloadDirectoryTrace(IFileStore trace, IFolder traceFolder, IProgressMonitor monitor) throws CoreException, IOException, InterruptedException {
        IFileStore[] sources = trace.childStores(0, monitor);
        if (sources.length > 1) {
            String traceName = trace.getName();
            IFolder folder = traceFolder.getFolder(traceName = TmfTraceCoreUtils.validateName((String)traceName));
            String newName = this.fConflictHandler.checkAndHandleNameClash(folder.getFullPath(), monitor);
            if (newName == null) {
                return null;
            }
            folder = traceFolder.getFolder(newName);
            folder.create(true, true, null);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)sources.length);
            subMonitor.beginTask(RemoteMessages.RemoteImportTracesOperation_DownloadTask, sources.length);
            IFileStore[] iFileStoreArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore source = iFileStoreArray[n2];
                if (subMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IPath destination = folder.getLocation().addTrailingSeparator().append(source.getName());
                IFileInfo info = source.fetchInfo();
                if (!info.isDirectory()) {
                    SubMonitor childMonitor = subMonitor.newChild(1);
                    childMonitor.setTaskName(String.valueOf(RemoteMessages.RemoteImportTracesOperation_DownloadTask) + ' ' + trace.getName() + '/' + source.getName());
                    Throwable throwable = null;
                    Object var17_18 = null;
                    try (InputStream in = source.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());){
                        RemoteImportTracesOperation.copy(in, destination, childMonitor, info.getLength());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ++n2;
            }
            folder.refreshLocal(2, null);
            return folder;
        }
        return null;
    }

    private IResource downloadFileTrace(IFileStore trace, IFolder traceFolder, IProgressMonitor monitor) throws CoreException, IOException, InterruptedException {
        IFolder folder = traceFolder;
        String traceName = trace.getName();
        IResource resource = folder.findMember(traceName = TmfTraceCoreUtils.validateName((String)traceName));
        if (resource != null && resource.exists()) {
            String newName = this.fConflictHandler.checkAndHandleNameClash(resource.getFullPath(), monitor);
            if (newName == null) {
                return null;
            }
            traceName = newName;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.beginTask(RemoteMessages.RemoteImportTracesOperation_DownloadTask, 1);
        IPath destination = folder.getLocation().addTrailingSeparator().append(traceName);
        IFileInfo info = trace.fetchInfo();
        subMonitor.setTaskName(String.valueOf(RemoteMessages.RemoteImportTracesOperation_DownloadTask) + ' ' + trace.getName() + '/' + trace.getName());
        Throwable throwable = null;
        Object var11_12 = null;
        try (InputStream in = trace.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());){
            RemoteImportTracesOperation.copy(in, destination, subMonitor, info.getLength());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        folder.refreshLocal(2, null);
        return folder.findMember(traceName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copy(InputStream in, IPath destination, SubMonitor monitor, long length) throws IOException {
        Throwable throwable = null;
        Object var6_6 = null;
        try {
            FileOutputStream out = new FileOutputStream(destination.toFile());
            try {
                monitor.setWorkRemaining((int)(length / 1024L));
                byte[] buf = new byte[16384];
                int counter = 0;
                while (true) {
                    int n;
                    if ((n = in.read(buf)) <= 0) {
                        return;
                    }
                    ((OutputStream)out).write(buf, 0, n);
                    counter = counter % 1024 + n;
                    monitor.worked(counter / 1024);
                }
            }
            finally {
                if (out == null) return;
                ((OutputStream)out).close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    protected void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }
}

