/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.io.File;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.utils.cdtvariables.SupplierBasedCdtVariableSubstitutor;
import org.eclipse.core.runtime.IPath;

class PathInfo {
    private String fUnresolvedStr;
    private IPath fResolvedPath;
    private boolean fIsWorkspacePath;
    private String fAbsoluteInfoStr;
    private Boolean fIsAbsolute;
    private SupplierBasedCdtVariableSubstitutor fSubstitutor;
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';

    public PathInfo(String str, boolean isWspPath, SupplierBasedCdtVariableSubstitutor subst) {
        this.fUnresolvedStr = str;
        this.fIsWorkspacePath = isWspPath;
        this.fSubstitutor = subst;
    }

    public String getUnresolvedPath() {
        return this.fUnresolvedStr;
    }

    public boolean isWorkspacePath() {
        return this.fIsWorkspacePath;
    }

    public boolean isAbsolute() {
        if (this.fIsAbsolute == null) {
            this.fIsAbsolute = this.checkIsAbsolute();
        }
        return this.fIsAbsolute;
    }

    private boolean checkIsAbsolute() {
        if (this.fResolvedPath != null) {
            return this.fResolvedPath.isAbsolute();
        }
        if (this.fAbsoluteInfoStr != null) {
            return PathInfo.isAbsolute(this.fAbsoluteInfoStr, this.fSubstitutor, new String[1]);
        }
        String[] str = new String[1];
        boolean isAbs = PathInfo.isAbsolute(this.fUnresolvedStr, this.fSubstitutor, str);
        this.fAbsoluteInfoStr = str[0];
        return isAbs;
    }

    private static boolean isAbsolute(String str, SupplierBasedCdtVariableSubstitutor subst, String[] out) {
        String macroName;
        int indx;
        int length = str.length();
        out[0] = str;
        if (length == 0) {
            return false;
        }
        char c0 = str.charAt(0);
        if (c0 == '/' || c0 == '\\') {
            return true;
        }
        if (length == 1) {
            return false;
        }
        char c1 = str.charAt(1);
        if (IS_WINDOWS && c1 == ':') {
            return true;
        }
        if (length < 4) {
            return false;
        }
        if (c0 == '$' && c1 == '{' && (indx = str.indexOf(125)) != -1 && (macroName = str.substring(2, indx)).length() != 0) {
            String resolvedMacro;
            try {
                resolvedMacro = subst.resolveToString(macroName);
            }
            catch (CdtVariableException e) {
                ManagedBuilderCorePlugin.log(e);
                resolvedMacro = null;
                e.printStackTrace();
            }
            String substr = str.substring(indx + 1);
            String rStr = resolvedMacro == null || resolvedMacro.length() == 0 ? substr : new StringBuffer().append(resolvedMacro).append(subst).toString();
            return PathInfo.isAbsolute(rStr, subst, out);
        }
        return false;
    }

    public SupplierBasedCdtVariableSubstitutor getSubstitutor() {
        return this.fSubstitutor;
    }
}

