/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.launching;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.internal.launch.remote.Activator;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RSEHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;

public class RemoteGdbLaunchDelegate
extends GdbLaunchDelegate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!RSECorePlugin.isInitComplete((int)1)) {
            monitor.subTask(Messages.RemoteRunLaunchDelegate_10);
            try {
                RSECorePlugin.waitForInitCompletion((int)1);
            }
            catch (InterruptedException e) {
                throw new CoreException((IStatus)new Status(4, this.getPluginID(), 0, e.getLocalizedMessage(), (Throwable)e));
            }
        }
        IPath exePath = this.checkBinaryDetails(config);
        Object remoteShellProcess = null;
        if (exePath == null) return;
        String remoteExePath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, "");
        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_2);
        RSEHelper.remoteFileDownload(config, launch, exePath.toString(), remoteExePath, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
        String gdbserverPortNumber = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_PORT, "2345");
        String gdbserverCommand = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
        String commandArguments = ":" + gdbserverPortNumber + " " + RSEHelper.spaceEscapify(remoteExePath);
        String arguments = this.getProgramArguments(config);
        String prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
        if (arguments != null && !arguments.equals("")) {
            commandArguments = String.valueOf(commandArguments) + " " + arguments;
        }
        monitor.setTaskName(Messages.RemoteRunLaunchDelegate_9);
        final GdbLaunch l = (GdbLaunch)launch;
        IHostShell remoteShell = null;
        try {
            remoteShell = RSEHelper.execCmdInRemoteShell(config, prelaunchCmd, gdbserverCommand, commandArguments, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        }
        catch (Exception e1) {
            RSEHelper.abort(e1.getMessage(), e1, 150);
        }
        final boolean[] gdbServerReady = new boolean[]{false};
        final Object lock = new Object();
        if (remoteShell != null) {
            remoteShell.addOutputListener(new IHostShellOutputListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void shellOutputChanged(IHostShellChangeEvent event) {
                    IHostOutput[] iHostOutputArray = event.getLines();
                    int n = iHostOutputArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IHostOutput line = iHostOutputArray[n2];
                        if (line.getString().contains("Listening on port")) {
                            Object object = lock;
                            synchronized (object) {
                                gdbServerReady[0] = true;
                                lock.notifyAll();
                                break;
                            }
                        }
                        ++n2;
                    }
                }
            });
            try {
                remoteShellProcess = new HostShellProcessAdapter(remoteShell){

                    public synchronized void destroy() {
                        final DsfSession session = l.getSession();
                        if (session != null) {
                            try {
                                session.getExecutor().execute((Runnable)new DsfRunnable(){

                                    public void run() {
                                        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), session.getId());
                                        IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                                        if (control != null) {
                                            control.terminate((RequestMonitor)new ImmediateRequestMonitor());
                                        }
                                        tracker.dispose();
                                    }
                                });
                            }
                            catch (RejectedExecutionException rejectedExecutionException) {
                                // empty catch block
                            }
                        }
                        super.destroy();
                    }
                };
            }
            catch (Exception e) {
                if (remoteShellProcess != null) {
                    ((Process)remoteShellProcess).destroy();
                }
                RSEHelper.abort(Messages.RemoteRunLaunchDelegate_7, e, 150);
            }
            IProcess iProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)remoteShellProcess, (String)Messages.RemoteRunLaunchDelegate_RemoteShell);
            Object object = lock;
            synchronized (object) {
                while (!gdbServerReady[0]) {
                    if (monitor.isCanceled() || iProcess.isTerminated()) {
                        if (remoteShellProcess != null) {
                            ((Process)remoteShellProcess).destroy();
                        }
                        try {
                            l.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                                public void run() {
                                    l.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
                                }
                            });
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                        RSEHelper.abort(Messages.RemoteGdbLaunchDelegate_gdbserverFailedToStartErrorMessage, null, 106);
                    }
                    try {
                        lock.wait(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", RSEHelper.getRemoteHostname(config));
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
            wc.doSave();
        }
        try {
            try {
                super.launch(config, mode, launch, monitor);
                return;
            }
            catch (CoreException ex) {
                if (remoteShellProcess == null) throw ex;
                ((Process)remoteShellProcess).destroy();
                throw ex;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.launch.remote";
    }
}

