/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.IBundle;
import org.eclipse.epp.logging.aeri.core.IThrowable;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ClassPathAnalyser {
    @Nullable
    private final PackageAdmin packageAdmin;

    public ClassPathAnalyser() {
        this.packageAdmin = (PackageAdmin)this.getService(PackageAdmin.class).orNull();
    }

    @VisibleForTesting
    protected ClassPathAnalyser(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected <T> Optional<T> getService(Class<T> serviceClass) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            return Optional.absent();
        }
        ServiceReference reference = context.getServiceReference(serviceClass);
        if (reference == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)context.getService(reference));
    }

    public String computeComment(List<IBundle> presentBundles, IThrowable throwable) {
        if (this.packageAdmin == null) {
            return "";
        }
        List<String> problematicPackages = ClassPathAnalyser.extractProblematicPackage(throwable);
        if (problematicPackages.isEmpty()) {
            return "";
        }
        HashSet presentBundlesSymbolicNames = Sets.newHashSet();
        for (IBundle presentBundle : presentBundles) {
            presentBundlesSymbolicNames.add(presentBundle.getName());
        }
        StringBuilder comment = new StringBuilder();
        for (String problematicPackage : problematicPackages) {
            comment.append(Formats.format(Messages.COMMENT_PROBLEMATIC_PACKAGE_ORIGIN_EXPORTS, problematicPackage));
            Object[] exportedPackages = this.packageAdmin.getExportedPackages(problematicPackage);
            if (ArrayUtils.isEmpty((Object[])exportedPackages)) continue;
            HashMultimap exportersToImporters = HashMultimap.create();
            Object[] objectArray = exportedPackages;
            int n = exportedPackages.length;
            int n2 = 0;
            while (n2 < n) {
                Object exportedPackage = objectArray[n2];
                Bundle exportingBundle = exportedPackage.getExportingBundle();
                if (this.isPresent(exportingBundle)) {
                    Bundle[] bundleArray = exportedPackage.getImportingBundles();
                    int n3 = bundleArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Bundle importingBundle = bundleArray[n4];
                        if (this.isPresent(importingBundle) && presentBundlesSymbolicNames.contains(importingBundle.getSymbolicName())) {
                            exportersToImporters.put((Object)exportingBundle, (Object)importingBundle);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (exportersToImporters.isEmpty()) continue;
            for (Map.Entry entry : exportersToImporters.asMap().entrySet()) {
                Bundle exporter = (Bundle)entry.getKey();
                Collection importers = (Collection)entry.getValue();
                comment.append(Formats.format(Messages.COMMENT_PROBLEMATIC_PACKAGE_IMPORTS, exporter.getSymbolicName(), exporter.getVersion()));
                for (Bundle importer : importers) {
                    comment.append(Formats.format(Messages.COMMENT_PROBLEMATIC_PACKAGE_IMPORT, importer.getSymbolicName(), importer.getVersion()));
                }
            }
        }
        return comment.toString();
    }

    private boolean isPresent(Bundle bundle) {
        switch (bundle.getState()) {
            case 4: 
            case 8: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    public static List<String> extractProblematicPackage(IThrowable throwable) {
        String message = throwable.getMessage();
        if (StringUtils.equals((CharSequence)"HIDDEN", (CharSequence)message)) {
            return Lists.newArrayList();
        }
        if (NoClassDefFoundError.class.getName().equals(throwable.getClassName()) || LinkageError.class.getName().equals(throwable.getClassName())) {
            return ClassPathAnalyser.handleNoClassDefFoundErrorAndLinkageError(message);
        }
        if (ClassNotFoundException.class.getName().equals(throwable.getClassName())) {
            return ClassPathAnalyser.handleClassNotFoundException(message);
        }
        if (NoSuchMethodError.class.getName().equals(throwable.getClassName())) {
            return ClassPathAnalyser.handleMethodNotFoundException(message);
        }
        if (VerifyError.class.getName().equals(throwable.getClassName())) {
            return ClassPathAnalyser.handleVerifyError(message);
        }
        return Lists.newArrayList();
    }

    private static List<String> handleVerifyError(String message) {
        ArrayList packages = Lists.newArrayList();
        Pattern pattern = Pattern.compile("'([\\S]*)'");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String clazz = matcher.group(1);
            int lastIndexOfSlash = clazz.lastIndexOf(47);
            if (lastIndexOfSlash == -1) continue;
            String packageName = clazz.substring(0, lastIndexOfSlash);
            if (packages.contains(packageName = packageName.replaceAll("/", "."))) continue;
            packages.add(packageName);
        }
        return packages;
    }

    private static List<String> handleNoClassDefFoundErrorAndLinkageError(String message) {
        int lastIndexOfSlash = message.lastIndexOf(47);
        if (lastIndexOfSlash < 0) {
            return Lists.newArrayList();
        }
        String packageName = message.substring(0, lastIndexOfSlash).replace('/', '.');
        return Lists.newArrayList((Object[])new String[]{packageName});
    }

    private static List<String> handleClassNotFoundException(String message) {
        int lastIndexOfDot;
        int firstIndexOfSpace = message.indexOf(" ");
        if (firstIndexOfSpace >= 0) {
            message = message.substring(0, firstIndexOfSpace);
        }
        if ((lastIndexOfDot = message.lastIndexOf(46)) < 0) {
            return Lists.newArrayList();
        }
        String packageName = message.substring(0, lastIndexOfDot);
        return Lists.newArrayList((Object[])new String[]{packageName});
    }

    private static List<String> handleMethodNotFoundException(String message) {
        String className = StringUtils.substringBeforeLast((String)message, (String)".");
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        return Lists.newArrayList((Object[])new String[]{packageName});
    }
}

