/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.model.CVariableFormat;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.CLocalVariable;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;

public class CExpression
extends CLocalVariable
implements IExpression {
    private String fText;
    private ICDIExpression fCDIExpression;
    private CStackFrame fStackFrame;
    private IValue fValue = CValueFactory.NULL_VALUE;
    private ICType fType;

    public CExpression(CStackFrame frame, ICDIExpression cdiExpression, ICDIVariableDescriptor varObject) {
        super(frame, varObject);
        this.setFormat(CVariableFormat.getFormat(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT)));
        this.fText = cdiExpression.getExpressionText();
        this.fCDIExpression = cdiExpression;
        this.fStackFrame = frame;
    }

    public String getExpressionText() {
        return this.fText;
    }

    @Override
    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (event instanceof ICDIResumedEvent && source != null) {
                ICDITarget cdiTarget = source.getTarget();
                if (this.getCDITarget().equals(cdiTarget)) {
                    this.setChanged(false);
                    this.resetValue();
                }
            }
            if (event instanceof ICDIChangedEvent && source instanceof ICDIVariable) {
                this.setChanged(false);
                this.resetValue();
            }
            ++i;
        }
        super.handleDebugEvents(events);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean canEnableDisable() {
        return true;
    }

    @Override
    protected boolean isBookkeepingEnabled() {
        return false;
    }

    @Override
    public IValue getValue() {
        CStackFrame frame = (CStackFrame)this.getStackFrame();
        try {
            return this.getValue(frame);
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    protected synchronized IValue getValue(CStackFrame context) throws DebugException {
        block7: {
            if (this.fValue.equals(CValueFactory.NULL_VALUE) && context.isSuspended()) {
                try {
                    ICDIValue value = this.fCDIExpression.getValue(context.getCDIStackFrame());
                    if (value == null) break block7;
                    if (value instanceof ICDIArrayValue) {
                        int[] dims;
                        CType type = null;
                        try {
                            type = new CType(value.getType());
                        }
                        catch (CDIException cDIException) {
                            // empty catch block
                        }
                        if (type != null && type.isArray() && (dims = type.getArrayDimensions()).length > 0 && dims[0] > 0) {
                            this.fValue = CValueFactory.createIndexedValue(this, (ICDIArrayValue)value, 0, dims[0]);
                        }
                        break block7;
                    }
                    this.fValue = CValueFactory.createValue(this, value);
                }
                catch (CDIException e) {
                    CExpression.targetRequestFailed(e.getMessage(), null);
                }
            }
        }
        return this.fValue;
    }

    @Override
    protected ICStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    @Override
    protected void resetValue() {
        if (this.fValue instanceof AbstractCValue) {
            ((AbstractCValue)this.fValue).reset();
            ((AbstractCValue)this.fValue).dispose();
        }
        this.fValue = CValueFactory.NULL_VALUE;
    }

    @Override
    public String getExpressionString() throws DebugException {
        return this.getExpressionText();
    }

    @Override
    public void dispose() {
        if (this.fCDIExpression != null) {
            try {
                this.fCDIExpression.dispose();
                this.fCDIExpression = null;
            }
            catch (CDIException cDIException) {
                // empty catch block
            }
        }
        if (this.fValue instanceof AbstractCValue) {
            ((AbstractCValue)this.fValue).dispose();
            this.fValue = CValueFactory.NULL_VALUE;
        }
        this.internalDispose(true);
        this.setDisposed(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICType getType() throws DebugException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fType == null) {
            CExpression cExpression = this;
            synchronized (cExpression) {
                if (this.fType == null) {
                    this.fType = ((ICValue)this.fValue).getType();
                }
            }
        }
        return this.fType;
    }

    @Override
    public String getReferenceTypeName() throws DebugException {
        ICType type = this.getType();
        return type != null ? type.getName() : "";
    }
}

