/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIFormattable;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration2;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIBigIntegerValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIBoolValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDICharValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIDoubleValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIFloatValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIIntValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongLongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDILongValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIPointerValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIReferenceValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIShortValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIWCharValue;
import org.eclipse.cdt.debug.core.model.CVariableFormat;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.AbstractCVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CGlobalVariable;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariableFactory;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;

public class CValue
extends AbstractCValue {
    private String fValueString = null;
    private ICDIValue fCDIValue;
    private List<AbstractCVariable> fVariables = new ArrayList<AbstractCVariable>();
    private CType fType;

    protected CValue(CVariable parent, ICDIValue cdiValue) {
        super(parent);
        this.fCDIValue = cdiValue;
    }

    protected CValue(CVariable parent, String message) {
        super(parent);
        this.setStatus(2, message);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getParentVariable() != null ? this.getParentVariable().getReferenceTypeName() : null;
    }

    public String getValueString() throws DebugException {
        if (this.fValueString == null && this.getUnderlyingValue() != null) {
            boolean isSuspended;
            this.resetStatus();
            ICStackFrame cframe = this.getParentVariable().getStackFrame();
            boolean bl = isSuspended = cframe == null ? this.getCDITarget().isSuspended() : cframe.isSuspended();
            if (isSuspended) {
                try {
                    this.fValueString = this.processUnderlyingValue(this.getUnderlyingValue());
                }
                catch (CDIException e) {
                    this.setStatus(2, e.getMessage());
                    this.fValueString = e.getLocalizedMessage();
                }
            }
        }
        return this.fValueString;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        List<AbstractCVariable> list = this.getVariables0();
        return list.toArray(new IVariable[list.size()]);
    }

    protected synchronized List<AbstractCVariable> getVariables0() throws DebugException {
        if (!this.isAllocated() || !this.hasVariables()) {
            return new ArrayList<AbstractCVariable>();
        }
        if (this.fVariables.size() == 0) {
            try {
                List<ICDIVariable> vars = this.getCDIVariables();
                for (ICDIVariable var : vars) {
                    if (this.getParentVariable() instanceof CGlobalVariable) {
                        this.fVariables.add(CVariableFactory.createGlobalVariable(this, null, var));
                        continue;
                    }
                    this.fVariables.add(CVariableFactory.createLocalVariable(this, var));
                }
                this.resetStatus();
            }
            catch (DebugException e) {
                this.setStatus(2, e.getMessage());
            }
        }
        return this.fVariables;
    }

    public boolean hasVariables() throws DebugException {
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null) {
                return value.getChildrenNumber() > 0;
            }
        }
        catch (CDIException e) {
            CValue.targetRequestFailed(e.getMessage(), null);
        }
        return false;
    }

    public ICDIValue getUnderlyingValue() {
        return this.fCDIValue;
    }

    protected List<ICDIVariable> getCDIVariables() throws DebugException {
        ICDIVariable[] vars = null;
        try {
            ICDIValue value = this.getUnderlyingValue();
            if (value != null) {
                vars = value.getVariables();
            }
        }
        catch (CDIException e) {
            CValue.requestFailed(e.getMessage(), e);
        }
        if (vars == null) {
            vars = new ICDIVariable[]{};
        }
        return Arrays.asList(vars);
    }

    @Override
    protected synchronized void setChanged(boolean changed) {
        if (changed) {
            this.fValueString = null;
            this.resetStatus();
        } else if (this.getCDITarget().getConfiguration() instanceof ICDITargetConfiguration2 && ((ICDITargetConfiguration2)this.getCDITarget().getConfiguration()).supportsPassiveVariableUpdate()) {
            this.fValueString = null;
        }
        for (AbstractCVariable var : this.fVariables) {
            var.setChanged(changed);
        }
    }

    @Override
    public void dispose() {
        for (AbstractCVariable var : this.fVariables) {
            var.dispose();
        }
    }

    private String processUnderlyingValue(ICDIValue cdiValue) throws CDIException {
        if (cdiValue != null) {
            if (cdiValue instanceof ICDIBoolValue) {
                return this.getBoolValueString((ICDIBoolValue)cdiValue);
            }
            if (cdiValue instanceof ICDICharValue) {
                return this.getCharValueString((ICDICharValue)cdiValue);
            }
            if (cdiValue instanceof ICDIShortValue) {
                return this.getShortValueString((ICDIShortValue)cdiValue);
            }
            if (cdiValue instanceof ICDIIntValue) {
                return this.getIntValueString((ICDIIntValue)cdiValue);
            }
            if (cdiValue instanceof ICDILongValue) {
                return this.getLongValueString((ICDILongValue)cdiValue);
            }
            if (cdiValue instanceof ICDILongLongValue) {
                return this.getLongLongValueString((ICDILongLongValue)cdiValue);
            }
            if (cdiValue instanceof ICDIBigIntegerValue) {
                return this.getBigIntegerValueString((ICDIBigIntegerValue)cdiValue);
            }
            if (cdiValue instanceof ICDIFloatValue) {
                return this.getFloatValueString((ICDIFloatValue)cdiValue);
            }
            if (cdiValue instanceof ICDIDoubleValue) {
                return this.getDoubleValueString((ICDIDoubleValue)cdiValue);
            }
            if (cdiValue instanceof ICDIPointerValue) {
                return this.getPointerValueString((ICDIPointerValue)cdiValue);
            }
            if (cdiValue instanceof ICDIReferenceValue) {
                return this.processUnderlyingValue(((ICDIReferenceValue)cdiValue).referenceValue());
            }
            if (cdiValue instanceof ICDIWCharValue) {
                return this.getWCharValueString((ICDIWCharValue)cdiValue);
            }
            return this.getGenericValueString(cdiValue.getValueString());
        }
        return null;
    }

    private String getBoolValueString(ICDIBoolValue value) throws CDIException {
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            short byteValue = value.shortValue();
            if (byteValue == 0) {
                return "false";
            }
            if (byteValue == 1) {
                return "true";
            }
            return Integer.toString(value.shortValue());
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return Integer.toString(value.shortValue());
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = this.isUnsigned() ? Integer.toHexString(value.shortValue()) : Integer.toHexString((byte)value.byteValue());
            sb.append(stringValue.length() > 2 ? stringValue.substring(stringValue.length() - 2) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.OCTAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0");
            String stringValue = this.isUnsigned() ? Integer.toOctalString(value.shortValue()) : Integer.toOctalString((byte)value.byteValue());
            stringValue = stringValue.length() > 3 ? stringValue.substring(stringValue.length() - 3) : stringValue;
            sb.append(stringValue.length() == 3 && stringValue.charAt(0) >= '4' ? String.valueOf((char)(stringValue.charAt(0) - 4)) + stringValue.substring(1) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.BINARY.equals(format)) {
            StringBuffer sb = new StringBuffer("0b");
            String stringValue = this.isUnsigned() ? Integer.toBinaryString(value.shortValue()) : Integer.toBinaryString((byte)value.byteValue());
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getCharValueString(ICDICharValue value) throws CDIException {
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            byte byteValue = (byte)value.byteValue();
            switch (byteValue) {
                case 8: {
                    return "'\\b'";
                }
                case 9: {
                    return "'\\t'";
                }
                case 10: {
                    return "'\\n'";
                }
                case 12: {
                    return "'\\f'";
                }
                case 13: {
                    return "'\\r'";
                }
            }
            if (Character.isISOControl(byteValue)) {
                return Byte.toString(byteValue);
            }
            if (byteValue < 0) {
                return this.isUnsigned() ? Short.toString(value.shortValue()) : Byte.toString(byteValue);
            }
            return new String(new byte[]{39, byteValue, 39});
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return this.isUnsigned() ? Integer.toString(value.shortValue()) : Integer.toString((byte)value.byteValue());
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = this.isUnsigned() ? Integer.toHexString(value.shortValue()) : Integer.toHexString((byte)value.byteValue());
            sb.append(stringValue.length() > 2 ? stringValue.substring(stringValue.length() - 2) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.OCTAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0");
            String stringValue = this.isUnsigned() ? Integer.toOctalString(value.shortValue()) : Integer.toOctalString((byte)value.byteValue());
            stringValue = stringValue.length() > 3 ? stringValue.substring(stringValue.length() - 3) : stringValue;
            sb.append(stringValue.length() == 3 && stringValue.charAt(0) >= '4' ? String.valueOf((char)(stringValue.charAt(0) - 4)) + stringValue.substring(1) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.BINARY.equals(format)) {
            StringBuffer sb = new StringBuffer("0b");
            String stringValue = this.isUnsigned() ? Integer.toBinaryString(value.shortValue()) : Integer.toBinaryString((byte)value.byteValue());
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getShortValueString(ICDIShortValue value) throws CDIException {
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            format = CValue.getNaturalFormat(value, CVariableFormat.DECIMAL);
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return this.isUnsigned() ? Integer.toString(value.intValue()) : Short.toString(value.shortValue());
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Integer.toHexString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
            sb.append(stringValue.length() > 4 ? stringValue.substring(stringValue.length() - 4) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.OCTAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0");
            String stringValue = Integer.toOctalString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
            stringValue = stringValue.length() > 6 ? stringValue.substring(stringValue.length() - 6) : stringValue;
            sb.append(stringValue.length() == 6 && stringValue.charAt(0) >= '2' ? String.valueOf((char)((stringValue.charAt(0) - 48) % 2 + 48)) + stringValue.substring(1) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.BINARY.equals(format)) {
            StringBuffer sb = new StringBuffer("0b");
            String stringValue = Integer.toBinaryString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
            sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getIntValueString(ICDIIntValue value) throws CDIException {
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            format = CValue.getNaturalFormat(value, CVariableFormat.DECIMAL);
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return this.isUnsigned() ? Long.toString(value.longValue()) : Integer.toString(value.intValue());
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = this.isUnsigned() ? Long.toHexString(value.longValue()) : Integer.toHexString(value.intValue());
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.OCTAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0");
            String stringValue = this.isUnsigned() ? Long.toOctalString(value.longValue()) : Integer.toOctalString(value.intValue());
            stringValue = stringValue.length() > 11 ? stringValue.substring(stringValue.length() - 11) : stringValue;
            sb.append(stringValue.length() == 11 && stringValue.charAt(0) >= '4' ? String.valueOf((char)(stringValue.charAt(0) - 4)) + stringValue.substring(1) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.BINARY.equals(format)) {
            StringBuffer sb = new StringBuffer("0b");
            String stringValue = this.isUnsigned() ? Long.toBinaryString(value.longValue()) : Integer.toBinaryString(value.intValue());
            sb.append(stringValue.length() > 32 ? stringValue.substring(stringValue.length() - 32) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getLongValueString(ICDILongValue value) throws CDIException {
        try {
            CVariableFormat format = this.getParentVariable().getFormat();
            if (CVariableFormat.NATURAL.equals(format)) {
                format = CValue.getNaturalFormat(value, CVariableFormat.DECIMAL);
            }
            if (CVariableFormat.DECIMAL.equals(format)) {
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    return bigValue.toString();
                }
                return Integer.toString(value.intValue());
            }
            if (CVariableFormat.HEXADECIMAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0x");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(16));
                } else {
                    sb.append(Integer.toHexString(value.intValue()));
                }
                return sb.toString();
            }
            if (CVariableFormat.OCTAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(8));
                } else {
                    sb.append(Integer.toOctalString(value.intValue()));
                }
                return sb.toString();
            }
            if (CVariableFormat.BINARY.equals(format)) {
                StringBuffer sb = new StringBuffer("0b");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(2));
                } else {
                    sb.append(Integer.toBinaryString(value.intValue()));
                }
                return sb.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private String getLongLongValueString(ICDILongLongValue value) throws CDIException {
        try {
            CVariableFormat format = this.getParentVariable().getFormat();
            if (CVariableFormat.NATURAL.equals(format)) {
                format = CValue.getNaturalFormat(value, CVariableFormat.DECIMAL);
            }
            if (CVariableFormat.DECIMAL.equals(format)) {
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    return bigValue.toString();
                }
                return Long.toString(value.longValue());
            }
            if (CVariableFormat.HEXADECIMAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0x");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(16));
                } else {
                    sb.append(Long.toHexString(value.longValue()));
                }
                return sb.toString();
            }
            if (CVariableFormat.OCTAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(8));
                } else {
                    sb.append(Long.toOctalString(value.longValue()));
                }
                return sb.toString();
            }
            if (CVariableFormat.BINARY.equals(format)) {
                StringBuffer sb = new StringBuffer("0b");
                if (this.isUnsigned()) {
                    BigInteger bigValue = new BigInteger(value.getValueString());
                    sb.append(bigValue.toString(2));
                } else {
                    sb.append(Long.toBinaryString(value.longValue()));
                }
                return sb.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private String getGenericValueString(String svalue) throws CDIException {
        try {
            BigInteger bigValue = new BigInteger(svalue);
            CVariableFormat format = this.getParentVariable().getFormat();
            if (CVariableFormat.NATURAL.equals(format)) {
                format = CVariableFormat.DECIMAL;
            }
            if (CVariableFormat.DECIMAL.equals(format)) {
                return svalue;
            }
            if (CVariableFormat.HEXADECIMAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0x");
                if (this.isUnsigned()) {
                    sb.append(bigValue.toString(16));
                } else {
                    sb.append(Long.toHexString(bigValue.longValue()));
                }
                return sb.toString();
            }
            if (CVariableFormat.OCTAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0");
                if (this.isUnsigned()) {
                    sb.append(bigValue.toString(8));
                } else {
                    sb.append(Long.toOctalString(bigValue.longValue()));
                }
                return sb.toString();
            }
            if (CVariableFormat.BINARY.equals(format)) {
                StringBuffer sb = new StringBuffer("0b");
                if (this.isUnsigned()) {
                    sb.append(bigValue.toString(2));
                } else {
                    sb.append(Long.toBinaryString(bigValue.longValue()));
                }
                return sb.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return svalue;
    }

    private String getFloatValueString(ICDIFloatValue value) throws CDIException {
        float floatValue = value.floatValue();
        if (Float.isNaN(floatValue)) {
            return "NaN";
        }
        if (Float.isInfinite(floatValue)) {
            return "inf";
        }
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            return Float.toString(floatValue);
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(Float.floatToIntBits(floatValue));
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(Float.floatToIntBits(floatValue));
            sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.OCTAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0");
            String stringValue = Long.toOctalString(Float.floatToIntBits(floatValue));
            stringValue = stringValue.length() > 11 ? stringValue.substring(stringValue.length() - 11) : stringValue;
            sb.append(stringValue.length() == 11 && stringValue.charAt(0) >= '4' ? String.valueOf((char)(stringValue.charAt(0) - 4)) + stringValue.substring(1) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.BINARY.equals(format)) {
            StringBuffer sb = new StringBuffer("0b");
            String stringValue = Long.toBinaryString(Float.floatToIntBits(floatValue));
            sb.append(stringValue.length() > 32 ? stringValue.substring(stringValue.length() - 32) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getDoubleValueString(ICDIDoubleValue value) throws CDIException {
        double doubleValue = value.doubleValue();
        if (Double.isNaN(doubleValue)) {
            return "NaN";
        }
        if (Double.isInfinite(doubleValue)) {
            return "inf";
        }
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format)) {
            return Double.toString(doubleValue);
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return Long.toString(Double.doubleToLongBits(doubleValue));
        }
        if (CVariableFormat.HEXADECIMAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0x");
            String stringValue = Long.toHexString(Double.doubleToLongBits(doubleValue));
            sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.OCTAL.equals(format)) {
            StringBuffer sb = new StringBuffer("0");
            String stringValue = Long.toOctalString(Double.doubleToLongBits(doubleValue));
            stringValue = stringValue.length() > 22 ? stringValue.substring(stringValue.length() - 22) : stringValue;
            sb.append(stringValue.length() == 22 && stringValue.charAt(0) >= '2' ? String.valueOf((char)((stringValue.charAt(0) - 48) % 2 + 48)) + stringValue.substring(1) : stringValue);
            return sb.toString();
        }
        if (CVariableFormat.BINARY.equals(format)) {
            StringBuffer sb = new StringBuffer("0b");
            String stringValue = Long.toBinaryString(Double.doubleToLongBits(doubleValue));
            sb.append(stringValue.length() > 64 ? stringValue.substring(stringValue.length() - 64) : stringValue);
            return sb.toString();
        }
        return null;
    }

    private String getPointerValueString(ICDIPointerValue value) throws CDIException {
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        BigInteger pv = value.pointerValue();
        if (pv == null) {
            return "";
        }
        IAddress address = factory.createAddress(pv);
        if (address == null) {
            return "";
        }
        CVariableFormat format = this.getParentVariable().getFormat();
        if (CVariableFormat.NATURAL.equals(format) || CVariableFormat.HEXADECIMAL.equals(format)) {
            return address.toHexAddressString();
        }
        if (CVariableFormat.DECIMAL.equals(format)) {
            return address.toString();
        }
        if (CVariableFormat.OCTAL.equals(format)) {
            if (address instanceof Addr32) {
                return ((Addr32)address).toOctalAddressString();
            }
            if (address instanceof Addr64) {
                return ((Addr64)address).toOctalAddressString();
            }
            return address.toHexAddressString();
        }
        if (CVariableFormat.BINARY.equals(format)) {
            return address.toBinaryAddressString();
        }
        return null;
    }

    private String getWCharValueString(ICDIWCharValue value) throws CDIException {
        if (this.getParentVariable() instanceof CVariable) {
            CVariableFormat format;
            int size = ((CVariable)this.getParentVariable()).sizeof();
            if (size == 2) {
                format = this.getParentVariable().getFormat();
                if (CVariableFormat.NATURAL.equals(format)) {
                    String stringValue;
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    buffer.putInt(value.intValue());
                    buffer.position(2);
                    try {
                        stringValue = new String(CDebugUtils.getCharsetDecoder().decode(buffer).array());
                    }
                    catch (CharacterCodingException e) {
                        stringValue = e.toString();
                    }
                    StringBuffer sb = new StringBuffer("'");
                    sb.append(stringValue);
                    sb.append('\'');
                    return sb.toString();
                }
                if (CVariableFormat.DECIMAL.equals(format)) {
                    return this.isUnsigned() ? Integer.toString(value.intValue()) : Short.toString(value.shortValue());
                }
                if (CVariableFormat.HEXADECIMAL.equals(format)) {
                    StringBuffer sb = new StringBuffer("0x");
                    String stringValue = Integer.toHexString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
                    sb.append(stringValue.length() > 4 ? stringValue.substring(stringValue.length() - 4) : stringValue);
                    return sb.toString();
                }
                if (CVariableFormat.OCTAL.equals(format)) {
                    StringBuffer sb = new StringBuffer("0");
                    String stringValue = Integer.toOctalString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
                    stringValue = stringValue.length() > 6 ? stringValue.substring(stringValue.length() - 6) : stringValue;
                    sb.append(stringValue.length() == 6 && stringValue.charAt(0) >= '2' ? String.valueOf((char)((stringValue.charAt(0) - 48) % 2 + 48)) + stringValue.substring(1) : stringValue);
                    return sb.toString();
                }
                if (CVariableFormat.BINARY.equals(format)) {
                    StringBuffer sb = new StringBuffer("0b");
                    String stringValue = Integer.toBinaryString(this.isUnsigned() ? value.intValue() : (int)value.shortValue());
                    sb.append(stringValue.length() > 16 ? stringValue.substring(stringValue.length() - 16) : stringValue);
                    return sb.toString();
                }
            }
            if (size == 4) {
                format = this.getParentVariable().getFormat();
                if (CVariableFormat.NATURAL.equals(format)) {
                    String stringValue;
                    ByteBuffer buffer = ByteBuffer.allocate(8);
                    buffer.putLong(value.longValue());
                    buffer.position(4);
                    try {
                        stringValue = new String(CDebugUtils.getCharsetDecoder().decode(buffer).array());
                    }
                    catch (CharacterCodingException e) {
                        stringValue = e.toString();
                    }
                    StringBuffer sb = new StringBuffer("'");
                    sb.append(stringValue);
                    sb.append('\'');
                    return sb.toString();
                }
                if (CVariableFormat.DECIMAL.equals(format)) {
                    return this.isUnsigned() ? Long.toString(value.longValue()) : Integer.toString(value.intValue());
                }
                if (CVariableFormat.HEXADECIMAL.equals(format)) {
                    StringBuffer sb = new StringBuffer("0x");
                    String stringValue = this.isUnsigned() ? Long.toHexString(value.longValue()) : Integer.toHexString(value.intValue());
                    sb.append(stringValue.length() > 8 ? stringValue.substring(stringValue.length() - 8) : stringValue);
                    return sb.toString();
                }
                if (CVariableFormat.OCTAL.equals(format)) {
                    StringBuffer sb = new StringBuffer("0");
                    String stringValue = this.isUnsigned() ? Long.toOctalString(value.longValue()) : Integer.toOctalString(value.intValue());
                    stringValue = stringValue.length() > 11 ? stringValue.substring(stringValue.length() - 11) : stringValue;
                    sb.append(stringValue.length() == 11 && stringValue.charAt(0) >= '4' ? String.valueOf((char)(stringValue.charAt(0) - 4)) + stringValue.substring(1) : stringValue);
                    return sb.toString();
                }
                if (CVariableFormat.BINARY.equals(format)) {
                    StringBuffer sb = new StringBuffer("0b");
                    String stringValue = this.isUnsigned() ? Long.toBinaryString(value.longValue()) : Integer.toBinaryString(value.intValue());
                    sb.append(stringValue.length() > 32 ? stringValue.substring(stringValue.length() - 32) : stringValue);
                    return sb.toString();
                }
            }
        }
        return value.getValueString();
    }

    private String getBigIntegerValueString(ICDIBigIntegerValue value) throws CDIException {
        try {
            CVariableFormat format = this.getParentVariable().getFormat();
            if (CVariableFormat.NATURAL.equals(format)) {
                format = CValue.getNaturalFormat(value, CVariableFormat.DECIMAL);
            }
            if (CVariableFormat.DECIMAL.equals(format)) {
                BigInteger bigValue = value.bigIntegerValue();
                return bigValue.toString(10);
            }
            if (CVariableFormat.HEXADECIMAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0x");
                sb.append(value.bigIntegerValue().toString(16));
                return sb.toString();
            }
            if (CVariableFormat.OCTAL.equals(format)) {
                StringBuffer sb = new StringBuffer("0");
                sb.append(value.bigIntegerValue().toString(8));
                return sb.toString();
            }
            if (CVariableFormat.BINARY.equals(format)) {
                StringBuffer sb = new StringBuffer("0b");
                sb.append(value.bigIntegerValue().toString(2));
                return sb.toString();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private boolean isUnsigned() {
        boolean result = false;
        try {
            ICType type = this.getParentVariable().getType();
            if (type != null) {
                result = type.isUnsigned();
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected void reset() {
        this.resetStatus();
        this.fValueString = null;
        for (AbstractCVariable var : this.fVariables) {
            var.resetValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICType getType() throws DebugException {
        ICDIValue cdiValue = this.getUnderlyingValue();
        if (this.fType == null && cdiValue != null) {
            CValue cValue = this;
            synchronized (cValue) {
                if (this.fType == null) {
                    try {
                        this.fType = new CType(cdiValue.getType());
                    }
                    catch (CDIException e) {
                        CValue.requestFailed(e.getMessage(), null);
                    }
                }
            }
        }
        return this.fType;
    }

    @Override
    protected void preserve() {
        this.setChanged(false);
        this.resetStatus();
        for (AbstractCVariable var : this.fVariables) {
            var.preserve();
        }
    }

    private static CVariableFormat getNaturalFormat(ICDIValue value, CVariableFormat defaultFormat) throws CDIException {
        if (value instanceof ICDIFormattable) {
            int naturalFormat = ((ICDIFormattable)((Object)value)).getNaturalFormat();
            switch (naturalFormat) {
                case 1: {
                    return CVariableFormat.DECIMAL;
                }
                case 2: {
                    return CVariableFormat.BINARY;
                }
                case 3: {
                    return CVariableFormat.OCTAL;
                }
                case 4: {
                    return CVariableFormat.HEXADECIMAL;
                }
            }
        }
        return defaultFormat;
    }
}

