/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.CProjectSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IMappingSourceContainer;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SourceUtils {
    private static final String NAME_COMMON_SOURCE_LOCATIONS = "commonSourceLocations";
    private static final String NAME_SOURCE_LOCATION = "sourceLocation";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_MEMENTO = "memento";

    public static String getCommonSourceLocationsMemento(ICSourceLocation[] locations) {
        Document document = null;
        Exception ex = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(NAME_COMMON_SOURCE_LOCATIONS);
            document.appendChild(element);
            SourceUtils.saveSourceLocations(document, element, locations);
            return CDebugUtils.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (TransformerException e) {
            ex = e;
        }
        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error saving common source settings.", (Throwable)ex));
        return null;
    }

    private static void saveSourceLocations(Document doc, Element node, ICSourceLocation[] locations) {
        int i = 0;
        while (i < locations.length) {
            block3: {
                Element child = doc.createElement(NAME_SOURCE_LOCATION);
                child.setAttribute(ATTR_CLASS, locations[i].getClass().getName());
                try {
                    child.setAttribute(ATTR_MEMENTO, locations[i].getMemento());
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e);
                    break block3;
                }
                node.appendChild(child);
            }
            ++i;
        }
    }

    public static ICSourceLocation[] getCommonSourceLocationsFromMemento(String memento) {
        ICSourceLocation[] result = new ICSourceLocation[]{};
        if (!SourceUtils.isEmpty(memento)) {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                StringReader reader = new StringReader(memento);
                InputSource source = new InputSource(reader);
                Element root = parser.parse(source).getDocumentElement();
                if (root.getNodeName().equalsIgnoreCase(NAME_COMMON_SOURCE_LOCATIONS)) {
                    result = SourceUtils.initializeSourceLocations(root);
                }
            }
            catch (ParserConfigurationException e) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)e));
            }
            catch (SAXException e) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)e));
            }
            catch (IOException e) {
                CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 0, "Error initializing common source settings.", (Throwable)e));
            }
        }
        return result;
    }

    public static ICSourceLocation[] initializeSourceLocations(Element root) {
        LinkedList<ICSourceLocation> sourceLocations = new LinkedList<ICSourceLocation>();
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            block11: {
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase(NAME_SOURCE_LOCATION)) {
                    String className = entry.getAttribute(ATTR_CLASS);
                    String data = entry.getAttribute(ATTR_MEMENTO);
                    if (className == null || className.trim().length() == 0) {
                        CDebugCorePlugin.log("Unable to restore common source locations - invalid format.");
                    } else {
                        Class clazz = null;
                        try {
                            clazz = CDebugCorePlugin.getDefault().getBundle().loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            CDebugCorePlugin.log(MessageFormat.format((String)"Unable to restore source location - class not found {0}", (Object[])new String[]{className}));
                            break block11;
                        }
                        ICSourceLocation location = null;
                        try {
                            location = (ICSourceLocation)clazz.newInstance();
                        }
                        catch (IllegalAccessException e) {
                            CDebugCorePlugin.log("Unable to restore source location: " + e.getMessage());
                            break block11;
                        }
                        catch (InstantiationException e) {
                            CDebugCorePlugin.log("Unable to restore source location: " + e.getMessage());
                            break block11;
                        }
                        try {
                            location.initializeFrom(data);
                            sourceLocations.add(location);
                        }
                        catch (CoreException e) {
                            CDebugCorePlugin.log("Unable to restore source location: " + e.getMessage());
                        }
                    }
                }
            }
            ++i;
        }
        return sourceLocations.toArray(new ICSourceLocation[sourceLocations.size()]);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static ISourceContainer[] convertSourceLocations(ICSourceLocation[] locations) {
        ArrayList<Object> containers = new ArrayList<Object>(locations.length);
        int mappingCount = 0;
        ICSourceLocation[] iCSourceLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceLocation location = iCSourceLocationArray[n2];
            if (location instanceof IProjectSourceLocation) {
                containers.add((Object)new CProjectSourceContainer(((IProjectSourceLocation)location).getProject(), false));
            } else if (location instanceof IDirectorySourceLocation) {
                IDirectorySourceLocation d = (IDirectorySourceLocation)location;
                IPath a = d.getAssociation();
                if (a != null) {
                    MappingSourceContainer mapping = new MappingSourceContainer(String.valueOf(InternalSourceLookupMessages.SourceUtils_0) + ++mappingCount);
                    mapping.addMapEntries(new MapEntrySourceContainer[]{new MapEntrySourceContainer(a, d.getDirectory())});
                    containers.add(mapping);
                }
                containers.add(new DirectorySourceContainer(d.getDirectory(), d.searchSubfolders()));
            }
            ++n2;
        }
        return containers.toArray(new ISourceContainer[containers.size()]);
    }

    static IPath getCompilationPath(ISourceContainer container, String sourceName) {
        if (container instanceof IMappingSourceContainer) {
            return ((IMappingSourceContainer)container).getCompilationPath(sourceName);
        }
        try {
            ISourceContainer[] iSourceContainerArray = container.getSourceContainers();
            int n = iSourceContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceContainer cont = iSourceContainerArray[n2];
                IPath path = SourceUtils.getCompilationPath(cont, sourceName);
                if (path != null) {
                    return path;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static IProject[] getAllReferencedProjects(IProject project) throws CoreException {
        HashSet<IProject> all = new HashSet<IProject>();
        SourceUtils.getAllReferencedProjects(all, project);
        return all.toArray(new IProject[all.size()]);
    }

    private static void getAllReferencedProjects(Set<IProject> all, IProject project) throws CoreException {
        IProject[] iProjectArray = project.getReferencedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject ref = iProjectArray[n2];
            if (!all.contains(ref) && ref.exists() && ref.isOpen()) {
                all.add(ref);
                SourceUtils.getAllReferencedProjects(all, ref);
            }
            ++n2;
        }
    }

    public static IProject getLaunchConfigurationProject(ISourceLookupDirector director) {
        String name = SourceUtils.getLaunchConfigurationProjectName(director);
        return name != null ? ResourcesPlugin.getWorkspace().getRoot().getProject(name) : null;
    }

    public static String getLaunchConfigurationProjectName(ISourceLookupDirector director) {
        ILaunchConfiguration config = director.getLaunchConfiguration();
        if (config != null) {
            try {
                String name = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                if (name.length() > 0) {
                    return name;
                }
            }
            catch (CoreException e) {
                CDebugCorePlugin.log(e);
            }
        }
        return null;
    }

    public static Object[] findSourceElements(File file, ISourceLookupDirector director) {
        IFile[] wfiles = ResourceLookup.findFilesForLocation((IPath)new Path(file.getAbsolutePath()));
        IProject lcProject = null;
        if (director != null) {
            lcProject = SourceUtils.getLaunchConfigurationProject(director);
        }
        if (wfiles.length > 0) {
            ResourceLookup.sortFilesByRelevance((IFile[])wfiles, (IProject)lcProject);
            return SourceUtils.updateUnavailableResources(wfiles, lcProject);
        }
        try {
            ICProject project;
            wfiles = ResourceLookup.findFilesForLocation((IPath)new Path(file.getCanonicalPath()));
            if (wfiles.length > 0) {
                ResourceLookup.sortFilesByRelevance((IFile[])wfiles, (IProject)lcProject);
                return SourceUtils.updateUnavailableResources(wfiles, lcProject);
            }
            if (lcProject != null && (project = CoreModel.getDefault().create(lcProject)) != null) {
                return new ITranslationUnit[]{CoreModel.getDefault().createTranslationUnitFrom(project, URIUtil.toURI((String)file.getCanonicalPath(), (boolean)true))};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new LocalFileStorage[]{new LocalFileStorage(file)};
    }

    private static Object[] updateUnavailableResources(IFile[] wfiles, IProject project) {
        if (project == null) {
            return wfiles;
        }
        ICProject cProject = CoreModel.getDefault().create(project);
        Object[] result = new Object[wfiles.length];
        int i = 0;
        while (i < wfiles.length) {
            IFile wkspFile = wfiles[i];
            result[i] = wkspFile.isAccessible() ? wkspFile : CoreModel.getDefault().createTranslationUnitFrom(cProject, wkspFile.getLocationURI());
            ++i;
        }
        return result;
    }
}

