/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import java.util.Arrays;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelImage;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelImage;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelRoot;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSorting;
import org.eclipse.swt.graphics.Image;

public class UiModelDependent
implements IUiModelElement {
    private IUiModelElement parent;
    private OpModelImage[] dataModelDependents;
    private UiModelImage[] dependents;
    private int totalCount;
    private int depCount;

    public UiModelDependent(IUiModelElement parent, OpModelImage[] dependents, int totalCount, int depCount) {
        this.parent = parent;
        this.dataModelDependents = dependents;
        this.dependents = null;
        this.totalCount = totalCount + depCount;
        this.depCount = depCount;
        this.refreshModel();
    }

    private void refreshModel() {
        this.dependents = new UiModelImage[this.dataModelDependents.length];
        int i = 0;
        while (i < this.dataModelDependents.length) {
            this.dependents[i] = new UiModelImage(this, this.dataModelDependents[i], this.totalCount, 0);
            ++i;
        }
    }

    public String toString() {
        double countPercentage = (double)this.depCount / (double)this.totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.percentage.in") + " " + OprofileUiMessages.getString("uimodel.dependent.dependent.images");
    }

    @Override
    public String getLabelText() {
        return this.toString();
    }

    @Override
    public IUiModelElement[] getChildren() {
        if (UiModelRoot.SortType.LIB == UiModelRoot.getSortingType()) {
            Arrays.sort(this.dependents, UiModelSorting.getInstance());
            return this.dependents;
        }
        return this.dependents;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public IUiModelElement getParent() {
        return this.parent;
    }

    @Override
    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/dependent.gif").createImage();
    }
}

