/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import java.util.Arrays;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelEvent;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSession;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelEvent;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelRoot;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSorting;
import org.eclipse.swt.graphics.Image;

public class UiModelSession
implements IUiModelElement {
    private OpModelSession session;
    private UiModelEvent[] events;
    private static final String DEFAULT_SESSION_NAME = "current";

    public UiModelSession(OpModelSession session) {
        if (session != null) {
            this.session = session;
            this.refreshModel();
        }
    }

    private void refreshModel() {
        OpModelEvent[] dataModelEvents = this.session.getEvents();
        this.events = new UiModelEvent[dataModelEvents.length];
        int i = 0;
        while (i < dataModelEvents.length) {
            this.events[i] = new UiModelEvent(this, dataModelEvents[i]);
            ++i;
        }
    }

    public String toString() {
        return this.session.getName();
    }

    public boolean isDefaultSession() {
        return this.session.getName().equalsIgnoreCase(DEFAULT_SESSION_NAME);
    }

    @Override
    public String getLabelText() {
        if (this.session.getName().equals(DEFAULT_SESSION_NAME)) {
            return OprofileUiMessages.getString("UiModelSession_current");
        }
        return this.toString();
    }

    @Override
    public IUiModelElement[] getChildren() {
        if (UiModelRoot.SortType.EVENT == UiModelRoot.getSortingType()) {
            Arrays.sort(this.events, UiModelSorting.getInstance());
            return this.events;
        }
        return this.events;
    }

    @Override
    public boolean hasChildren() {
        return this.events != null && this.events.length != 0;
    }

    @Override
    public IUiModelElement getParent() {
        return null;
    }

    @Override
    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/session.gif").createImage();
    }
}

