/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.actions.KernelSourceAction;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.KernelSourceTree;
import org.eclipse.linuxtools.systemtap.structures.TreeNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class KernelBrowserView
extends BrowserView {
    public static final String ID = "org.eclipse.linuxtools.internal.systemtap.ui.ide.views.KernelBrowserView";
    private final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("KernelSourcePreference") || event.getProperty().equals("RemoteLocalKernelSource") || event.getProperty().equals("ExcludedKernelSource")) {
                KernelBrowserView.this.refresh();
            }
        }
    };

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.refresh();
        this.makeActions();
    }

    @Override
    protected void makeActions() {
        this.doubleClickAction = new KernelSourceAction(this.getSite().getWorkbenchWindow(), this);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickAction);
        IDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected Image getEntryImage(TreeNode treeObj) {
        if (treeObj.toString().equals(Localization.getString("KernelBrowserView.NoKernelSourceFound"))) {
            return null;
        }
        if (treeObj.toString().lastIndexOf(46) != -1) {
            String item = treeObj.getData().toString();
            if (item.endsWith(".c")) {
                return IDEPlugin.getImageDescriptor("icons/files/file_c.gif").createImage();
            }
            if (item.endsWith(".h")) {
                return IDEPlugin.getImageDescriptor("icons/files/file_h.gif").createImage();
            }
            return IDEPlugin.getImageDescriptor("icons/vars/var_unk.gif").createImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public void refresh() {
        this.displayLoadingMessage();
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        String kernelSource = p.getString("KernelSourcePreference");
        if (kernelSource == null || kernelSource.length() < 1) {
            this.displayMessage(Localization.getString("KernelBrowserView.NoKernelSourceFound"));
            return;
        }
        String localOrRemote = p.getString("RemoteLocalKernelSource");
        URI kernelLocationURI = null;
        IRemoteFileProxy proxy = null;
        boolean remote = localOrRemote.equals("remote");
        if (remote) {
            boolean error = false;
            try {
                kernelLocationURI = IDEPlugin.getDefault().createRemoteUri(kernelSource);
                if (kernelLocationURI == null) {
                    error = true;
                } else {
                    proxy = RemoteProxyManager.getInstance().getFileProxy(kernelLocationURI);
                    if (!this.validateProxy(proxy, kernelSource)) {
                        error = true;
                    }
                }
            }
            catch (CoreException e2) {
                error = true;
            }
            if (error) {
                this.displayMessage(Localization.getString("KernelBrowserView.KernelSourceDirNotFound"));
                return;
            }
        }
        KernelRefreshJob refreshJob = new KernelRefreshJob(remote, kernelLocationURI, proxy, kernelSource);
        refreshJob.setPriority(20);
        refreshJob.schedule();
    }

    private boolean validateProxy(IRemoteFileProxy proxy, String kernelSource) {
        if (proxy == null) {
            return false;
        }
        IFileStore fs = proxy.getResource(kernelSource);
        if (fs == null) {
            return false;
        }
        IFileInfo info = fs.fetchInfo();
        if (info == null) {
            return false;
        }
        return info.exists();
    }

    @Override
    public void dispose() {
        IDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        super.dispose();
    }

    private class KernelRefreshJob
    extends Job {
        private boolean remote;
        private URI kernelLocationURI;
        private IRemoteFileProxy proxy;
        private String kernelSource;

        public KernelRefreshJob(boolean remote, URI kernelLocationURI, IRemoteFileProxy proxy, String kernelSource) {
            super(Localization.getString("KernelBrowserView.RefreshingKernelSource"));
            this.remote = remote;
            this.kernelLocationURI = kernelLocationURI;
            this.proxy = proxy;
            this.kernelSource = kernelSource;
        }

        public IStatus run(IProgressMonitor monitor) {
            IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
            KernelSourceTree kst = new KernelSourceTree();
            String[] excluded = p.getString("ExcludedKernelSource").split(File.pathSeparator);
            if (this.remote) {
                try {
                    kst.buildKernelTree(this.kernelLocationURI, excluded, this.proxy, monitor);
                }
                catch (CoreException e) {
                    ExceptionErrorDialog.openError((String)Localization.getString("KernelBrowserView.CouldNotInitializeTree"), (Exception)((Object)e));
                }
            } else {
                kst.buildKernelTree(this.kernelSource, excluded);
            }
            if (monitor.isCanceled()) {
                KernelBrowserView.this.setViewerInput(null);
                return Status.CANCEL_STATUS;
            }
            KernelBrowserView.this.setViewerInput(kst.getTree());
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

