/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.HashMap;
import java.util.Map;

public class CheckersTimeStats {
    public static final String ALL = "ALL";
    public static final String ELAPSED = "ELAPSED";
    private static CheckersTimeStats instance = new CheckersTimeStats();
    private boolean enableStats = false;
    private Map<String, TimeRecord> records = new HashMap<String, TimeRecord>();

    public static CheckersTimeStats getInstance() {
        return instance;
    }

    private TimeRecord getTimeRecord(String id) {
        TimeRecord record = this.records.get(id);
        if (record == null) {
            record = new TimeRecord();
            this.records.put(id, record);
        }
        return record;
    }

    public void checkerStart(String id) {
        this.checkerStart(id, ELAPSED);
    }

    public void checkerStart(String id, String counter) {
        if (this.enableStats) {
            TimeRecord record = this.getTimeRecord(this.getKey(id, counter));
            record.start();
        }
    }

    private String getKey(String id, String counter) {
        return String.valueOf(id) + ":" + counter;
    }

    public void checkerStop(String id, String counter) {
        if (this.enableStats) {
            this.getTimeRecord(this.getKey(id, counter)).stop();
        }
    }

    public void checkerStop(String id) {
        this.checkerStop(id, ELAPSED);
    }

    public void traceStats() {
        if (this.enableStats) {
            this.printStats();
        }
    }

    public void printStats() {
        System.out.println("---");
        String totalId = this.getKey(ALL, ELAPSED);
        TimeRecord all = this.records.get(totalId);
        for (String id : this.records.keySet()) {
            if (id.equals(totalId)) continue;
            TimeRecord timeRecord = this.getTimeRecord(id);
            System.out.println(String.valueOf(timeRecord.toString(all.duration)) + " " + id);
        }
        System.out.println(String.valueOf(all.toString()) + " " + totalId);
    }

    public void reset() {
        this.records.clear();
    }

    public boolean isEnabled() {
        return this.enableStats;
    }

    public void setEnabled(boolean enableStats) {
        this.enableStats = enableStats;
    }

    private static class TimeRecord {
        private long duration;
        private long current;
        private int count;

        private TimeRecord() {
        }

        public void start() {
            this.current = System.currentTimeMillis();
        }

        public void stop() {
            ++this.count;
            this.duration += System.currentTimeMillis() - this.current;
            this.current = 0L;
        }

        public String toString() {
            return String.format("%4d %4d %4.2f", this.duration, this.count, Float.valueOf(this.count == 0 ? (float)this.count : (float)this.duration / (float)this.count));
        }

        public String toString(long total) {
            float ave = this.count == 0 ? (float)this.count : (float)this.duration / (float)this.count;
            float per = total == 0L ? 100.0f : (float)(this.duration * 100L) / (float)total;
            return String.format("%4d %4d %4.2f %4.2f%%", this.duration, this.count, Float.valueOf(ave), Float.valueOf(per));
        }
    }
}

