/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.linuxtools.internal.rpm.createrepo.CreaterepoProject;
import org.eclipse.linuxtools.internal.rpm.createrepo.tree.CreaterepoTreeCategory;

public class CreaterepoCategoryModel {
    private IEclipsePreferences projectPreferences;

    public CreaterepoCategoryModel(CreaterepoProject project) {
        if (project != null) {
            this.projectPreferences = project.getEclipsePreferences();
        }
    }

    public List<CreaterepoTreeCategory> getCategories() {
        ArrayList<CreaterepoTreeCategory> model = new ArrayList<CreaterepoTreeCategory>();
        CreaterepoTreeCategory distroCat = new CreaterepoTreeCategory("distro");
        distroCat.addAllTags(this.getDistroTags());
        CreaterepoTreeCategory contentCat = new CreaterepoTreeCategory("content");
        contentCat.addAllTags(this.getContentTags());
        CreaterepoTreeCategory repoCat = new CreaterepoTreeCategory("repo");
        repoCat.addAllTags(this.getRepoTags());
        model.add(distroCat);
        model.add(contentCat);
        model.add(repoCat);
        return model;
    }

    private List<String> getDistroTags() {
        String tagPref;
        if (this.projectPreferences != null && !(tagPref = this.projectPreferences.get("distro", "")).isEmpty()) {
            return Arrays.asList(tagPref.split(";"));
        }
        return Collections.EMPTY_LIST;
    }

    private List<String> getContentTags() {
        String tagPref;
        if (this.projectPreferences != null && !(tagPref = this.projectPreferences.get("content", "")).isEmpty()) {
            return Arrays.asList(tagPref.split(";"));
        }
        return Collections.EMPTY_LIST;
    }

    private List<String> getRepoTags() {
        String tagPref;
        if (this.projectPreferences != null && !(tagPref = this.projectPreferences.get("repo", "")).isEmpty()) {
            return Arrays.asList(tagPref.split(";"));
        }
        return Collections.EMPTY_LIST;
    }
}

