/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.createrepo.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.rpm.createrepo.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreaterepoNewWizardPageTwo
extends WizardPage {
    private Text repositoryIDTxt;
    private Text repositoryNameTxt;
    private Text repositoryBaseURLTxt;

    public CreaterepoNewWizardPageTwo(String pageName) {
        super(pageName);
        this.setTitle(Messages.CreaterepoNewWizardPageTwo_wizardPageTitle);
        this.setDescription(Messages.CreaterepoNewWizardPageTwo_wizardPageDescription);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)layoutData);
        Composite information = new Composite(container, 0);
        layout = new GridLayout(2, false);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 2;
        information.setLayoutData((Object)layoutData);
        information.setLayout((Layout)layout);
        ModifyListener modifyListner = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreaterepoNewWizardPageTwo.this.setPageComplete(CreaterepoNewWizardPageTwo.this.isValid());
            }
        };
        this.repositoryIDTxt = this.createTextFieldWithLabel(information, Messages.CreaterepoNewWizardPageTwo_labelID, Messages.CreaterepoNewWizardPageTwo_tooltipID);
        this.repositoryIDTxt.addModifyListener(modifyListner);
        this.repositoryNameTxt = this.createTextFieldWithLabel(information, Messages.CreaterepoNewWizardPageTwo_labelName, Messages.CreaterepoNewWizardPageTwo_tooltipName);
        this.repositoryNameTxt.addModifyListener(modifyListner);
        this.repositoryBaseURLTxt = this.createTextFieldWithLabel(information, Messages.CreaterepoNewWizardPageTwo_labelURL, Messages.CreaterepoNewWizardPageTwo_tooltipURL);
        this.repositoryBaseURLTxt.addModifyListener(modifyListner);
        this.setControl((Control)container);
    }

    protected Text createTextFieldWithLabel(Composite parent, String labelName, String tooltip) {
        Label respositoryBaseURLLbl = new Label(parent, 0);
        respositoryBaseURLLbl.setText(labelName);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 1;
        layoutData.verticalAlignment = 2;
        respositoryBaseURLLbl.setToolTipText(tooltip);
        Text textField = new Text(parent, 2052);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 2;
        textField.setLayoutData((Object)layoutData);
        textField.setToolTipText(tooltip);
        return textField;
    }

    protected boolean isValid() {
        if (!this.validateID()) {
            this.setErrorMessage(Messages.CreaterepoNewWizardPageTwo_errorID);
        }
        if (this.repositoryNameTxt.getText().trim().isEmpty()) {
            this.setErrorMessage(Messages.CreaterepoNewWizardPageTwo_errorName);
        }
        if (!this.validateURL()) {
            this.setErrorMessage(Messages.CreaterepoNewWizardPageTwo_errorURL);
        }
        if (this.validateID() && this.validateURL() && !this.repositoryNameTxt.getText().trim().isEmpty()) {
            this.setErrorMessage(null);
            return true;
        }
        return false;
    }

    private boolean validateID() {
        String tmpRepoID = this.repositoryIDTxt.getText().trim();
        Pattern singleStringPattern = Pattern.compile("\\b(\\S+)\\b", 2);
        Matcher singleStringMatcher = singleStringPattern.matcher(tmpRepoID);
        return singleStringMatcher.matches();
    }

    private boolean validateURL() {
        String tmpRepoURL = this.repositoryBaseURLTxt.getText().trim();
        try {
            new URL(tmpRepoURL);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public String getRepositoryID() {
        if (this.repositoryIDTxt == null) {
            return "";
        }
        return this.repositoryIDTxt.getText().trim();
    }

    public String getRepositoryName() {
        if (this.repositoryNameTxt == null) {
            return "";
        }
        return this.repositoryNameTxt.getText().trim();
    }

    public String getRepositoryURL() {
        if (this.repositoryBaseURLTxt == null) {
            return "";
        }
        return this.repositoryBaseURLTxt.getText().trim();
    }
}

