/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class UstMemoryStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private final Map<Long, Long> fMemory = new HashMap<Long, Long>();
    private static final Long MINUS_ONE = -1L;
    private static final Long ZERO = 0L;
    private static final String EMPTY_STRING = "";

    public UstMemoryStateProvider(@NonNull LttngUstTrace trace) {
        super((ITmfTrace)trace, "Ust:Memory");
    }

    protected void eventHandle(ITmfEvent event) {
        String name;
        switch (name = event.getName()) {
            case "ust_libc:malloc": {
                Long ptr = (Long)event.getContent().getField(new String[]{"ptr"}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{"size"}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
            case "ust_libc:free": {
                Long ptr = (Long)event.getContent().getField(new String[]{"ptr"}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                this.setMem(event, ptr, ZERO);
                break;
            }
            case "ust_libc:calloc": {
                Long ptr = (Long)event.getContent().getField(new String[]{"ptr"}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long nmemb = (Long)event.getContent().getField(new String[]{"nmemb"}).getValue();
                Long size = (Long)event.getContent().getField(new String[]{"size"}).getValue();
                this.setMem(event, ptr, size * nmemb);
                break;
            }
            case "ust_libc:realloc": {
                Long ptr = (Long)event.getContent().getField(new String[]{"ptr"}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long newPtr = (Long)event.getContent().getField(new String[]{"in_ptr"}).getValue();
                Long size = (Long)event.getContent().getField(new String[]{"size"}).getValue();
                this.setMem(event, ptr, ZERO);
                this.setMem(event, newPtr, size);
                break;
            }
            case "ust_libc:memalign": {
                Long ptr = (Long)event.getContent().getField(new String[]{"ptr"}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{"size"}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
            case "ust_libc:posix_memalign": {
                Long ptr = (Long)event.getContent().getField(new String[]{"out_ptr"}).getValue();
                if (ZERO.equals(ptr)) {
                    return;
                }
                Long size = (Long)event.getContent().getField(new String[]{"size"}).getValue();
                this.setMem(event, ptr, size);
                break;
            }
        }
    }

    public ITmfStateProvider getNewInstance() {
        return new UstMemoryStateProvider(this.getTrace());
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public int getVersion() {
        return 1;
    }

    private static Long getVtid(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{"context._vtid"});
        if (field == null) {
            return MINUS_ONE;
        }
        return (Long)field.getValue();
    }

    private static String getProcname(ITmfEvent event) {
        ITmfEventField field = event.getContent().getField(new String[]{"context._procname"});
        if (field == null) {
            return EMPTY_STRING;
        }
        return (String)field.getValue();
    }

    private void setMem(ITmfEvent event, Long ptr, Long size) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        long ts = event.getTimestamp().getValue();
        Long tid = UstMemoryStateProvider.getVtid(event);
        Long memoryDiff = size;
        if (ZERO.equals(size)) {
            Long memSize = this.fMemory.remove(ptr);
            if (memSize == null) {
                return;
            }
            memoryDiff = -memSize.longValue();
        } else {
            this.fMemory.put(ptr, size);
        }
        try {
            int tidQuark = ss.getQuarkAbsoluteAndAdd(new String[]{tid.toString()});
            int tidMemQuark = ss.getQuarkRelativeAndAdd(tidQuark, new String[]{"Memory"});
            ITmfStateValue prevMem = ss.queryOngoingState(tidMemQuark);
            if (prevMem.isNull()) {
                int procNameQuark = ss.getQuarkRelativeAndAdd(tidQuark, new String[]{"Procname"});
                String procName = UstMemoryStateProvider.getProcname(event);
                if (tid.equals(MINUS_ONE)) {
                    procName = "Others";
                }
                ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueString((String)procName), procNameQuark);
                prevMem = TmfStateValue.newValueLong((long)0L);
            }
            long prevMemValue = prevMem.unboxLong();
            ss.modifyAttribute(ts, (ITmfStateValue)TmfStateValue.newValueLong((long)(prevMemValue += memoryDiff.longValue())), tidMemQuark);
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            throw new IllegalStateException(e);
        }
    }
}

