/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.net.URI;
import org.eclipse.cdt.internal.ui.editor.CStorageDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.ExternalSearchAnnotationModel;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.editors.text.ILocationProviderExtension;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ExternalSearchDocumentProvider
extends TextFileDocumentProvider {
    public ExternalSearchDocumentProvider() {
        super((IDocumentProvider)new CStorageDocumentProvider());
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (info != null) {
            IAnnotationModel originalModel = info.fModel;
            IAnnotationModel externalSearchModel = this.createAnnotationModel(element);
            if (externalSearchModel != null) {
                info.fModel = externalSearchModel;
                IAnnotationModel fileBufferModel = info.fTextFileBuffer.getAnnotationModel();
                if (fileBufferModel != null) {
                    ((AnnotationModel)externalSearchModel).addAnnotationModel((Object)"fileBufferModel", fileBufferModel);
                }
                if (originalModel != null && originalModel != fileBufferModel) {
                    ((AnnotationModel)externalSearchModel).addAnnotationModel((Object)"originalModel", originalModel);
                }
            }
            if (info.fModel != null) {
                this.setUpSynchronization(info);
            }
        }
        return info;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        IAdaptable adaptable;
        ILocationProvider provider;
        IPath location;
        IStorage storage;
        if (element instanceof ExternalEditorInput) {
            return this.createExternalSearchAnnotationModel((ExternalEditorInput)element);
        }
        if (element instanceof IStorageEditorInput && (storage = ((IStorageEditorInput)element).getStorage()).getFullPath() != null) {
            return this.createExternalSearchAnnotationModel(storage.getFullPath(), null);
        }
        if (element instanceof IPathEditorInput && (location = ((IPathEditorInput)element).getPath()) != null) {
            return this.createExternalSearchAnnotationModel(location, null);
        }
        if (element instanceof IAdaptable && (provider = (ILocationProvider)(adaptable = (IAdaptable)element).getAdapter(ILocationProvider.class)) != null) {
            ILocationProviderExtension extendedProvider;
            URI uri;
            IPath location2 = provider.getPath(element);
            if (location2 != null) {
                return this.createExternalSearchAnnotationModel(location2, null);
            }
            if (provider instanceof ILocationProviderExtension && (location2 = URIUtil.toPath((URI)(uri = (extendedProvider = (ILocationProviderExtension)provider).getURI(element)))) != null) {
                return this.createExternalSearchAnnotationModel(location2, null);
            }
        }
        return null;
    }

    private IAnnotationModel createExternalSearchAnnotationModel(ExternalEditorInput externalInput) {
        IPath location = externalInput.getPath();
        if (location != null) {
            return this.createExternalSearchAnnotationModel(location, null);
        }
        return null;
    }

    private IAnnotationModel createExternalSearchAnnotationModel(IPath location, IResource markerResource) {
        ExternalSearchAnnotationModel model = null;
        if (markerResource != null) {
            model = new ExternalSearchAnnotationModel(markerResource, location);
        } else {
            markerResource = CUIPlugin.getWorkspace().getRoot();
            model = new ExternalSearchAnnotationModel(markerResource, location, 1);
        }
        return model;
    }
}

