/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.BusyCursorJobRunner;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.InteractiveHeaderChooser;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeOrganizer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class OrganizeIncludesAction
extends TextEditorAction {
    public OrganizeIncludesAction(ITextEditor editor) {
        super(CEditorMessages.getBundleForConstructedKeys(), "OrganizeIncludes.", editor);
        CUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.organize_includes_action");
    }

    public void run() {
        MultiTextEdit[] holder;
        ITextEditor editor = this.getTextEditor();
        final ITranslationUnit tu = OrganizeIncludesAction.getTranslationUnit(editor);
        if (tu == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        final InteractiveHeaderChooser headerChooser = new InteractiveHeaderChooser(CEditorMessages.OrganizeIncludes_label, editor.getSite().getShell());
        SharedASTJob job = new SharedASTJob(CEditorMessages.OrganizeIncludes_action, tu, holder = new MultiTextEdit[1]){
            private final /* synthetic */ MultiTextEdit[] val$holder;
            {
                this.val$holder = multiTextEditArray;
                super($anonymous0, $anonymous1);
            }

            @Override
            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                if (ast == null) {
                    return CUIPlugin.createErrorStatus(NLS.bind((String)CEditorMessages.OrganizeIncludes_ast_not_available, (Object)tu.getPath().toOSString()));
                }
                IIndex index = CCorePlugin.getIndexManager().getIndex(tu.getCProject(), 33);
                try {
                    index.acquireReadLock();
                    IncludeOrganizer organizer = new IncludeOrganizer(tu, index, headerChooser);
                    this.val$holder[0] = organizer.organizeIncludes(ast);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InterruptedException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    index.releaseReadLock();
                }
            }
        };
        IStatus status = BusyCursorJobRunner.execute(job);
        if (status.isOK()) {
            MultiTextEdit edit = holder[0];
            if (edit.hasChildren()) {
                IEditorInput editorInput = editor.getEditorInput();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
                IDocumentUndoManager manager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
                manager.beginCompoundChange();
                try {
                    edit.apply(document);
                }
                catch (MalformedTreeException e) {
                    CUIPlugin.log(e);
                }
                catch (BadLocationException e) {
                    CUIPlugin.log(e);
                }
                manager.endCompoundChange();
            }
        } else if (status.matches(4)) {
            ErrorDialog.openError((Shell)editor.getEditorSite().getShell(), (String)CEditorMessages.OrganizeIncludes_error_title, (String)CEditorMessages.OrganizeIncludes_insertion_failed, (IStatus)status);
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        this.setEnabled(editor != null && OrganizeIncludesAction.getTranslationUnit(editor) != null);
    }

    private static ITranslationUnit getTranslationUnit(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
    }
}

