/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.dom.parser.AbstractCLikeLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.corext.util.Resources;
import org.eclipse.cdt.internal.ui.refactoring.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;

public class Checks {
    private Checks() {
    }

    public static boolean startsWithUpperCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toUpperCase(s.charAt(0));
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static RefactoringStatus checkIdentifier(String name, ITranslationUnit context) {
        return Checks.checkName(name, Checks.validateIdentifier(name, context));
    }

    public static IStatus validateIdentifier(String name, ITranslationUnit context) {
        ILanguage language = null;
        try {
            if (context != null) {
                language = context.getLanguage();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (language == null) {
            language = GPPLanguage.getDefault();
        }
        if (language instanceof AbstractCLikeLanguage) {
            return CConventions.validateIdentifier((String)name, (AbstractCLikeLanguage)((AbstractCLikeLanguage)language));
        }
        return Status.OK_STATUS;
    }

    public static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if (name.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.Checks_choose_name);
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static boolean isReadOnly(Object element) throws CModelException {
        if (element instanceof IResource) {
            return Checks.isReadOnly((IResource)element);
        }
        if (element instanceof ICElement) {
            return Checks.isReadOnly(((ICElement)element).getResource());
        }
        Assert.isTrue((boolean)false, (String)"Not expected to get here");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadOnly(IResource res) throws CModelException {
        ResourceAttributes attributes = res.getResourceAttributes();
        if (attributes != null && attributes.isReadOnly()) {
            return true;
        }
        if (!(res instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)res;
        try {
            IResource[] children = container.members();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return false;
                }
                if (Checks.isReadOnly(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(Messages.Checks_validate_edit);
            }
        }
        return result;
    }

    public static void addModifiedFilesToChecker(IFile[] filesToModify, CheckConditionsContext context) {
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        int i = 0;
        while (i < filesToModify.length) {
            deltaFactory.change(filesToModify[i]);
            ++i;
        }
    }

    public static RefactoringStatus validateEdit(ITranslationUnit tu, Object context) {
        IResource resource = CModelUtil.toOriginal(tu).getResource();
        RefactoringStatus result = new RefactoringStatus();
        if (resource == null) {
            return result;
        }
        IStatus status = Resources.checkInSync(resource);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable(resource, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(Messages.Checks_validate_edit);
            }
        }
        return result;
    }
}

