/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.rewrite.MacroExpansionExplorer;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.AbstractCompareViewerInformationControl;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.c.hover.CHoverMessages;
import org.eclipse.cdt.internal.ui.text.c.hover.CMacroCompareViewer;
import org.eclipse.cdt.internal.ui.text.c.hover.CMacroExpansionInput;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditor;

public class CMacroExpansionExplorationControl
extends AbstractCompareViewerInformationControl {
    private static final String COMMAND_ID_EXPANSION_BACK = "org.eclipse.cdt.ui.hover.backwardMacroExpansion";
    private static final String COMMAND_ID_EXPANSION_FORWARD = "org.eclipse.cdt.ui.hover.forwardMacroExpansion";
    private static final String CONTEXT_ID_MACRO_EXPANSION_HOVER = "org.eclipse.cdt.ui.macroExpansionHoverScope";
    public static final String KEY_CONTROL_BOUNDS = "org.eclipse.cdt.ui.text.hover.CMacroExpansionExploration";
    private static final String KEY_CONTROL_BOUNDS_INTERNAL = "org.eclipse.cdt.ui.text.hover.CMacroExpansionExploration.internal";
    private static final int MIN_WIDTH = 320;
    private static final int MIN_HEIGHT = 180;
    private IHandlerService fHandlerService;
    private Collection<IHandlerActivation> fHandlerActivations;
    private IContextService fContextService;
    private IContextActivation fContextActivation;
    private int fIndex;
    private CMacroExpansionInput fInput;
    private CMacroCompareViewer fMacroCompareViewer;
    private ISourceViewer fMacroViewer;
    private StyledText fMacroText;
    private boolean fRestoreSize;
    private Point fDefaultSize;
    private ScrolledComposite fTextScroller;

    public CMacroExpansionExplorationControl(Shell parent, CMacroExpansionInput input) {
        super(parent, new ToolBarManager(0x800000));
        this.setMacroExpansionInput(input);
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                CMacroExpansionExplorationControl.this.registerCommandHandlers();
            }

            public void focusLost(FocusEvent e) {
                CMacroExpansionExplorationControl.this.unregisterCommandHandlers();
            }
        });
        this.getShell().addListener(21, new Listener(){

            public void handleEvent(Event event) {
                CMacroExpansionExplorationControl.this.widgetClosed();
            }
        });
        this.fillToolBar();
        this.setDefaultSize(320, 180);
    }

    public CMacroExpansionExplorationControl(Shell parent) {
        this(parent, (CMacroExpansionInput)null);
    }

    public CMacroExpansionExplorationControl(Shell parent, boolean restoreSize) {
        this(parent, (CMacroExpansionInput)null);
        this.fRestoreSize = restoreSize;
        if (restoreSize) {
            this.restoreSize();
        }
    }

    private void restoreSize() {
        String sectionName = KEY_CONTROL_BOUNDS_INTERNAL;
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            return;
        }
        try {
            int width = settings.getInt("size.width");
            int height = settings.getInt("size.height");
            this.setDefaultSize(width, height);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void setDefaultSize(int width, int height) {
        this.fDefaultSize = new Point(width, height);
    }

    private void storeSize() {
        Shell shell = this.getShell();
        if (shell == null) {
            return;
        }
        String sectionName = KEY_CONTROL_BOUNDS_INTERNAL;
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        Point size = shell.getSize();
        settings.put("size.width", size.x);
        settings.put("size.height", size.y);
    }

    @Override
    protected boolean hasHeader() {
        return true;
    }

    @Override
    protected AbstractCompareViewerInformationControl.CompareViewerControl createCompareViewerControl(Composite parent, int style, CompareConfiguration compareConfig) {
        Splitter splitter = new Splitter(parent, 512);
        splitter.setLayoutData((Object)new GridData(1808));
        this.fTextScroller = new ScrolledComposite((Composite)splitter, 768);
        this.fMacroViewer = this.createSourceViewer((Composite)this.fTextScroller, style);
        StyledText textWidget = this.fMacroViewer.getTextWidget();
        this.fTextScroller.setBackground(textWidget.getBackground());
        this.fTextScroller.setContent((Control)textWidget);
        Point size = textWidget.computeSize(-1, -1);
        textWidget.setSize(size);
        AbstractCompareViewerInformationControl.CompareViewerControl control = super.createCompareViewerControl((Composite)splitter, style, compareConfig);
        splitter.setWeights(new int[]{20, 80});
        return control;
    }

    @Override
    protected Viewer createContentViewer(Composite parent, ICompareInput input, CompareConfiguration cc) {
        this.fMacroCompareViewer = new CMacroCompareViewer(parent, 0, cc);
        if (this.fInput != null) {
            this.fMacroCompareViewer.setMacroExpansionInput(this.fInput);
            this.fMacroCompareViewer.setMacroExpansionStep(this.fIndex);
        }
        return this.fMacroCompareViewer;
    }

    protected ISourceViewer createSourceViewer(Composite parent, int style) {
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CSourceViewer sourceViewer = new CSourceViewer(parent, null, null, false, style, store);
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        sourceViewer.configure((SourceViewerConfiguration)new SimpleCSourceViewerConfiguration(tools.getColorManager(), store, null, "___c_partitioning", false));
        sourceViewer.setEditable(false);
        this.fMacroText = sourceViewer.getTextWidget();
        Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        this.fMacroText.setFont(font);
        GridData gd = new GridData(1809);
        gd.heightHint = this.fMacroText.getLineHeight() * 2;
        this.fMacroText.setLayoutData((Object)gd);
        Document doc = new Document();
        CUIPlugin.getDefault().getTextTools().setupCDocument((IDocument)doc);
        sourceViewer.setDocument((IDocument)doc);
        return sourceViewer;
    }

    protected void unregisterCommandHandlers() {
        if (this.fHandlerService != null) {
            this.fHandlerService.deactivateHandlers(this.fHandlerActivations);
            this.fHandlerActivations.clear();
            this.fHandlerService = null;
        }
        if (this.fContextActivation != null) {
            this.fContextService.deactivateContext(this.fContextActivation);
            this.fContextActivation = null;
        }
    }

    protected void registerCommandHandlers() {
        if (this.fContextActivation != null) {
            return;
        }
        AbstractHandler backwardHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                CMacroExpansionExplorationControl.this.backward();
                return null;
            }
        };
        AbstractHandler forwardHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                CMacroExpansionExplorationControl.this.forward();
                return null;
            }
        };
        AbstractHandler gotoDefinitionHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                CMacroExpansionExplorationControl.this.gotoMacroDefinition();
                return null;
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.fHandlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        this.fContextService = (IContextService)workbench.getService(IContextService.class);
        this.fContextActivation = this.fContextService.activateContext(CONTEXT_ID_MACRO_EXPANSION_HOVER);
        this.fHandlerActivations = new ArrayList<IHandlerActivation>();
        this.fHandlerActivations.add(this.fHandlerService.activateHandler(COMMAND_ID_EXPANSION_BACK, (IHandler)backwardHandler));
        this.fHandlerActivations.add(this.fHandlerService.activateHandler(COMMAND_ID_EXPANSION_FORWARD, (IHandler)forwardHandler));
        this.fHandlerActivations.add(this.fHandlerService.activateHandler("org.eclipse.cdt.ui.edit.opendecl", (IHandler)gotoDefinitionHandler));
        String infoText = this.getInfoText();
        if (infoText != null) {
            this.setStatusText(infoText);
            PixelConverter converter = new PixelConverter((Control)this.getShell());
            Point pt = this.getShell().getSize();
            int stringLengthInPixel = converter.convertWidthInCharsToPixels(infoText.length() + 5);
            if (pt.x < stringLengthInPixel) {
                this.getShell().setSize(new Point(stringLengthInPixel, pt.y));
            }
        }
    }

    private void fillToolBar() {
        ToolBarManager mgr = this.getToolBarManager();
        if (mgr == null) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        CommandContributionItemParameter param = new CommandContributionItemParameter((IServiceLocator)workbench, null, COMMAND_ID_EXPANSION_BACK, 8);
        param.icon = CPluginImages.DESC_ELCL_NAVIGATE_BACKWARD;
        mgr.add((IContributionItem)new CommandContributionItem(param));
        param = new CommandContributionItemParameter((IServiceLocator)workbench, null, COMMAND_ID_EXPANSION_FORWARD, 8);
        param.icon = CPluginImages.DESC_ELCL_NAVIGATE_FORWARD;
        mgr.add((IContributionItem)new CommandContributionItem(param));
        param = new CommandContributionItemParameter((IServiceLocator)workbench, null, "org.eclipse.cdt.ui.edit.opendecl", 8);
        param.icon = CPluginImages.DESC_ELCL_OPEN_DECLARATION;
        mgr.add((IContributionItem)new CommandContributionItem(param));
        mgr.update(true);
    }

    protected final void gotoMacroDefinition() {
        int index = this.fIndex < this.getStepCount() ? this.fIndex : 0;
        MacroExpansionExplorer.IMacroExpansionStep step = this.fInput.fExplorer.getExpansionStep(index);
        IASTFileLocation fileLocation = step.getLocationOfExpandedMacroDefinition();
        if (fileLocation != null) {
            Path path = new Path(fileLocation.getFileName());
            int offset = fileLocation.getNodeOffset();
            int length = fileLocation.getNodeLength();
            try {
                IEditorPart editor = EditorUtility.openInEditor((IPath)path, null);
                if (editor instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    textEditor.selectAndReveal(offset, length);
                }
                this.dispose();
            }
            catch (PartInitException exc) {
                CUIPlugin.log(exc);
            }
        }
    }

    protected final void forward() {
        this.fIndex = this.fixIndex(this.fIndex + 1);
        if (this.fIndex > this.getStepCount()) {
            this.fIndex = 0;
        }
        this.showExpansion();
    }

    protected final void backward() {
        --this.fIndex;
        if (this.fIndex < 0) {
            this.fIndex = this.fixIndex(this.getStepCount());
        }
        this.showExpansion();
    }

    private String getInfoText() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IBindingService bindingService = (IBindingService)workbench.getService(IBindingService.class);
        String formattedBindingBack = bindingService.getBestActiveBindingFormattedFor(COMMAND_ID_EXPANSION_BACK);
        String formattedBindingForward = bindingService.getBestActiveBindingFormattedFor(COMMAND_ID_EXPANSION_FORWARD);
        String infoText = null;
        if (formattedBindingBack != null && formattedBindingForward != null) {
            infoText = NLS.bind((String)CHoverMessages.CMacroExpansionControl_statusText, (Object)formattedBindingBack, (Object)formattedBindingForward);
        }
        return infoText;
    }

    @Override
    public void dispose() {
        this.unregisterCommandHandlers();
        super.dispose();
    }

    public boolean restoresLocation() {
        return true;
    }

    public boolean restoresSize() {
        return true;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        Point constraints = this.getSizeConstraints();
        if (constraints != null) {
            super.setSizeConstraints(Math.max(constraints.x, maxWidth), Math.max(constraints.y, maxHeight));
        } else {
            super.setSizeConstraints(maxWidth, maxHeight);
        }
    }

    public void setSize(int width, int height) {
        if (this.fDefaultSize != null) {
            width = Math.max(this.fDefaultSize.x, width);
            height = Math.max(this.fDefaultSize.y, height);
            this.fDefaultSize = null;
        }
        super.setSize(width, height);
    }

    @Override
    public void setInput(Object input) {
        if (input instanceof CMacroExpansionInput) {
            this.setMacroExpansionInput((CMacroExpansionInput)input);
        } else if (input != null) {
            if (this.fMacroCompareViewer != null) {
                this.fMacroCompareViewer.setMacroExpansionStep(this.fIndex);
            }
            super.setInput(input);
        } else {
            this.setMacroExpansionInput(null);
            super.setInput(input);
        }
    }

    private void widgetClosed() {
        if (this.fRestoreSize) {
            this.storeSize();
            this.fRestoreSize = false;
        }
        this.unregisterCommandHandlers();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.fRestoreSize) {
            this.storeSize();
            this.fRestoreSize = false;
        }
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    @Override
    public Rectangle computeTrim() {
        Rectangle trim = super.computeTrim();
        this.addInternalTrim(trim);
        return trim;
    }

    private void addInternalTrim(Rectangle trim) {
        Rectangle textTrim = this.fMacroText.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
    }

    private void setMacroExpansionInput(CMacroExpansionInput input) {
        this.fInput = input;
        if (this.fMacroCompareViewer != null) {
            this.fMacroCompareViewer.setMacroExpansionInput(input);
        }
        if (this.fInput != null) {
            this.fIndex = this.fixIndex(input.fStartWithFullExpansion ? this.getStepCount() : 0);
            this.showExpansion();
        }
    }

    private int fixIndex(int index) {
        if (this.getStepCount() == 1 && index == 1) {
            return 0;
        }
        return index;
    }

    private int getStepCount() {
        return this.fInput.fExplorer.getExpansionStepCount();
    }

    private void showExpansion() {
        int idxLeft = this.fIndex == this.getStepCount() ? 0 : this.fIndex;
        int idxRight = this.fIndex + 1;
        CompareConfiguration config = this.getCompareConfiguration();
        config.setLeftLabel(this.getLabelForIndex(idxLeft));
        config.setRightLabel(this.getLabelForIndex(idxRight));
        ITypedElement left = this.getContentForIndex(this.fIndex, true);
        ITypedElement right = this.getContentForIndex(this.fIndex, false);
        this.setTitleText(NLS.bind((String)CHoverMessages.CMacroExpansionControl_title_macroExpansionExploration, (Object)this.getStepCount()));
        this.fMacroViewer.getDocument().set(this.getMacroText(this.fIndex));
        StyledText textWidget = this.fMacroViewer.getTextWidget();
        Point size = textWidget.computeSize(-1, -1);
        textWidget.setSize(size);
        this.setInput(this.createCompareInput(null, left, right));
    }

    private String getLabelForIndex(int index) {
        if (index == 0) {
            return CHoverMessages.CMacroExpansionControl_title_original;
        }
        if (index < this.getStepCount()) {
            return NLS.bind((String)CHoverMessages.CMacroExpansionControl_title_expansion, (Object)String.valueOf(index), (Object)String.valueOf(this.getStepCount()));
        }
        return CHoverMessages.CMacroExpansionControl_title_fullyExpanded;
    }

    private Object createCompareInput(ITypedElement original, ITypedElement left, ITypedElement right) {
        Differencer d = new Differencer();
        return d.findDifferences(false, (IProgressMonitor)new NullProgressMonitor(), null, (Object)original, (Object)left, (Object)right);
    }

    private ITypedElement getContentForIndex(int index, boolean before) {
        MacroExpansionExplorer.IMacroExpansionStep expansionStep = index < this.getStepCount() ? this.fInput.fExplorer.getExpansionStep(index) : this.fInput.fExplorer.getFullExpansion();
        String text = before ? expansionStep.getCodeBeforeStep() : expansionStep.getCodeAfterStep();
        Document doc = new Document(text);
        CUIPlugin.getDefault().getTextTools().setupCDocument((IDocument)doc);
        return new CDiffNode(0, String.valueOf(index), (IDocument)doc, 0, text.length());
    }

    private String getMacroText(int index) {
        index = index < this.getStepCount() ? index : 0;
        MacroExpansionExplorer.IMacroExpansionStep expansionStep = this.fInput.fExplorer.getExpansionStep(index);
        IMacroBinding binding = expansionStep.getExpandedMacro();
        StringBuffer buffer = new StringBuffer();
        buffer.append("#define ").append(binding.getName());
        char[][] params = binding.getParameterList();
        if (params != null) {
            buffer.append('(');
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                char[] param = params[i];
                buffer.append(new String(param));
                ++i;
            }
            buffer.append(')');
        }
        buffer.append(' ');
        if (!binding.isDynamic()) {
            buffer.append(binding.getExpansionImage());
        } else {
            ReplaceEdit[] replacements = expansionStep.getReplacements();
            if (replacements.length == 1) {
                buffer.append(replacements[0].getText());
            }
        }
        return buffer.toString();
    }

    private static class CDiffNode
    extends DocumentRangeNode
    implements ITypedElement {
        public CDiffNode(DocumentRangeNode parent, int type, String id, IDocument doc, int start, int length) {
            super(parent, type, id, doc, start, length);
        }

        public CDiffNode(int type, String id, IDocument doc, int start, int length) {
            super(type, id, doc, start, length);
        }

        public String getName() {
            return this.getId();
        }

        public String getType() {
            return "c2";
        }

        public Image getImage() {
            return null;
        }
    }
}

