/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.remote.internal.jsch.core.JSchFileSystem;
import org.eclipse.remote.internal.jsch.core.JschFileStore;

public class JSchFileManager
implements IRemoteFileService {
    private final IRemoteConnection fConnection;

    public JSchFileManager(IRemoteConnection connection) {
        this.fConnection = connection;
    }

    public IRemoteConnection getRemoteConnection() {
        return this.fConnection;
    }

    public String getDirectorySeparator() {
        return "/";
    }

    public IFileStore getResource(String pathStr) {
        IPath path = RemoteServicesUtils.posixPath((String)pathStr);
        if (!path.isAbsolute()) {
            path = RemoteServicesUtils.posixPath((String)this.getBaseDirectory()).append(path);
        }
        return JschFileStore.getInstance(JSchFileSystem.getURIFor(this.fConnection.getName(), path.toString()));
    }

    public String getBaseDirectory() {
        return ((IRemoteProcessService)this.fConnection.getService(IRemoteProcessService.class)).getWorkingDirectory();
    }

    public void setBaseDirectory(String path) {
        ((IRemoteProcessService)this.fConnection.getService(IRemoteProcessService.class)).setWorkingDirectory(path);
    }

    public String toPath(URI uri) {
        return uri.getPath();
    }

    public URI toURI(IPath path) {
        try {
            return JSchFileSystem.getURIFor(this.fConnection.getName(), path.toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URI toURI(String path) {
        return this.toURI(RemoteServicesUtils.posixPath((String)path));
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (IRemoteFileService.class.equals(service)) {
                return (T)new JSchFileManager(remoteConnection);
            }
            return null;
        }
    }
}

